/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_insert.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/23
 *    Last                 : 2003/03/23
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_Undo.h"
//#include "etc.h"

#define _LIST_INSERT_
#include "List_insert.h"





int init_insert(INSERT *insert)
{
	/* INSERT Data ν */
	strcpy(insert->name, "None");
	insert->layer = 0;
	insert->color = 0xffffff;
	insert->style = 0;

	insert->x = 0;
	insert->y = 0;
	insert->angle = 0;
	insert->x_scale = 1;
	insert->y_scale = 1;

	insert->x_num = 0;
	insert->y_num = 0;
	insert->x_pitch = 0;
	insert->y_pitch = 0;
	return 1;
}





/* -------------------------------------------------------------------
 * ΰݺѤߤ INSERT Data ꥹȤκǽɲ
 * 
 */
INSERT_LIST *r_insert_list_add_first(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));

	/* ݤΰ˥ǡ (insert) 񤭹 */
	p_insert_list->insert = add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_insert_list_info->head;
		p_insert_list_info->head = p_insert_list;
		p_insert_list->next = p;
	}

	return p_insert_list_info->head;
}





/* -------------------------------------------------------------------
 * INSERT Data ꥹȤκǽɲ
 * 
 */
INSERT_LIST *insert_list_add_first(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* ǡ (insert) 񤭹िΰݤ */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* ݤΰ˥ǡ (insert) 񤭹 */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_insert_list_info->head;
		p_insert_list_info->head = p_insert_list;
		p_insert_list->next = p;
	}

	return p_insert_list_info->head;
}





/* -------------------------------------------------------------------
 * INSERT Data ꥹȤκǽɲäơ Undo Baffer ˽
 *	
 */
INSERT_LIST *insert_list_add_first_with_undo(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	INSERT insert = {"",0,0,0, 0,0,0,0,0, 0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* ǡ (insert) 񤭹िΰݤ */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* ݤΰ˥ǡ (insert) 񤭹 */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_insert_list_info->head;
		p_insert_list_info->head = p_insert_list;
		p_insert_list->next = p;
	}

	lpdiagram.insert_point = p_insert_list_info->head->insert;
	diagram.insert = insert;

	/* Undo Buffa Write */
	undo_list_add_first(INSERT_NEW, lpdiagram, diagram);
	return p_insert_list_info->head;
}





/* -------------------------------------------------------------------
 * INSERT Data ꥹȤκǸɲ
 * 
 */
INSERT_LIST *insert_list_add_last(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* ǡ (insert) 񤭹िΰݤ */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* ݤΰ˥ǡ (insert) 񤭹 */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_insert_list_info->head != NULL 
				&& p_insert_list_info->tail != NULL 
					&& p_insert_list_info->head == p_insert_list_info->tail) {
		p_insert_list_info->head->next = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_insert_list_info->tail;
		p_insert_list_info->tail = p_insert_list;
		p->next = p_insert_list_info->tail;
	}

	/* ɥХåե˽ */
//	undo_list_add_first(11, p_insert_list_info->tail, NULL);
	return p_insert_list_info->tail;
}





/* -------------------------------------------------------------------
 * INSERT Data ꥹȤκǸɲá Undo Baffer ˽
 *	
 */
INSERT_LIST *insert_list_add_last_with_undo(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	INSERT insert = {"",0,0,0, 0,0,0,0,0, 0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));
	/* ǡ (insert) 񤭹िΰݤ */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* ݤΰ˥ǡ (insert) 񤭹 */
	*p_insert_list->insert = *add_insert;
	p_insert_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_insert_list_info->head == NULL && p_insert_list_info->tail == NULL) {
		p_insert_list_info->head = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_insert_list_info->head != NULL 
				&& p_insert_list_info->tail != NULL 
					&& p_insert_list_info->head == p_insert_list_info->tail) {
		p_insert_list_info->head->next = p_insert_list;
		p_insert_list_info->tail = p_insert_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_insert_list_info->tail;
		p_insert_list_info->tail = p_insert_list;
		p->next = p_insert_list_info->tail;
	}

	lpdiagram.insert_point = p_insert_list_info->tail->insert;
	diagram.insert = insert;

	/* Undo Buffa Write */
	undo_list_add_first(INSERT_NEW, lpdiagram, diagram);
	return p_insert_list_info->tail;
}





/* -------------------------------------------------------------------
 * INSERT Data κǽ (κǤϤʤ)
 * 
 */
int insert_list_delete(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p = NULL;
	INSERT_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == p_insert_list_info->head && del_List->next == NULL) {
		p_insert_list_info->head = NULL;
		p_insert_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_insert_list_info->head && del_List->next != NULL) {
		p_insert_list_info->head = p_insert_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_insert_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}

		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_insert_list_info->tail) {
				pb->next = NULL;
				p_insert_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_insert_list_info->head && del_List != p_insert_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_insert.c : insert_list_delete() : There is not data of structure data INSERT.\n");
			return 0;
		}
	}
	xfree(del_List);
//	StartData = p_insert_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * INSERT Data κǽ (κǤϤʤUndo Buffer ذܤ)
 * 
 */
int insert_list_delete_Undo(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p = NULL;
	INSERT_LIST *pb = NULL;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡƬǣĤ  */
	if (del_List == p_insert_list_info->head && del_List->next == NULL) {
		p_insert_list_info->head = NULL;
		p_insert_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_insert_list_info->head && del_List->next != NULL) {
		p_insert_list_info->head = p_insert_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_insert_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}

		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_insert_list_info->tail) {
				pb->next = NULL;
				p_insert_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_insert_list_info->head && del_List != p_insert_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_insert.c : insert_list_delete() : There is not data of structure data INSERT.\n");
			return 0;
		}
	}

	lpdiagram.insert_point = del_List->insert;
	diagram.insert = *del_List->insert;

	undo_list_add_first(INSERT_DEL, lpdiagram, diagram);
	xfree(del_List);
//	StartData = p_insert_list_info->head;
	return 1;
}





/* -------------------------------------------------------------------
 * INSERT Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ롣
 *	
 * ͡ΥǡΥɥ쥹
 */
INSERT_LIST *insert_list_edit(INSERT_LIST *point, INSERT *change_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	/* ǡ (LIST) 񤭹िΰݤ */
	p_insert_list = (INSERT_LIST *)xmalloc(sizeof(INSERT_LIST));

	/* ǡ (insert) 񤭹िΰݤ */
	p_insert_list->insert = (INSERT *)xmalloc(sizeof(INSERT));

	/* ݤΰѹΥǡ (insert) 񤭹 */
	*p_insert_list->insert = *point->insert;
	p_insert_list->next = point;

	/* ѹǡ񤭹 */
	*point->insert = *change_insert;

//	undo_list_add_first(13, p_insert_list, NULL);
	return p_insert_list;
}





/* -------------------------------------------------------------------
 * INSERT Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ졢Undo Baffer ˽
 *	
 * ͡ΥǡΥɥ쥹
 */
INSERT_LIST *insert_list_edit_with_undo(INSERT_LIST *point, INSERT *change_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT insert = {"",0,0,0, 0,0,0,0,0, 0,0,0,0};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ݤΰѹΥǡ (INSERT) 񤭹 */
	insert = *point->insert;

	/* ѹǡ񤭹 */
	*point->insert = *change_insert;

	lpdiagram.insert_point = point->insert;
	diagram.insert = insert;

	undo_list_add_first(INSERT_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 *	ꥹȤĴ٤
 */
long insert_list_num(INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	long i;

	p = p_insert_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n ܤΥǡθ
 * 
 */
INSERT_LIST *insert_search_num(long search_number, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	long i;


	p = p_insert_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * INSERT Υǡθ
 * 
 *   INSERT_LIST
 */
INSERT_LIST *insert_search_insert(INSERT *p_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;


	p = p_insert_list_info->head;
	/*	*/
	while( p != NULL && p->insert != p_insert) {
		p = p->next;
	}

	/* p_insert ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * INSERT Υǡθ
 * 
 *   long
 */
long insert_search_insert_to_num(INSERT *p_insert, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	long i;

	i = 1;
	p = p_insert_list_info->head;
	/*	*/
	while( p != NULL && p->insert != p_insert) {
		p = p->next;
		i++;
	}

	/* p_insert ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	INSERT Data ꥹȤ
 */
int insert_list_free(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p = NULL;
	INSERT_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == p_insert_list_info->head && del_List->next == NULL) {
		p_insert_list_info->head = NULL;
		p_insert_list_info->tail = NULL;
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_insert_list_info->head && del_List->next != NULL) {
		p_insert_list_info->head = p_insert_list_info->head->next;
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_insert_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_insert_list_info->tail) {
				pb->next = NULL;
				p_insert_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_insert_list_info->head && del_List != p_insert_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			g_print("List_insert.c : insert_list_free() : There is not data of structure data INSERT.\n");
			return 0;
		}
	}
	xfree(del_List->insert);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 *	ꥹȤ
 */
void insert_list_all_free(INSERT_LIST_INFO *p_insert_list_info)
{
	while(p_insert_list_info->head != NULL) {
		if (insert_list_free(p_insert_list_info->head, p_insert_list_info) == 0) {
			g_print("List_insert.c : insert_list_all_free() : insert_list_free() ǥ顼\n");
			g_print("%s : %d : insert_list_all_free() : ERROR\n", __FILE__, __LINE__);
		}
	}
}





void insert_list_print(INSERT_LIST_INFO *p_insert_list_info)
{
	INSERT_LIST *p;
	int i = 0;

	g_print("----- INSERT ꥹȤɽ -----\n");
	p = p_insert_list_info->head;
	while (p != NULL) {
		i++;
		g_print("%d(0x%x) : name[%s] : layer[%d] : color[%d] : style[0x%x]\n(%f,%f) %f scale(%f,%f) Ŀ(%d,%d) pitch(%f,%f)\n", 
					i, (int)p->insert, p->insert->name, 
					p->insert->layer, (int)p->insert->color, p->insert->style, 
					p->insert->x, p->insert->y, p->insert->angle, 
					p->insert->x_scale, p->insert->y_scale, 
					p->insert->x_num, p->insert->y_num, 
					p->insert->x_pitch, p->insert->y_pitch);
		p = p->next;
	}
	g_print("-----------------------------\n");
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_insert.c
 * ====================================================================
 */
