/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : MsgBox.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2002/06/25
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#define MSGBOX
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "MsgBox.h"


/* -------------------------------------------------------
 * 
 */
gint MsgBox(const char *title, const char *message1, const char *message2,	
		char *button1, char *button2, char *button3)
{
	char *defaultbutton = "OK";
	msg_box *mbox;
	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *button;
	int x;
	int y;
	int width;
	int height;
	int dlg_width;
	int dlg_height;
	int dlg_pos_x;
	int dlg_pos_y;



	mbox = (msg_box *)g_malloc(sizeof(msg_box));

	/*  */
	mbox->dialog = gtk_dialog_new();

	gtk_window_set_position( GTK_WINDOW(mbox->dialog), GTK_WIN_POS_CENTER );

	gtk_window_set_title(GTK_WINDOW(mbox->dialog), title);

	vbox = GTK_DIALOG(mbox->dialog)->vbox;

	/* ܤΥ٥դ */
	if (message1 != NULL) {
		label = gtk_label_new(message1);
		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* ܤΥ٥դ */
	if (message2 != NULL) {
		label = gtk_label_new(message2);
		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* ܥ¤٤ */
	if (!button1 && !button2 && !button3)
		button3 = defaultbutton;

	if (button1 != NULL) {
		button = gtk_button_new_with_label(button1);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(mbox->dialog)->action_area),	
				   button, TRUE, TRUE, 2);
		gtk_object_set_data(GTK_OBJECT(button), "value", (gpointer)1);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(set_value), mbox);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		gtk_widget_show(button);
	}

	if(button2 != NULL) {
		button = gtk_button_new_with_label(button2);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(mbox->dialog)->action_area),	
				   button, TRUE, TRUE, 2);
		gtk_object_set_data(GTK_OBJECT(button), "value", (gpointer)0);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(set_value), mbox);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		gtk_widget_show(button);
  }

	if(button3 != NULL) {
		button = gtk_button_new_with_label(button3);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(mbox->dialog)->action_area),	
				   button, TRUE, TRUE, 2);
		gtk_object_set_data(GTK_OBJECT(button), "value", (gpointer)-1);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(set_value), mbox);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		gtk_widget_show(button);
	}

//	gtk_widget_show(mbox->dialog);


	if (MainWindow != NULL) {
		/* ᥤ󥦥ɥθ˱Ƥޤʤ褦 */
		gtk_window_set_transient_for(GTK_WINDOW(mbox->dialog), GTK_WINDOW(MainWindow));

		/* ᥤ󥦥ɥ֤ */
		/* ᥤ󥦥ɥΰ֤ȥ */
		gdk_window_get_position(MainWindow->window, &x, &y);
		gdk_window_get_size(MainWindow->window, &width, &height);
		//g_print("MainWindow position x = %d   y = %d\n", x, y);
		//g_print("MainWindow size width = %d   hight = %d\n", width, height);
		/* MsgBox Υ */
		gtk_widget_realize(mbox->dialog);
		gdk_window_get_size(mbox->dialog->window, &dlg_width, &dlg_height);
		//g_print("MsgBox size width = %d   hight = %d\n", dlg_width, dlg_height);
		/* MsgBox ΰ֤Ĵ */
		dlg_pos_x = x + (width - dlg_width) / 2;
		dlg_pos_y = y + (height - dlg_height) / 2;
		gtk_widget_set_uposition(	mbox->dialog,
									(dlg_pos_x > 0) ? dlg_pos_x : 0,
									(dlg_pos_y > 0) ? dlg_pos_y : 0);
	}
	gtk_widget_show(mbox->dialog);

	/* ⡼ˤ */
	gtk_window_set_modal(GTK_WINDOW(mbox->dialog), TRUE);

	gtk_grab_add(mbox->dialog);
	gtk_main();
	gtk_grab_remove(mbox->dialog);
	gtk_widget_destroy(mbox->dialog);
	return mbox->value; 
}





/* -------------------------------------------------------
 * 
 */
void set_value(GtkWidget *widget, msg_box *mbox)
{
	mbox->value = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));
}



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SAgCAD
 *    Description          : CAD/CAM
 *    Source               : MsgBox.c
 * ====================================================================
 */
