/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : TrimFunc.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __TRIMFUNC_H__
#define __TRIMFUNC_H__

//#include <>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */
	// ȥѿ
	struct TrimDat
	{
		int Index;		// 1:ȥ    2:ξȥ
		CAD TraceData[4];	// ޷ǡ(1-3) ʱߤλ code = 2048
		ELLIPSE ellipse[4];
		double PicX[4];		// ԥå(1-3)
		double PicY[4];		// ԥå(1-3)
		double pointX1;
		double pointY1;
		double pointX2;
		double pointY2;
	};



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef	  _TRIMFUNC_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef	_TRIMFUNC_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int TrimMain(struct TrimDat *a);

int TrimL(struct TrimDat *a, double *x, double *y);
int TrimL_Point(struct TrimDat a, double *x, double *y);
int TrimL_Line(struct TrimDat a, double *x, double *y);
int TrimL_AC(struct TrimDat a, double *x, double *y);
int TrimL_E(struct TrimDat a, double *x, double *y);
int TrimL_Run(struct TrimDat *a, double x, double y);

int TrimA(struct TrimDat *a, double *x, double *y);
int TrimA_Pull(struct TrimDat *a, double x, double y);
int TrimA_Run(struct TrimDat *a, double x, double y);

int TrimC_Point(struct TrimDat a, double *x, double *y, int frag);
int TrimC_Line(struct TrimDat a, double *x, double *y, int frag);
int TrimC_AC(struct TrimDat a, double *x, double *y, int frag);
int TrimC_Ellipse(struct TrimDat a, double *x, double *y, int frag);
int TrimC(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2);
int TrimC_Run(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2);

int TrimE_Point(struct TrimDat a, double *x, double *y, int frag);
int TrimE_Line(struct TrimDat a, double *x, double *y, int frag);
int TrimE_AC(struct TrimDat a, double *x, double *y, int frag);
int TrimE_Ellipse(struct TrimDat a, double *x, double *y, int frag);
int TrimE(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2);
int TrimE_Run(struct TrimDat *a, double *x1, double *y1, double *x2, double *y2);

int TrimEA(struct TrimDat *a, double *x, double *y);
int TrimEA_Pull(struct TrimDat *a, double x, double y);
int TrimEA_Run(struct TrimDat *a, double x, double y);

int Fillet(struct TrimDat *a, double R);
int C_Cut(struct TrimDat *a, double C);
int Split(struct TrimDat *a);
double Arc_SE_Angle(CAD Data, int Frag);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __TRIMFUNC_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : TrimFunc.h
 * ====================================================================
 */
