/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : toolbar.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2002 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2002/06/25
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

//#include "Mouse.h"
//#include "etc.h"
//#include "Trace.h"
//#include "sagcad.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "Command.h"
#define TOOLBAR
#include "toolbar.h"





/* -------------------------------------------------------------------
 * ġСκ  OutMode1  ()
 * 
 */
GtkWidget *create_toolbar_OutMode1(GtkWidget *window)
{
	/* ġС˺ܤܥ */
	struct ToolBarItem ToolBarItem_OutMode1[] = {
		{_("New"),						New_xpm,			cmd_New,				0, 0},
		{_("Open"),						Open_xpm,			cmd_open,				0, 0},
		{_("Save As"),					ReName_xpm,			cmd_rename,				0, 0},
		{_("Save"),						Save_xpm,			cmd_save,				0, 0},
		{_("Part Insert"),				Parts_in_xpm,		cmd_parts_in,			0, 0},
		{_("Print"),					Print_xpm,			cmd_print,				0, 0},
		{_("Printer Setting"),			PrinterSetting_xpm,	cmd_print_set,			0, 0},
		{_("End"),						End_xpm,			cmd_end,				0, 0},
		{SPACE_CMD,						NULL,				NULL,					0, 0},
		{_("Undo"),						Undo_xpm,			cmd_Undo,				0, 0},
		{_("Redo"), 					Redo_xpm,			cmd_Redo,				0, 0},
		{SPACE_CMD,						NULL, 				NULL,					0, 0},
		{_("Cut"), 						Cut_xpm,			cmd_cut,				0, 0},
		{_("Copy"), 					Copy_xpm,			cmd_copy,				0, 0},
		{_("Paste"),					Paste_xpm,			cmd_paste,				0, 0},
		{SPACE_CMD,						NULL,				NULL,					0, 0},
		{_("Redraw"),					Redraw_xpm,			cmd_redraw,				0, 0},
		{_("View Center"),				Center_xpm,			cmd_center,				0, 0},
		{_("View 0 [Left : Recovery] [Right : Save]"), 	View_0_xpm, cmd_view,		0, 1},
		{_("View 1 [Left : Recovery] [Right : Save]"), View_1_xpm, cmd_view, 0, 2},
		{_("View 2 [Left : Recovery] [Right : Save]"), View_2_xpm, cmd_view, 0, 3},
		{_("View 3 [Left : Recovery] [Right : Save]"), View_3_xpm, cmd_view, 0, 4},
		{_("View 4 [Left : Recovery] [Right : Save]"), View_4_xpm, cmd_view, 0, 5},
		{_("View 5 [Left : Recovery] [Right : Save]"), View_5_xpm, cmd_view, 0, 6},
		{SPACE_CMD,						NULL,				NULL,					0, 0},
		{_("Environment Setting"),		EnvSet_xpm,			cmd_env_set,			0, 0},
		{_("Version Info"),				Version_xpm,		cmd_version,			0, 0},
		{_("Help"),						Help_xpm,			cmd_help,				0, 0},
		{NULL,							NULL,				NULL, 					0, 0}
	};
	GtkWidget *toolbar;


	/* ġС */
	toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
	/* ġСĻ֤ */
	gtk_widget_show(GTK_WIDGET(toolbar));
	/* ġС˥ܥɲ */
	AppendButtons(window, toolbar, ToolBarItem_OutMode1);

	return toolbar;
}





/* -------------------------------------------------------------------
 * ġСκ  InMode1  (ķ)
 * 
 */
GtkWidget *create_toolbar_InMode1(GtkWidget *window)
{
	/* ġС˺ܤܥ */
	struct ToolBarItem ToolBarItem_InMode1[] = {
		{_("Delete"),					Delete_xpm,			cmd_delete,				0, 0},
		{_("Drawing"),					Draw_xpm,			cmd_draw,				0, 0},
		{_("Trim"),						Trim_xpm,			cmd_trim,				0, 0},
		{_("Fillet"),					Fillet_xpm,			cmd_fillet,				0, 0},
		{_("Point Input"),				Point_Input_xpm,	cmd_point,				0, 0},
		{_("Circle from three points"),	Point3_xpm,			cmd_3point,				0, 0},
		{_("Curve"),					PolyLine_xpm,		cmd_polyline,			0, 0},
		{SPACE_CMD,						NULL,				NULL,					0, 0},
		{_("Select"),					Select_xpm,			cmd_select,				0, 0},
		{_("Mirror"),					Mirr_xpm,			cmd_mirr,				0, 0},
		{_("Rotate"),					Roll_xpm,			cmd_turn,				0, 0},
		{_("Scaling"),					Scaling_xpm,		cmd_scaling,			0, 0},
		{_("Layer Copy"),				LayerCopy_xpm,		cmd_layer_copy,			0, 0},
		{SPACE_CMD,						NULL,				NULL,					0, 0},
		{_("Horizontal Dimension"),		DimenX_xpm,			cmd_x_dimension,		0, 0},
		{_("Distance Dimension"),		DimenDistance_xpm,	cmd_p_dimension,		0, 0},
		{_("Radius Dimansion"),			DimenR_xpm,			cmd_r_dimension,		0, 0},
		{_("Coordinates Dimension"),	DimenPoint_xpm,		cmd_pt_dimension,		0, 0},
		{_("Text"),					DimenAtension_xpm,	cmd_at_dimension,		0, 0},
		{SPACE_CMD,						NULL,				NULL ,					0, 0},
		{_("CAM"),						CamProfile_xpm,		cmd_profile,			0, 0},
		{_("Outside Process"),			outside_process_xpm,cmd_outside_process,	0, 0},
		{NULL,							NULL,				NULL,					0, 0}
	};
	GtkWidget *toolbar;


	/* ġС */
	toolbar = gtk_toolbar_new(GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_ICONS);
	/* ġСĻ֤ */
	gtk_widget_show(GTK_WIDGET(toolbar));
	/* ġС˥ܥɲ */
	AppendButtons(window, toolbar, ToolBarItem_InMode1);

	return toolbar;
}





/* -------------------------------------------------------------------
 * ġСκ  InMode2  (ķ)
 * 
 */
GtkWidget *create_toolbar_InMode2(GtkWidget *window)
{
	/* ġС˺ܤܥ */
	struct ToolBarItem ToolBarItem_InMode2[] = {
		{_("Cancel"),					Cancel_xpm,			cmd_all_cancel,			0, 0},
		{_("Divide"),					Split_xpm,			cmd_split,				0, 0},
		{_("Trim two"),					Both_Trim_xpm,		cmd_both_trim,			0, 0},
		{_("Chamfer"),					C_Cut_xpm,			cmd_Chamfering,			0, 0},
		{_("Continuation Line"),		Cont_Line_xpm,		cmd_cont_line,			0, 0},
		{_("Circle from three lines"),	Line3_xpm,			cmd_3line,				0, 0},
		{_("Ellipse"),					Ellipse_xpm,		cmd_Ellipse_Draw,		0, 0},
		{SPACE_CMD,						NULL,				NULL,					0, 0},
		{_("Rect Select"),				RectSelect_xpm,		cmd_rect_select,		0, 0},
		{_("Parallel"),					Para_xpm,			cmd_parallel_copy,		0, 0},
		{_("Procession Copy"),			Matrix_xpm,			cmd_grid_copy,			0, 0},
		{_("Line Style Change"),		LineStyleChange_xpm,cmd_line_style_change,	0, 0},
		{_("Layer Move"),				LayerMove_xpm,		cmd_layer_move,			0, 0},
		{SPACE_CMD,						NULL,				NULL ,					0, 0},
		{_("Vertical Dimension"),		DimenY_xpm,			cmd_y_dimension,		0, 0},
		{_("Angle Dimension"),			DimenAngle_xpm,		cmd_a_dimension,		0, 0},
		{_("Diameter Dimension"),		DimenD_xpm,			cmd_d_dimension,		0, 0},
		{_("Drawer Line Dimension"),	DimenPullLine_xpm,	cmd_hd_dimension,		0, 0},
		{_("Edit Dimension"),			DimenEdit_xpm,		cmd_edt_dimension,		0, 0},
		{SPACE_CMD,						NULL,				NULL ,					0, 0},
		{_("NC Drawing"),				CamNcDraw_xpm,		cmd_NcDraw,				0, 0},
		{NULL,							NULL, 				NULL,					0, 0}
	};
	GtkWidget *toolbar;


	/* ġС */
	toolbar = gtk_toolbar_new(GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_ICONS);
	/* ġСĻ֤ */
	gtk_widget_show(GTK_WIDGET(toolbar));
	/* ġС˥ܥɲ */
	AppendButtons(window, toolbar, ToolBarItem_InMode2);

	return toolbar;
}





/* -------------------------------------------------------------------
 * pixmap widgwt 
 * 
 */
GtkWidget *pixmap_from_xpm(GtkWidget *widget, gchar **xpm_data)
{
	GdkBitmap *mask;
	GdkPixmap *pixmap_data;
	GtkWidget *pixmap_widget;


	pixmap_data = gdk_pixmap_create_from_xpm_d(MainWindow->window, 
											   &mask, 
											   &MainWindow->style->bg[GTK_STATE_NORMAL], 
											   (gchar **)xpm_data);
	pixmap_widget = gtk_pixmap_new(pixmap_data, mask);
	gtk_widget_show(pixmap_widget);

	return (pixmap_widget);
}





/* -------------------------------------------------------------------
 * ܥɲ
 * 
 */
void AppendButtons(GtkWidget *window, GtkWidget *toolbar, struct ToolBarItem *Item)
{
	GSList *group = NULL;
	GtkWidget *button;
	GtkWidget *gtkPixmap;
	GdkPixmap *gdkPixmap;
	GdkBitmap *gtkMask;


	/* ġСItem1Ȥ˥ܥɲ */
	while(Item->tooltips != NULL) {
		/* ڡɲá */
		if (strcmp(Item->tooltips, SPACE_CMD) == 0){
			/* ġС˷֤ */
			gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
			Item++;
			continue;
		}


		/* ԥåޥå(gdk) */
		gdkPixmap = gdk_pixmap_create_from_xpm_d(window->window,
												 &gtkMask,
												 &window->style->bg[GTK_STATE_NORMAL],
												 (gchar **)Item->xpm);
		/* ԥåޥå(gtk) */
		gtkPixmap = gtk_pixmap_new(gdkPixmap, gtkMask);


		/* -------------------------------------------------
		 * ̤Υܥ 
		 */
		if (Item->button_type == 0) {
			group = NULL;
			/* ܥ */
			button = gtk_button_new();

			if (strcmp(Item->tooltips, "Undo") == 0){
				UndoButton = button;
				undo_buttun(0);
			}
			if (strcmp(Item->tooltips, "Redo") == 0){
				RedoButton = button;
				redo_buttun(0);
			}

			/* ̤˺åΤߤǤȤ */
			if (Item->signal_type == 0) {
				/* "clicked"٥ȥϥɥ */
				gtk_signal_connect( GTK_OBJECT(button), "clicked",
									GTK_SIGNAL_FUNC(Item->func),
									NULL );
			}
			/* åȱå櫓Ȥ */
			else if (Item->signal_type != 0) {
				/* "button_press_event"٥ȥϥɥ */
				gtk_signal_connect( GTK_OBJECT(button), "button_press_event",
									GTK_SIGNAL_FUNC(Item->func),
									(gpointer)Item->signal_type);
			}
		}


		/* -------------------------------------------------
		 * 饸ܥ 
		 */
		else if (Item->button_type != 0) {
			
			/* ǽΥܥ */
			if (group == NULL) {
				/* 饸ܥ */
				button = gtk_radio_button_new(NULL);
				/* 饸ܥΥ롼פ */
				group = gtk_radio_button_group(GTK_RADIO_BUTTON(button));
				/* ܥONˤ */
				gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(button), FALSE);
			}
			else {
				/* 饸ܥ */
				button = gtk_radio_button_new(group);
				/* ܥOFFˤ */
				gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(button), FALSE);
			}
			
			/* "clicked" ٥ȥϥɥ */
			gtk_signal_connect( GTK_OBJECT(button), "clicked",
								GTK_SIGNAL_FUNC(Item->func),
								NULL );
		}


		/* ܥ˥ԥåޥåפŽդ */
		gtk_container_add(GTK_CONTAINER(button), gtkPixmap);
		
		/* ġС˥ܥɲ */
		gtk_toolbar_append_widget( GTK_TOOLBAR(toolbar),	/* toolbar */
								   GTK_WIDGET(button),		/* widget */
								   Item->tooltips,			/* tooltip text */
								   NULL);					/* tooltip private txt */
		
		/* ܥȥԥåޥåפĻ֤ */
		gtk_widget_show(GTK_WIDGET(button));
		gtk_widget_show(GTK_WIDGET(gtkPixmap));
		
		
		/*  */
		Item++;
	}
}



//#ifdef TEST
/* -------------------------------------------------------------------
 * Undo Button Ѳǽˤ
 *     frag : 
 *            0 : Բ
 *            1 : Ѳǽ
 * 
 * -------------------------------------------------------------------
 */
int undo_buttun(int frag)
{
	if (frag == 0) {
		gtk_widget_set_sensitive(UndoButton, FALSE);
		return 1;
	}
	else if (frag == 1) {
		gtk_widget_set_sensitive(UndoButton, TRUE);
		return 1;
	}

	return 0;
}



/* -------------------------------------------------------------------
 * Redo Button Ѳǽˤ
 *     frag : 
 *            0 : Բ
 *            1 : Ѳǽ
 * 
 * -------------------------------------------------------------------
 */
int redo_buttun(int frag)
{
	if (frag == 0) {
		gtk_widget_set_sensitive(RedoButton, FALSE);
		return 1;
	}
	else if (frag == 1) {
		gtk_widget_set_sensitive(RedoButton, TRUE);
		return 1;
	}

	return 0;
}
//#endif





/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : toolbar.c
 * ====================================================================
 */
