/*
 * Copyright (C) 1993-2004 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 * 
 * $Id: sailpainter.h,v 1.3 2004/10/26 19:30:51 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SAILPAINTER_H
#define SAILPAINTER_H

#include <qpainter.h>
#include "saildisp.h"

/** A sail painter
 *
 * @see CSailDispLabel
 */
class CSailPainter : public QPainter
{
public:
    CSailPainter(const QPaintDevice *dev) : QPainter(dev)
    {}
    ;
    ~CSailPainter()
    {}
    ;

    void draw(const CSide &side);
    void draw(const CPanel &panel);
    void draw(const CSail &sail);
    void draw(const CPanelLabel &label);

    void setWindow(const CRect3d& lRect);
};

#endif
