/*
 * Copyright (C) 1993-2005 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 *
 * $Id: sailpainter.cpp,v 1.9 2005/10/02 21:17:17 sailcuter Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "sailpainter.h"


/** Draws a side of a sail.
 */
void CSailPainter::draw(const CSide &side)
{
    QPoint prev, next;

    if (side.nbpoints() < 2)
        return;

    prev = QPoint( int(side.point[0].x()), -int(side.point[0].y()) );
    for( unsigned i = 1; i < side.nbpoints(); i++)
    {
        next = QPoint( int(side.point[i].x()), -int(side.point[i].y()) );
        drawLine(prev, next);
        prev = next;
    }
}


/** Draws a panel of a sail.
 */
void CSailPainter::draw(const CPanel &panel)
{
    setPen(Qt::blue);
    draw(panel.left);
    draw(panel.right);
    draw(panel.top);
    draw(panel.bottom);

    if (panel.hasHems)
    {
        setPen(Qt::red);
        draw(panel.cutLeft);
        draw(panel.cutRight);
        draw(panel.cutTop);
        draw(panel.cutBottom);
    }
    setPen(Qt::black);
}


/** Draws a panel label.
 */
void CSailPainter::draw(const CPanelLabel &label)
{
    QPoint p( int(label.origin.x() - fontMetrics().width(label.name)/2),
              -int(label.origin.y() - font().pixelSize()/4) );

    drawText(p, label.name);
}


/** Draws a complete sail.
 */
void CSailPainter::draw(const CSail &sail)
{
    for( unsigned int i = 0; i < sail.nbpanels(); i++ )
        draw(sail.panel[i]);
}


/** Draw all the sail's panel labels.
 */
void CSailPainter::drawLabels(const CSail &sail, real zoom)
{
    QFont font;

    // set the font size for labeling function of zoom
    font.setPixelSize(int(14 + sail.panel[1].height() / (15*zoom)));

    setPen(Qt::blue);
    setFont(font);

    for ( unsigned int i = 0; i < sail.nbpanels(); i++ )
        draw(sail.panel[i].label);
}


/** Set coordinate system to match the logical viewport.
 *
 * @param
 */
void CSailPainter::setWindow(const CRect3d& lRect)
{
    QPainter::setWindow( int(lRect.min.x()),
                         int(-lRect.max.y()),
                         int(lRect.width()),
                         int(lRect.height())
                       );
}


