/*
 * Copyright (C) 1993-2006 Robert & Jeremy Laine
 * 
 * $Id: sailwriter-carlson.h,v 1.10 2006/01/25 21:54:02 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SAILWRITER_CARLSON_H
#define SAILWRITER_CARLSON_H

#include "filewriter.h"
#include "sail.h"
#include <fstream>

/** A class for writing to Carlson files.
 */
class CSailCarlsonWriter : public CFileWriter
{
protected:
    /** the sail we want to write to a file. */
    CSail _sail;
    /** the output stream */
    ofstream _myOut;

public:
    CSailCarlsonWriter(const CSail &sail);

    void write(const QString &filename);
    void writePanel(unsigned int panel);
    void writePanelHeader (unsigned int panel);
    void writeDraw(unsigned int ct);
    void writeCut(unsigned int ct);
    void writePoint(CPoint3d p0);
    void writeEOF();

};

#endif

