/*
 * salinfo_decode_oem.c
 *
 * Example only, to demonstrate the protocol used between salinfo_decode and
 * salinfo_decode_oem.  No error checking, no useful processing.  It echoes
 * back the protocol1 and protocol3 lines to keep salinfo_decode happy.  It does
 * nothing with the raw record or the key=value data.  salinfo_decode will see
 * no data between the protocol responses and will dump oem data in hex.
 *
 * Do not install this version of salinfo_decode_oem, it is only a sample
 * program.  Platform vendors must supply their own version of
 * salinfo_decode_oem in a separate package.
 *
 * Keith Owens <kaos@sgi.com>
 *
 * 2005-12-14 Add fpu.h to get the definition of ia64_fpreg.
 *	      Keith Owens <kaos@sgi.com>
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include <asm/fpu.h>
#include "mca.h"
#include "sal.h"

static const char protocol1[] = "==== salinfo_decode_oem start ====\n";
static const char protocol2[] = "==== salinfo_decode_oem record ====\n";
static const char protocol3[] = "==== salinfo_decode_oem end ====\n";

int
main (void)
{
	char buf[200], name[200];
	int state = 0;
	long fd_data = -1, use_sal = -1, cpu = -1, raw_length = -1, oem_section_offset = -1, value;
	setvbuf(stdout, NULL, _IONBF, 0);
	while (fgets(buf, sizeof(buf), stdin)) {
		if (buf[0] == '\n')
			continue;
		if (memcmp(buf, protocol1, sizeof(protocol1)-1) == 0) {
			fputs(buf, stdout);
			state = 1;
			fd_data = use_sal = cpu = raw_length = oem_section_offset = -1;
		} else if (state == 1 &&
				memcmp(buf, protocol2, sizeof(protocol2)-1) == 0) {
			char *raw;
			state = 2;
			if (raw_length < 0)
				continue;
			raw = malloc(raw_length);
			fread(raw, raw_length, 1, stdin);
			free(raw);
			continue;
		} else if (state == 2 &&
				memcmp(buf, protocol3, sizeof(protocol3)-1) == 0) {
			fputs(buf, stdout);
			state = 3;
		} else if (state == 1 && sscanf(buf, "%[^=]=%ld", name, &value) == 2) {
			if (strcmp(name, "fd_data") == 0)
				fd_data = value;
			else if (strcmp(name, "use_sal") == 0)
				use_sal = value;
			else if (strcmp(name, "cpu") == 0)
				cpu = value;
			else if (strcmp(name, "raw_length") == 0)
				raw_length = value;
			else if (strcmp(name, "oem_section_offset") == 0)
				oem_section_offset = value;
			else
				fprintf(stderr, "key=value ignored %s", buf);
		} else
			fprintf(stderr, "Unexpected record ignored %s", buf);
	}
	return 0;
}
