#  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
#
#  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
#  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#
# ------

MESSAGE(STATUS "Check for pthreads ...")

# ------

IF(PTHREADS_IS_MANDATORY STREQUAL 0)
  SET(PTHREADS_IS_MANDATORY 0)
  SET(PTHREADS_IS_OPTIONAL 1)
ENDIF(PTHREADS_IS_MANDATORY STREQUAL 0)
IF(PTHREADS_IS_OPTIONAL STREQUAL 0)
  SET(PTHREADS_IS_MANDATORY 1)
  SET(PTHREADS_IS_OPTIONAL 0)
ENDIF(PTHREADS_IS_OPTIONAL STREQUAL 0)
IF(NOT PTHREADS_IS_MANDATORY AND NOT PTHREADS_IS_OPTIONAL)
  SET(PTHREADS_IS_MANDATORY 1)
  SET(PTHREADS_IS_OPTIONAL 0)
ENDIF(NOT PTHREADS_IS_MANDATORY AND NOT PTHREADS_IS_OPTIONAL)

# ------

SET(PTHREADS_STATUS 1)
IF(WITHOUT_PTHREADS OR WITH_PTHREADS STREQUAL 0)
  SET(PTHREADS_STATUS 0)
  MESSAGE(STATUS "pthreads disabled from command line.")
ENDIF(WITHOUT_PTHREADS OR WITH_PTHREADS STREQUAL 0)

# ------

IF(PTHREADS_STATUS)
  IF(WITH_PTHREADS)
    SET(PTHREADS_ROOT_USER ${WITH_PTHREADS})
  ELSE(WITH_PTHREADS)
    SET(PTHREADS_ROOT_USER $ENV{PTHREADS_ROOT})
  ENDIF(WITH_PTHREADS)
ENDIF(PTHREADS_STATUS)

# -----

IF(PTHREADS_STATUS)
  IF(PTHREADS_ROOT_USER)
    SET(PTHREADS_FIND_PATHS_OPTION NO_DEFAULT_PATH)
  ELSE(PTHREADS_ROOT_USER)
    SET(PTHREADS_FIND_PATHS_OPTION)
  ENDIF(PTHREADS_ROOT_USER)
ENDIF(PTHREADS_STATUS)

# -----

IF(PTHREADS_STATUS)
  IF(PTHREADS_ROOT_USER)
    SET(PTHREADS_INCLUDE_PATHS ${PTHREADS_ROOT_USER}/include)
  ELSE(PTHREADS_ROOT_USER)
    SET(PTHREADS_INCLUDE_PATHS)
  ENDIF(PTHREADS_ROOT_USER)
  SET(PTHREADS_INCLUDE_TO_FIND pthread.h)
  FIND_PATH(PTHREADS_INCLUDE_DIR ${PTHREADS_INCLUDE_TO_FIND} PATHS ${PTHREADS_INCLUDE_PATHS} ${PTHREADS_FIND_PATHS_OPTION})
  IF(PTHREADS_INCLUDE_DIR)
    IF(PTHREADS_ROOT_USER)
      SET(PTHREAD_CFLAGS -I${PTHREADS_INCLUDE_DIR})
    ENDIF(PTHREADS_ROOT_USER)
    MESSAGE(STATUS "${PTHREADS_INCLUDE_TO_FIND} found in ${PTHREADS_INCLUDE_DIR}")
  ELSE(PTHREADS_INCLUDE_DIR)
    SET(PTHREADS_STATUS 0)
    IF(PTHREADS_ROOT_USER)
      MESSAGE(STATUS "${PTHREADS_INCLUDE_TO_FIND} not found in ${PTHREADS_INCLUDE_PATHS}, check your PTHREADS installation.")
    ELSE(PTHREADS_ROOT_USER)
      MESSAGE(STATUS "${PTHREADS_INCLUDE_TO_FIND} not found on system, try to use WITH_PTHREADS option or PTHREADS_ROOT environment variable.")
    ENDIF(PTHREADS_ROOT_USER)
  ENDIF(PTHREADS_INCLUDE_DIR)
ENDIF(PTHREADS_STATUS)

# ----

IF(PTHREADS_STATUS)
  IF(PTHREADS_ROOT_USER)
    SET(PTHREADS_LIB_PATHS ${PTHREADS_ROOT_USER}/lib)
  ELSE(PTHREADS_ROOT_USER)
    SET(PTHREADS_LIB_PATHS)
  ENDIF(PTHREADS_ROOT_USER)
ENDIF(PTHREADS_STATUS)

IF(PTHREADS_STATUS)
  IF(WINDOWS)
    IF(CMAKE_BUILD_TYPE STREQUAL Release)
      FIND_LIBRARY(PTHREAD_LIB pthreadVSE2 pthreadVC2 PATHS ${PTHREADS_LIB_PATHS} ${PTHREADS_FIND_PATHS_OPTION})
    ELSE(CMAKE_BUILD_TYPE STREQUAL Release)
      FIND_LIBRARY(PTHREAD_LIB pthreadVSE2d pthreadVC2d PATHS ${PTHREADS_LIB_PATHS} ${PTHREADS_FIND_PATHS_OPTION})
    ENDIF(CMAKE_BUILD_TYPE STREQUAL Release)
  ELSE(WINDOWS)
    FIND_LIBRARY(PTHREAD_LIB pthread PATHS ${PTHREADS_LIB_PATHS} ${PTHREADS_FIND_PATHS_OPTION})
  ENDIF(WINDOWS)
  SET(PTHREAD_LIBS)
  IF(PTHREAD_LIB)
    SET(PTHREAD_LIBS ${PTHREAD_LIBS} ${PTHREAD_LIB})
    MESSAGE(STATUS "pthread lib found: ${PTHREAD_LIB}")
  ELSE(PTHREAD_LIB)
    SET(PTHREADS_STATUS 0)
    IF(PTHREADS_ROOT_USER)
      MESSAGE(STATUS "pthread lib not found in ${PTHREADS_LIB_PATHS}, check your PTHREADS installation.")
    ELSE(PTHREADS_ROOT_USER)
      MESSAGE(STATUS "pthread lib not found on system, try to use WITH_PTHREADS option or PTHREADS_ROOT environment variable.")
    ENDIF(PTHREADS_ROOT_USER)
  ENDIF(PTHREAD_LIB)
ENDIF(PTHREADS_STATUS)

# ----

IF(PTHREADS_STATUS)
ELSE(PTHREADS_STATUS)
  IF(PTHREADS_IS_MANDATORY)
    MESSAGE(FATAL_ERROR "pthreads not found ... mandatory ... abort")
  ELSE(PTHREADS_IS_MANDATORY)
    MESSAGE(STATUS "pthreads not found ... optional ... disabled")
  ENDIF(PTHREADS_IS_MANDATORY)
ENDIF(PTHREADS_STATUS)
