//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  File   : VVTK_PickingDlg.h
//  Author : Oleg Uvarov
//  Module : VISU
//
#ifndef VVTK_PICKINGDLG_H
#define VVTK_PICKINGDLG_H

#include "SVTK_DialogBase.h"

#include <vtkObject.h>
#include <vtkSmartPointer.h>

#include <QLineEdit>

class vtkActorCollection;
class vtkCallbackCommand;
class vtkImageData;

class QLabel;
class QComboBox;
class QCheckBox;
class QPushButton;

class QtxAction;
class QtxDoubleSpinBox;
class QtxIntSpinBox;
class QtxColorButton;

class VISU_GaussPtsAct;
class VISU_PickingSettings;

class SVTK_MainWindow;
class SVTK_RenderWindowInteractor;
class VVTK_ValidatedLineEdit;

//! Picking Dialog.
/*!
 * Uses for set up picking preferenses and apply
 * them to all actors in the current renderer.
 */
class VVTK_PickingDlg : public SVTK_DialogBase
{
  Q_OBJECT

public:
  VVTK_PickingDlg(QtxAction* theAction,
		  SVTK_MainWindow* theParent,
		  const char* theName);

  ~VVTK_PickingDlg();

  //! Make an actor to listen the event of Update Picking Settings event.
  void             AddActor( VISU_GaussPtsAct* );
  void             RemoveActor( VISU_GaussPtsAct* );

  //! Update dialog contents.
  void             Update();

  VISU_PickingSettings* GetPickingSettings();

  void             SetInteractor( SVTK_RenderWindowInteractor* );

protected slots:
  void             onSelectionEvent();
  void             onClickApply();
  void             onClickClose();
  void             onClickHelp();

  //void             onColorButtonPressed();
  void             onSelectionValidate();

private:
  static void      ProcessEvents(vtkObject* theObject, 
				 unsigned long theEvent,
				 void* theClientData, 
				 void* theCallData);

  void             KeyPressed();
  void             keyPressEvent( QKeyEvent* e );

private:
  QtxDoubleSpinBox* myCursorSizeSpinBox;
  QtxDoubleSpinBox* myPyramidHeightSpinBox;
  QtxColorButton*   mySelectionColorButton;
  QtxDoubleSpinBox* myPointToleranceSpinBox;
  QtxIntSpinBox*    myTransparencySpinBox;
  QComboBox*        myPositionComboBox;
  QtxDoubleSpinBox* myZoomFactorSpinBox;
  QtxIntSpinBox*    myStepNumberSpinBox;
  QCheckBox*        myDisplayParentMeshCheckBox;

  QtxAction*        myAction;
  vtkSmartPointer<VISU_PickingSettings> 
                    myPickingSettings;

  VVTK_ValidatedLineEdit*      
                    myParentElementLineEdit;
  VVTK_ValidatedLineEdit*     
                    myLocalPointLineEdit;

  SVTK_RenderWindowInteractor* 
                    myInteractor;

  float             myPriority;
  vtkSmartPointer<vtkCallbackCommand> 
                    myEventCallbackCommand;
};

class VVTK_ValidatedLineEdit : public QLineEdit
{
  Q_OBJECT;
public:
  VVTK_ValidatedLineEdit( QWidget* parent );
  
public slots:
  void MarkValidated( const QString& theText );
};

#endif
