# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --


AC_DEFUN([CHECK_SALOME_KERNEL],[

AC_MSG_CHECKING(for salome kernel)

AC_ARG_WITH(salome-kernel,
	    [  --with-salome-kernel=DIR  path to the salome kernel installation],
	    [KERNEL_DIR="$withval"],
	    [KERNEL_DIR=""])

if test "x$KERNEL_DIR" == "x" ; then
    if test "x$KERNEL_ROOT_DIR" != "x" ; then
        # KERNEL_ROOT_DIR environment variable defined
        KERNEL_DIR=$KERNEL_ROOT_DIR
    fi
fi

if test "x$KERNEL_DIR" == "x" ; then
   # search Kernel binaries in PATH variable
   AC_PATH_PROG(RUNSALOME, runSalome)
   if test "x$RUNSALOME" != "x" ; then
      KERNEL_DIR=$RUNSALOME            # DIR/bin/salome/runSalome
      KERNEL_DIR=`dirname $KERNEL_DIR` # DIR/bin/salome
      KERNEL_DIR=`dirname $KERNEL_DIR` # DIR/bin
      KERNEL_DIR=`dirname $KERNEL_DIR` # DIR
   fi
fi
      
# For option --without-salome-kernel,
# convert KERNEL_DIR for "no" to "" at the end
if test "x$KERNEL_DIR" == "xno" ; then
    KERNEL_DIR=
fi

if test "x$KERNEL_DIR" == "x" ; then
    AC_MSG_RESULT(false)
else
    AC_MSG_RESULT($KERNEL_DIR)
    SALOME_KERNEL=$KERNEL_DIR
    SALOME_KERNEL_VERSION=
    SALOME_KERNEL_MAJOR_VERSION=
    if test -f $SALOME_KERNEL/bin/salome/VERSION ; then
       SALOME_KERNEL_VERSION=`cat $SALOME_KERNEL/bin/salome/VERSION | awk '{print $(NF)}'`
       SALOME_KERNEL_MAJOR_VERSION=`echo $SALOME_KERNEL_VERSION | awk -F "." '{print $(1)}'`
    fi
    AC_SUBST(SALOME_KERNEL)
    AC_SUBST(SALOME_KERNEL_VERSION)
    AC_SUBST(SALOME_KERNEL_MAJOR_VERSION)
fi
 
])dnl
 
