# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XAttributeWithComments(XAttribute):
    __init__xattributes__ = XAttribute.__init__xattributes__ + [
        XAttribute("en_comment", xtype=XString(), default_value=""),
        XAttribute("fr_comment", xtype=XString(), default_value=""),
        XAttribute("de_comment", xtype=XString(), default_value=""),
        ]
    pass

class XAttributeWithCommentsTestCase(unittest.TestCase):
    def test(self):
        x = XAttributeWithComments("toto",
                                   en_comment = "hello",
                                   fr_comment = "bonjour",
                                   de_comment = "guten Tag",
                                   )
        self.failUnlessEqual(x.en_comment, "hello")
        self.failUnlessEqual(x.fr_comment, "bonjour")
        self.failUnlessEqual(x.de_comment, "guten Tag")
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
