# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

# ----------------------------------------------------
# -- test __init__ inheritence
# ----------------------------------------------------

class A(XObject):
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        ]
    pass

class A1(A):
    pass

class A2(A1):
    def __init__(self, *args, **kwargs):
        self.dim = 2
        return
    pass

class A3(A2):
    pass

class ATestCase(unittest.TestCase):
    def test(self):
        a = A(123)
        self.failUnlessEqual(a.x, 123)
        a = A1(123)
        self.failUnlessEqual(a.x, 123)
        a = A2(123)
        self.failUnlessEqual(a.x, 123)
        self.failUnlessEqual(a.dim, 2)
        a = A3(123)
        self.failUnlessEqual(a.x, 123)
        self.failUnlessEqual(a.dim, 2)
        return
    pass

# ----------------------------------------------------
# -- test __init__ inheritence with an optional property
# ----------------------------------------------------

class Op(XObject):
    __init__xattributes__ = [
        XAttribute("x", default_value=0, xtype=XInt(min=0)),
        ]
    pass

class Op2(Op):
    pass

class Op3(Op2):
    def __init__(self, *args, **kwargs):
        self.dim = 2
        return
    pass

class OpTestCase(unittest.TestCase):
    def test(self):
        o = Op(123)
        self.failUnlessEqual(o.x, 123)
        o = Op()
        self.failUnlessEqual(o.x, 0)
        return
    def test2(self):
        o = Op2(123)
        self.failUnlessEqual(o.x, 123)
        o = Op2()
        self.failUnlessEqual(o.x, 0)
        return
    def test3(self):
        o = Op3(123)
        self.failUnlessEqual(o.x, 123)
        o = Op3()
        self.failUnlessEqual(o.x, 0)
        return
    pass

# ----------------------------------------------------
# -- testing user-defined get and set
# ----------------------------------------------------

class DirectUserDefinedSet(XObject):
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        XAttribute("y", default_value=None, xtype=XInt(min=0)),
        ]
    def setX(self, value):
        try:
            self.test += 1
        except AttributeError:
            self.test = 1
            pass
        return
    def setY(self, value):
        if value > 100:
            raise ValueError("toto")
        pass
    pass

class DirectUserDefinedSetTestCase(unittest.TestCase):
    def test(self):
        o = DirectUserDefinedSet(123)
        self.failUnlessEqual((o.x, o.test), (123, 1))
        o.x = 3456
        self.failUnlessEqual((o.x, o.test), (3456, 2))
        return
    def testRaiseInUserSet(self):
        o = DirectUserDefinedSet(123, 50)
        self.failUnlessEqual(o.y, 50)
        self.failUnlessRaises(ValueError, o.setY, 200)
        self.failUnlessEqual(o.y, 50)
        self.failUnlessRaises(ValueError, o.setY, 200)
        self.failUnlessEqual(o.y, 50)
        return
    pass

# ----------------------------------------------------
# -- testing user-defined set with recursion ...
# ----------------------------------------------------

class RecursionUserDefinedSet(XObject):
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        ]
    def setX(self, value):
        self.x = 2*self.x
        return
    pass

class RecursionUserDefinedSetTestCase(unittest.TestCase):
    def test(self):
        o = RecursionUserDefinedSet(123)
        # self.failUnlessEqual(o.x, 246)
        return
    pass

# ----------------------------------------------------
# -- testing user-defined get and set with inheritence
# ----------------------------------------------------

class BaseSet(XObject):
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        ]
    pass

class DerivedSet(BaseSet):
    def setX(self, value):
        try:
            self.test += 1
        except AttributeError:
            self.test = 1
            pass
        return
    pass

class DerivedGet(DerivedSet):
    def getX(self):
        try:
            self.test_get += 1
        except AttributeError:
            self.test_get = 1
            pass
        return self.x
    pass

class DerivedSetTestCase(unittest.TestCase):
    def test(self):
        o = DerivedSet(123)
        self.failUnlessEqual((o.x, o.test), (123, 1))
        o.x = 3456
        self.failUnlessEqual((o.x, o.test), (3456, 2))
        return
    def test2(self):
        o = DerivedGet(123)
        self.failUnlessEqual((o.x, o.test_get), (123, 1))
        o.x = 3456
        self.failUnlessEqual((o.x, o.test_get), (3456, 2))
        return
    pass

# ----------------------------------------------------
# -- test a full object
# ----------------------------------------------------

class Test0(XObject):
    __init__xattributes__ = [
        XAttribute("first_mandatory_arg", xtype=XString()),
        XAttribute("second_mandatory_arg", xtype=XString()),
        XAttribute("first_optional_arg", default_value=111),
        XAttribute("second_optional_arg", default_value=222),
        ]
    pass

def test_values(self, o, val1, val2, val3, val4):
    # o.value
    self.failUnlessEqual(o.first_mandatory_arg, val1)
    self.failUnlessEqual(o.second_mandatory_arg, val2)
    self.failUnlessEqual(o.first_optional_arg, val3)
    self.failUnlessEqual(o.second_optional_arg, val4)
    # o.getValue()
    self.failUnlessEqual(o.getFirstMandatoryArg(), val1)
    self.failUnlessEqual(o.getSecondMandatoryArg(), val2)
    self.failUnlessEqual(o.getFirstOptionalArg(), val3)
    self.failUnlessEqual(o.getSecondOptionalArg(), val4)
    return

class Test0TestCase(unittest.TestCase):
    def test__init__(self):
        # Too many properties
        self.failUnlessRaises(XAttributeError, Test0, 1, 2, 3, 4, 5)
        # Bad property
        self.failUnlessRaises(XAttributeError, Test0, toto=2)
        # an arg is defined more than one
        self.failUnlessRaises(XAttributeError, Test0, 1, first_mandatory_arg=4)
        self.failUnlessRaises(XAttributeError, Test0, 1, 2, 3, first_optional_arg=2)
        self.failUnlessRaises(XAttributeError, Test0, 1, 2, 3, first_optional_arg=2, second_optional_arg=2)
        # a mandatory arg is not defined
        self.failUnlessRaises(XAttributeError, Test0, "a")
        self.failUnlessRaises(XAttributeError, Test0, "a", first_optional_arg=3, second_optional_arg=2)
        # all the following are ok
        Test0("a", "b")
        Test0("a", second_mandatory_arg="b")
        Test0(first_mandatory_arg="a", second_mandatory_arg="b")
        Test0("a", "b", 3, 4)
        Test0("a", second_mandatory_arg="b", first_optional_arg=3, second_optional_arg=4)
        Test0(first_mandatory_arg="a", second_mandatory_arg="b", first_optional_arg=3, second_optional_arg=4)
        #
        return
    def testget(self):
        o = Test0("a", "b")
        test_values(self, o, "a", "b", 111, 222)
        o = Test0("a", second_mandatory_arg="b")
        test_values(self, o, "a", "b", 111, 222)
        o = Test0(first_mandatory_arg="a", second_mandatory_arg="b")
        test_values(self, o, "a", "b", 111, 222)
        o = Test0("a", "b", 3, 4)
        test_values(self, o, "a", "b", 3, 4)
        o = Test0("a", second_mandatory_arg="b", first_optional_arg=3, second_optional_arg=4)
        test_values(self, o, "a", "b", 3, 4)
        o = Test0(first_mandatory_arg="a", second_mandatory_arg="b", first_optional_arg=3, second_optional_arg=4)
        test_values(self, o, "a", "b", 3, 4)
        return
    def testset(self):
        o = Test0("a", "b")
        self.failUnlessRaises(ValueError, o.__setattr__, "first_optional_arg", "toto")
        self.failUnlessRaises(ValueError, o.setFirstOptionalArg, "toto")
        o.first_mandatory_arg = "tutu"
        o.setSecondMandatoryArg("aa")
        o.first_optional_arg = 18
        o.setSecondOptionalArg(23)
        test_values(self, o, "tutu", "aa", 18, 23)
        return
    pass

# ----------------------------------------------------
# -- test __object__xattributes__
# ----------------------------------------------------

class ObjectXProp(XObject):
    __object__xattributes__ = [
        XAttribute("x", xtype=XFloat(), mode="rw"),
        ]
    pass

class ObjectXPropTestCase(unittest.TestCase):
    def test(self):
        o = ObjectXProp()
        o.x = 1.2
        self.failUnlessEqual(o.getX(), 1.2)
        return
    pass


class AAAA(XObject):
    pass

class ttt(unittest.TestCase):
    def test(self):
        a = AAAA()
        self.failUnlessRaises(AttributeError, getattr, a, "__init__xattributes__")
        # self.failUnlessRaises(XAttributeError, setattr, a, "__init__xattributes__", [])
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
