# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession
salome = XSalomeSession(modules=["DATATEST1"])

class TestCase(unittest.TestCase):
    def test(self):
        #
        component = salome.lcc.FindOrLoadComponent("FactoryServerPy", "DATATEST1")
        self.failUnless(component)
        from DATATEST1_CORBA import DATATEST1_Component
        component = component._narrow(DATATEST1_Component)
        self.failUnless(component)
        #
        x = component.newTestXDict1()
        d = x.getDict()
        keys = d.keys()
        self.failUnlessEqual(len(keys), 3)
        self.failUnless('a' in keys)
        self.failUnless('b' in keys)
        self.failUnless('c' in keys)
        self.failUnlessEqual(d.value('a').value(), 1)
        epsilon = 1.e-4
        error = abs(d.value('b').value()-1.3)
        self.failUnless(error < epsilon)
        self.failUnlessEqual(d.value('c').value(), 'toto')
        #
        x.modifyDict()
        d = x.getDict()
        keys = d.keys()
        self.failUnlessEqual(len(keys), 4)
        self.failUnless('a' in keys)
        self.failUnless('b' in keys)
        self.failUnless('c' in keys)
        self.failUnless('d' in keys)
        self.failUnlessEqual(d.value('a').value(), 1)
        epsilon = 1.e-4
        error = abs(d.value('b').value()-1.3)
        self.failUnless(error < epsilon)
        self.failUnlessEqual(d.value('c').value(), 'toto')
        self.failUnlessEqual(d.value('d').value(), 'tutu')
        #
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
