# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

epsilon = 1.e-5

def check_gets(self, x, i, f, s, ii, ff, ss):
    #
    self.failUnlessEqual(x.getI(), i)
    self.failUnless(abs(x.getF() - f) < epsilon)
    self.failUnlessEqual(x.getS(), s)
    self.failUnlessEqual(x.getIi(), ii)
    self.failUnlessEqual(x.getFf(), ff)
    self.failUnlessEqual(x.getSs(), ss)
    self.failUnlessEqual(x.i, i)
    self.failUnless(abs(x.f - f) < epsilon)
    self.failUnlessEqual(x.s, s)
    self.failUnlessEqual(x.ii, ii)
    self.failUnlessEqual(x.ff, ff)
    self.failUnlessEqual(x.ss, ss)
    #
    x = x.__corba__object__
    self.failUnlessEqual(x.getI(), i)
    self.failUnless(abs(x.getF() - f) < epsilon)
    self.failUnlessEqual(x.getS(), s)
    if ii is None:
        self.failUnlessEqual(x.getIi(), ii)
        self.failUnlessEqual(x.getFf(), ff)
        self.failUnlessEqual(x.getSs(), ss)
    else:
        self.failUnlessEqual(x.getIi().value(), ii)
        self.failUnless(abs(x.getFf().value() - ff) < epsilon)
        self.failUnlessEqual(x.getSs().value(), ss)
        pass
    #
    return

class TestCase(unittest.TestCase):
    def test(self):
        #
        from xsalome import XSalomeSession
        salome = XSalomeSession(modules=["DATATEST1"])
        #
        from xintxfloatxstringusecases import TestXIntXFloatXString
        i, f, s, ii, ff, ss = 111, 2.3, "toto", None, None, None
        x = TestXIntXFloatXString(i, f, s, ii, ff, ss)
        check_gets(self, x, i, f, s, ii, ff, ss)
        #
        from xintxfloatxstringusecases import TestXIntXFloatXString
        i, f, s, ii, ff, ss = 111, 2.3, "toto", None, None, None
        x = TestXIntXFloatXString(i, f, s)
        check_gets(self, x, i, f, s, ii, ff, ss)
        #
        from xintxfloatxstringusecases import TestXIntXFloatXString
        i, f, s = 111, 2.3, "toto"
        x = TestXIntXFloatXString(i, f, s, i, f, s)
        check_gets(self, x, i, f, s, i, f, s)
        #
        from xintxfloatxstringusecases import TestXIntXFloatXString
        i, f, s, ii, ff, ss = 111, 2.3, "toto", None, None, None
        x = TestXIntXFloatXString(i, f, s)
        x.i = 2*i
        x.f = 2*f
        x.s = 2*s
        x.ii = 2*i
        x.ff = 2*f
        x.ss = 2*s
        check_gets(self, x, 2*i, 2*f, 2*s, 2*i, 2*f, 2*s)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
