# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xutilities import message
from xqt import *
from xdata import XObject
from xmainwindow import getMainWindow

# ------------------------------

def _getEditionViews(cls, parent, obj):
    return ["All"]

XObject.getEditionViews = classmethod(_getEditionViews)

def _getEditionViewsGroupName(cls):
    return "Views"

XObject.getEditionViewsGroupName = classmethod(_getEditionViewsGroupName)

def _getEditionDefaultView(cls, parent, obj, views):
    return views[0]

XObject.getEditionDefaultView = classmethod(_getEditionDefaultView)

def _getXAttributesForEditionView(cls, parent, obj, view):
    # --
    l = list(cls.getAllInitXAttributes(name_first=1))
    if obj is not None:
        for x in cls.__object__xattributes__:
            if x.mode == "rw": l.append(x)
            pass
        pass
    # --
    if view == "ValueHasChanged":
        if obj is None:
            view = "NoDefault"
        else:
            ll = []
            for x in l:
                if not x.hasDefaultValue():
                    ll.append(x)
                    continue
                default = x.getDefaultValue()
                value = getattr(obj, x.name)
                if default != value:
                    ll.append(x)
                    pass
                pass
            l = ll
            pass
        pass
    # --
    if view == "NoDefault":
        ll = []
        for x in l:
            if x.hasDefaultValue(): continue
            ll.append(x)
            pass
        l = ll
        pass
    # --
    return l

XObject.getXAttributesForEditionView = classmethod(_getXAttributesForEditionView)

# ------------------------------

def _renameFromGUI(self, initial, final):
    message(initial, final)
    self.__instance__name__ = final
    return

XObject.renameFromGUI = _renameFromGUI

# ------------------------------

def _getInstancePrefix(cls):
    prefix = "%s%s"%(cls.__name__[0].lower(), cls.__name__[1:])
    return prefix

XObject.getInstancePrefix = classmethod(_getInstancePrefix)

# ------------------------------

def _getToolTip(cls, target):
    return None

XObject.getToolTip = classmethod(_getToolTip)
# begin{G.F}
def _show_item(cls,name,object_to_edit):
    return 1,None
XObject.show_item = classmethod(_show_item)
# end{G.F}

# ------------------------------

def _getDialogInitialValue(cls, xattribute, values, dialog):
    message(cls, xattribute, values, dialog)
    has_default_value = xattribute.hasDefaultValue()
    if has_default_value:
        value = xattribute.getDefaultValue()
    else:
        value = None
        pass
    return has_default_value, value

XObject.getDialogInitialValue = classmethod(_getDialogInitialValue)

# ------------------------------

def _createDialog(cls, parent, instance_name, xobject, editor, xattribute):
    message(cls, parent, instance_name, xobject, editor, xattribute, cls="XObject")
    if xattribute:
        from xdatapropertyeditor import XAttributeEditorDialog
        dialog = XAttributeEditorDialog(parent, xobject, xattribute)
    else:
        from xdatapropertyeditor import XGuiXObjectEditorDialog
        dialog = XGuiXObjectEditorDialog(cls, parent, instance_name, xobject, editor)
        pass
    return dialog

XObject.createDialog = classmethod(_createDialog)

# ------------------------------

def _createEditor(cls, xattribute, parent, xobject=None, value=None, text=None):
    message(cls, xattribute, parent, xobject, value, text)
    return xattribute.createEditor(cls, parent, xobject, value, text)

XObject.createEditor = classmethod(_createEditor)

# ------------------------------

def _createEditor(self, cls, parent, xobject=None, value=None, text=None):
    #
    xattribute = self
    message(xattribute, cls, parent, xobject, value, text)
    #
    xtype = xattribute.xtype
    #
    from xdata import XMulTypes
    if isinstance(xtype, XMulTypes):
        xtypes=xtype.xtypes
        if len(xtypes) == 2:
            from xdata import XNone
            if isinstance(xtypes[0], XNone):
                xtype=xtypes[1]
                pass
            pass
        pass
    #
    return xtype.createEditor(xattribute, cls, parent, xobject, value, text)

from xdata import XAttribute

XAttribute.createEditor = _createEditor

# ------------------------------

def _createEditor(self, xattribute, cls, parent, xobject=None, value=None, text=None):
    #
    xtype = self
    message(xtype, xattribute, cls, parent, value, text)
    #
    return XGUIQLineEdit(xtype, xattribute, cls, parent, xobject, value, text)

from xtypes import XType

XType.createEditor = _createEditor

# ------------------------------

def _createEditor(self, xattribute, cls, parent, xobject, value=None, text=None):
    #
    xtype = self
    message(xtype, xattribute, cls, parent, value, text)
    #
    if xtype.into:
        return XGUIQComboBox(xtype, xattribute, cls, parent, xobject, value, text)
    from xtypes import XType
    return XType.createEditor(xtype, xattribute, cls, parent, xobject, value, text)

from xtypes import XInt, XString
XInt.createEditor = _createEditor
XString.createEditor = _createEditor

# ------------------------------
# ------------------------------

def _customEditorPopup(cls, xattribute, parent, popup, xobject):
    message(cls, xattribute, parent, popup, xobject)
    xattribute.customEditorPopup(cls, parent, popup, xobject)
    return

XObject.customEditorPopup = classmethod(_customEditorPopup)

def _customEditorPopup(self, cls, parent, popup, xobject):
    message(self, cls, parent, popup, xobject)
    xattribute = self
    xtype = xattribute.xtype
    xtype.customEditorPopup(xattribute, cls, parent, popup, xobject)
    return

XAttribute.customEditorPopup = _customEditorPopup

def _customEditorPopup(self, xattribute, cls, parent, popup, xobject):
    message(self, xattribute, cls, parent, popup, xobject)
    return

XType.customEditorPopup = _customEditorPopup

# ---------------------------

def _getPopupItems(cls, parent, selection):
    message(cls, parent, selection)
    l = []
    for x in cls.__object__xmethods__:
        popup_status = x.popup
        insert = ( ( popup_status == "single" ) and ( len(selection) == 1 ) )
        insert = insert or ( popup_status == "multi" )
        if insert:
            l.append(x.name)
            pass
        pass
    return l

XObject.getPopupItems = classmethod(_getPopupItems)

# ---------------------------

def _customPopup(cls, parent, popup, selection):
    message(cls, parent, popup, selection)
    items = cls.getPopupItems(parent, selection)
    for item in items:
        if item.strip() == "":
            popup.insertSeparator()
            continue
        action = customPopupQAction(parent, cls, item, selection).addTo(popup)
        pass
    return

XObject.customPopup = classmethod(_customPopup)

class customPopupQAction(QAction):
    
    def __init__(self, parent, container, name, selection):
        QAction.__init__(self, parent)
        from xutilities import name2capname
        self.setText(name2capname(name, space=1))
        self.parent = parent
        self.container = container
        self.name = name
        self.selection = selection
        self.connect(self, SIGNAL("activated()"), self.activated)
        return
    
    def activated(self):
        parent = self.parent
        container = self.container
        name = self.name
        selection = self.selection
        try:
            container.popupActivated(parent, name, selection)
        except:
            getMainWindow().displayException(parent)
            pass
        key = "popupActivatedGetModifiedSelection"
        if hasattr(container, key):
            f = getattr(container, key)
            selection = f(parent, name, selection)
            pass
        try:
            for sel in selection:
                getMainWindow().oldObjectModified(sel)
                pass
            pass
        except TypeError:
            pass
        return
    
    pass

def _popupActivated(cls, parent, name, selection):
    msg  = "Not implemented for the moment ....\n"
    msg += "Please, implement a 'popupActivated' classmethod in\n"
    msg += "%s. For instance:\n"%(str(cls))
    msg += "\n"
    msg += "def myPopupActivated(cls, parent, method_name, selection)\n"
    msg += "    code ...\n"
    msg += "    return\n"
    msg += "popupActivated = classmethod(myPopupActivated)\n"
    msg += "\n"
    QMessageBox.warning(parent, "Warning", msg)
    return

XObject.popupActivated = classmethod(_popupActivated)

# ------------------------------
# ------------------------------

class ImportCancelException(Exception):
    pass

class XGUIQProgressDialog(QProgressDialog):
    
    def __init__(self, creator, file_name):
        setattr(getMainWindow(), "__current__import__", 1)
        # QProgressDialog.__init__(self, creator, "XProgress", True, Qt.WDestructiveClose)
        QProgressDialog.__init__(self, creator, "XProgress", False, Qt.WDestructiveClose)
        self.connect(creator, PYSIGNAL("code_percentage"), self.setCodePercentage)
        self.setAutoClose(True)
        self.setAutoReset(True)
        self.setCaption("Import script")
        #
        import os.path
        label = QLabel(self)
        label.setText('Loading %s ...'%(os.path.basename(file_name)))
        self.setLabel(label)
        self.connect(self, SIGNAL('canceled()'), self.cancel)
        #
        self.importPythonFile(file_name)
        #
        self.close()
        return
    
    def cancel(self):
        self.__has__been__canceled__ = 1
        return
    
    def setCodePercentage(self, percent):
        message(percent, cls=XGUIQProgressDialog)
        step = int( (1.0-percent)*self.totalSteps() )
        message(step, cls=XGUIQProgressDialog)
        self.setProgress(self.totalSteps() - step)
        qApp.processEvents()
        #
        if hasattr(self, '__has__been__canceled__'):
            raise ImportCancelException()
        #
        return
    
    def importPythonFile(self, file_name):
        import os.path
        full_file_name = os.path.abspath(file_name)
        #
        from xmetaclass import resetXObjects
        resetXObjects()
        #
        from xcontext import getContext
        context = getContext()
        if context == "clt":
            import salome
            myStudyId = salome.sg.getActiveStudyId()
            myStudy = salome.myStudyManager.GetStudyByID(myStudyId)
            myBuilder = myStudy.NewBuilder()
            myBuilder.NewCommand()
            from xsalome import getComponentsNames
            names = getComponentsNames()
            for name in names:
                scomp = myStudy.FindComponent(name)
                if scomp:
                    myBuilder.RemoveComponent(scomp)
                    pass
                pass
            # E.A. : It seems to block the application
            # to update in a thread (humm, I think that
            # C.C. will say 'obviously' :) )
            # salome.sg.updateObjBrowser(1)
            pass
        #
        try:
            execfile(full_file_name)
        except ImportCancelException:
            pass
        except:
            getMainWindow().displayException(long=1)
            pass
        #
        return
    
    def closeEvent(self, ev):
        message("Hello !", cls=XGUIQProgressDialog)
        delattr(getMainWindow(), "__current__import__")
        QProgressDialog.closeEvent(self, ev)
        return
    
    pass

def importPy(file_name, gui):
    self = getMainWindow()
    XGUIQProgressDialog(self, file_name)
    return

# ------------------------------
# ------------------------------

def customPopup(popup, selection):
    message(popup, selection)
    # --
    # max_depth is used to see if we should
    # include a "Delete" popup items
    max_depth = 1
    non_xobj = 0
    #
    xtrees = []
    nodes = []
    #
    for item in selection:
        xtree = item.xtree
        xtrees.append(xtree)
        #
        if xtree.depth > max_depth:
            max_depth = xtree.depth
            pass
        #
        node = xtree.node
        nodes.append(node)
        #
        if not isinstance(node, XObject):
            non_xobj = 1
            pass
        pass
    #
    if non_xobj:
        if len(nodes) == 1:
            xtree = xtrees[0]
            xattr = xtree.xattribute
            if xattr:
                if xattr.mode == "rw":
                    is_editable = 1
                    parent = xtree.parent
                    while 1:
                        if parent is None: break
                        x = parent.xattribute
                        if x:
                            mode = x.mode
                            if mode != "rw":
                                is_editable = 0
                                pass
                            pass
                        parent = parent.parent
                        pass
                    if is_editable:
                        xobj = xtree.parent.node
                        message("AAA direct access to xattribute '%s' of %s"%(xattr.name, xobj))
                        qaction = customPopupEditOneXAttributeQAction(getMainWindow(), xobj, xattr)
                        qaction.addTo(popup)
                        pass
                    pass
                pass
            pass
        #
        from xmainmenubar import getMenuBar
        comp_name = getMenuBar().__current__component__name__
        mod = __import__('%s_xdata'%(comp_name))
        if hasattr(mod, "getPopupItems"):
            items = mod.getPopupItems(getMainWindow(), nodes)
            for item in items:
                if item == "":
                    popup.insertSeparator()
                    continue
                parent = getMainWindow()
                action = customPopupQAction(parent, mod, item, nodes).addTo(popup)
                pass
            pass
        if hasattr(mod, "customPopup"):
            mod.customPopup(getMainWindow(), popup, nodes)
            pass
        return
    # --
    # Rename popup
    if len(nodes) == 1:
        if max_depth == 1:
            RenameCustomPopupQAction(getMainWindow(), nodes).addTo(popup)
            pass
        pass
    # --
    # Publish / Unpublish content
    if len(nodes) == 1:
        if max_depth == 1:
            if hasattr(nodes[0], "__corba__object__"):
                PublishCustomPopupQAction(getMainWindow(), nodes).addTo(popup)
                pass
            pass
        pass
    # --
    # Edit popup
    if len(nodes) == 1:
        xtree = xtrees[0]
        is_editable = 1
        # We must begin by the item itself !!
        parent = xtree
        while 1:
            if parent is None: break
            x = parent.xattribute
            if x:
                mode = x.mode
                if mode != "rw":
                    is_editable = 0
                    pass
                pass
            parent = parent.parent
            pass
        if is_editable:
            customPopupUsualQAction(getMainWindow(), nodes, "Edit").addTo(popup)
            pass
        pass
    # --
    # Seperator
    if len(nodes) == 1:
        popup.insertSeparator()
        pass
    # --
    # Move popup
    if len(nodes) == 1:
        if is_editable:
            customPopupUsualQAction(getMainWindow(), nodes, "Move").addTo(popup)
            pass
        pass
    # --
    # Cut popup
    if len(nodes) >= 1:
        if max_depth == 1:
            CutCustomPopupQAction(getMainWindow(), nodes).addTo(popup)
            pass
        pass
    # --
    # Copy popup
    if len(nodes) >= 1:
        CopyCustomPopupQAction(getMainWindow(), nodes).addTo(popup)
        pass
    # --
    # Usual, Shallow and Deep Paste
    if len(nodes) <= 1:
        if max_depth <= 1:
            if hasattr(getMainWindow(), "__buffer__"):
                buffer = getattr(getMainWindow(), "__buffer__")
                buffer_type = getMainWindow().__buffer__type__
                message(buffer_type)
                if buffer_type == "Cut":
                    SpecialPasteCustomPopupQAction(getMainWindow(), nodes, "Usual").addTo(popup)
                else:
                    for key in "Shallow", "Deep" :
                        SpecialPasteCustomPopupQAction(getMainWindow(), nodes, key).addTo(popup)
                        pass
                    pass
                pass
            pass
        pass
    # --
    # Seperator
    if len(nodes) >= 1:
        popup.insertSeparator()
        pass
    # --
    # Delete popup
    if len(nodes) >= 1:
        if max_depth == 1:
            DeleteCustomPopupQAction(getMainWindow(), nodes).addTo(popup)
            pass
        pass
    # --
    # Seperator
    if len(nodes) >= 1:
        popup.insertSeparator()
        pass
    # --
    # Find the common base class
    if len(nodes) == 0:
        xbase = None
    elif len(nodes) == 1:
        xbase = nodes[0].__class__
    else:
        from xutilities import getMRO
        xbases = list(getMRO(nodes[0].__class__, XObject))
        for node in nodes[1:]:
            mro = getMRO(node.__class__, XObject)
            xbases_ok = []
            for c in xbases:
                if c in mro:
                    xbases_ok.append(c)
                    pass
                pass
            xbases = xbases_ok
            pass
        xbase = xbases[0]
        pass
    # --
    message(xbase, getMainWindow(), popup, nodes)
    if xbase:
        xbase.customPopup(getMainWindow(), popup, nodes)
        pass
    return

class customPopupEditOneXAttributeQAction(QAction):
    
    def __init__(self, parent, xobject, xattribute):
        QAction.__init__(self, parent)
        self.setText("Edit")
        self.parent = parent
        self.xobject = xobject
        self.xattribute = xattribute
        self.connect(self, SIGNAL("activated()"), self.activated)
        return
    
    def activated(self):
        message("hello", cls=customPopupEditOneXAttributeQAction)
        parent = self.parent
        xobject = self.xobject
        xattr = self.xattribute
        cls = xobject.__class__
        dialog = cls.createDialog(
            parent = parent,
            instance_name = None,
            xobject = xobject,
            editor = None,
            xattribute = xattr,
            )
        dialog.show()
        return
    
    pass

class customPopupUsualQActionBase(QAction):
    
    def __init__(self, parent, nodes, name):
        QAction.__init__(self, parent)
        self.setText(name)
        self.name = name
        self.parent = parent
        self.nodes = nodes
        self.connect(self, SIGNAL("activated()"), self.activated)
        return
    
    pass

class customPopupUsualQAction(customPopupUsualQActionBase):
    
    def __init__(self, parent, nodes, name):
        customPopupUsualQActionBase.__init__(self, parent, nodes, name)
        return
    
    def activated(self):
        nodes = self.nodes
        if self.name == "Edit":
            if isinstance(nodes, tuple):
                xtype = nodes[0]
                value = nodes[1]
            else:
                node = nodes[0]
                cls = node.__class__
                pass
            #
            self = self.parent
            if isinstance(nodes, tuple):
                from xdatapropertyeditor import XGuiXObjectEditorDialog
                dialog = XGuiXObjectEditorDialog(
                    cls = xtype,
                    parent = self,
                    instance_name = None,
                    object_to_edit = value,
                    editor = self,
                    )
            else:
                dialog = cls.createDialog(
                    parent = self,
                    instance_name = None,
                    xobject = node,
                    editor = None,
                    xattribute = None,
                    )
                pass
            if hasattr(dialog, "show"):
                dialog.show()
                pass
            #
            if isinstance(self, XGUIQLineEdit):
                self.setInplaceActivation(1)
                #
                baseCloseEvent = dialog.__class__.closeEvent
                def closeEvent(self, ev):
                    self.emit(PYSIGNAL("inplace_activation"), (0, ))
                    baseCloseEvent(self, ev)
                    return
                #
                dialog.__class__.closeEvent = closeEvent
                self.connect(dialog, PYSIGNAL("inplace_activation"), self.setInplaceActivation)
                pass
            #
            return
        if self.name == "Move":
            getMainWindow().moveActivated(nodes)
            return
        return
    
    pass

class RenameCustomPopupQAction(customPopupUsualQActionBase):
    
    def __init__(self, parent, nodes):
        customPopupUsualQActionBase.__init__(self, parent, nodes, "Rename")
        return
    
    def activated(self):
        message("begin", cls=CopyCustomPopupQAction)
        parent = self.parent
        xobject = self.nodes[0]
        from xdata import XAttribute
        xattr = XAttribute('instance name', xtype=XString(len_min=1))
        from xdatapropertyeditor import XAttributeEditorDialog
        dialog = XAttributeEditorDialog(parent, xobject, xattr)
        dialog.show()
        return
    
    pass

class PublishCustomPopupQAction(customPopupUsualQActionBase):
    
    def __init__(self, parent, nodes):
        node = nodes[0]
        if node.__corba__object__.isContentPublished():
            customPopupUsualQActionBase.__init__(self, parent, nodes, "Unpublish content")
        else:
            customPopupUsualQActionBase.__init__(self, parent, nodes, "Publish content")
            pass
        return
    
    def activated(self):
        nodes = self.nodes
        node = nodes[0]
        obj = node
        #
        import salome
        myStudyId = salome.sg.getActiveStudyId()
        myStudy = salome.myStudyManager.GetStudyByID(myStudyId)
        corba_object = obj.__corba__object__
        try:
            name_in_study = obj.__instance__name__
        except:
            name_in_study = None
            pass
        if name_in_study is None and hasattr(corba_object, "_narrow"):
            # --
            # Perhaps, a composite attribute is being edited
            # It has empty __instance__name__
            # So trying to find its current name in the study
            #
            ior = salome.orb.object_to_string(corba_object)
            mySObject = myStudy.FindObjectIOR(ior)
            if mySObject is not None:
                name_in_study = mySObject.GetName()
                pass
            pass
        if name_in_study is None:
            return
        if node.__corba__object__.isContentPublished():
            obj.__corba__component__.PublishInStudyWithoutContent(myStudy, None, corba_object, name_in_study)
        else:
            obj.__corba__component__.PublishInStudy(myStudy, None, corba_object, name_in_study)
            pass
        salome.sg.updateObjBrowser(0)
        return
    
    pass

class CopyCustomPopupQAction(customPopupUsualQActionBase):
    
    def __init__(self, parent, nodes):
        customPopupUsualQActionBase.__init__(self, parent, nodes, "Copy")
        return
    
    def activated(self):
        message("begin", cls=CopyCustomPopupQAction)
        getMainWindow().putInBuffer(self.nodes, "Copy")
        return
    
    pass

class CutCustomPopupQAction(customPopupUsualQActionBase):
    
    def __init__(self, parent, nodes):
        customPopupUsualQActionBase.__init__(self, parent, nodes, "Cut")
        return
    
    def activated(self):
        message("begin", cls=CutCustomPopupQAction)
        getMainWindow().putInBuffer(self.nodes, "Cut")
        getMainWindow().deleteNodes(self.nodes)
        return
    
    pass

class DeleteCustomPopupQAction(customPopupUsualQActionBase):
    
    def __init__(self, parent, nodes):
        customPopupUsualQActionBase.__init__(self, parent, nodes, "Delete")
        return
    
    def activated(self):
        message("begin", cls=DeleteCustomPopupQAction)
        getMainWindow().deleteNodes(self.nodes)
        return
    
    pass

class SpecialPasteCustomPopupQAction(customPopupUsualQActionBase):
    
    def __init__(self, parent, nodes, paste_type):
        if paste_type == "Usual":
            text = ""
        else:
            text = "%s "%(paste_type)
            pass
        customPopupUsualQActionBase.__init__(self, parent, nodes, "%sPaste"%(text))
        self.paste_type = paste_type
        return
    
    def activated(self):
        message("begin", cls=SpecialPasteCustomPopupQAction)
        self.parent.specialPaste(self.nodes, self.paste_type)
        return
    
    pass

# -----------------------------------------------
# -----------------------------------------------

class XGUIQComboBox(QComboBox):
    
    def __init__(self, xtype, xattribute, cls, parent, xobject, value, text):
        QComboBox.__init__(self, parent)
        self.setWFlags(Qt.WDestructiveClose)
        #
        self.has_default_value = 0
        if xattribute.hasDefaultValue():
            self.has_default_value = 1
            self.default_value = xattribute.default_value
            self.default_value_comment = " (default)"
            pass
        #
        self.text2value = {}
        if text is not None:
            self.insertItem(value)
            pass
        #
        try:
            into_list = xattribute.xtype.into
        except AttributeError:
            into_list  = [None]
            into_list += xattribute.xtype.xtypes[1].into
            pass
        #
        for v in into_list:
            if v == value : continue
            self.insertItem(v)
            pass
        #
        self.xattribute = xattribute
        self.xobject = xobject
        self.cls=cls
        #
        return
    
    def insertItem(self, value):
        text = str(value)
        if self.has_default_value:
            if value == self.default_value:
                text = text + self.default_value_comment
                pass
            pass
        self.text2value[text] = value
        QComboBox.insertItem(self, text)
        return
    
    def getValueAndText(self):
        text = str(self.currentText())
        value = self.text2value[text]
        return value, str(value)
    
    def mousePressEvent(self,event):
        message(event.button())
        if event.button()==QMouseEvent.RightButton:
            menu=QPopupMenu(self)
            menu.clear()
            from xtypes import XType
            if not issubclass(self.cls, XType):
                self.cls.customEditorPopup(self.xattribute,self,menu,self.xobject)
                pass
            menu.insertItem("Cancel", self.my_close)
            menu.popup(event.globalPos())
            return
        QComboBox.mousePressEvent(self,event)
        return
    
    def my_close(self, item_id):
        self.emit(PYSIGNAL('canceled'), (0, ))
        return
    
    pass

class XGUIQLineEdit(QLineEdit):
    
    def __init__(self, xtype, xattribute, cls, parent, xobject, value, text):
        message(self, xtype, xattribute, cls, parent, xobject, value, text)
        QLineEdit.__init__(self, parent)
        self.setWFlags(Qt.WDestructiveClose)
        if text is None:
            text = ""
            pass
        self.setText(text)
        self.connect(parent, PYSIGNAL("browser_selection_changed"), self.browserSelectionChanged)
        self.xattribute = xattribute
        self.cls = cls
        self.xobject = xobject
        self.initial_value = value
        self.initial_text = text
        self.item_ids = {}
        self.inplace_activation = 0
        # --
        if pyqt_module_name == "qt":
            pass
        else:
            self.setContextMenuPolicy(Qt.CustomContextMenu)
            self.connect(self, SIGNAL("customContextMenuRequested(const QPoint &)"), self.contextMenuRequested_qt4)
            pass
        # --
        return
    
    def specialPaste(self, nodes, paste_type):
        message('HELLO !!!!', nodes, paste_type)
        nodes = getMainWindow().__buffer__
        key = paste_type
        # --
        if key == "Usual":
            copy = None
            getMainWindow().__buffer__type__ = "Copy"
        elif key == "Shallow":
            from copy import copy
        else:
            from copy import deepcopy
            copy = deepcopy
            pass
        #
        n = nodes[0]
        #
        if copy:
            n_copy = copy(n)
        else:
            n_copy = n
            pass
        #
        self.setValue(n_copy)
        #
        return
    
    def browserSelectionChanged(self, selection):
        message(selection)
        if self.inplace_activation:
            self.emit(PYSIGNAL("browser_selection_changed"), (selection, ))
            return
        selection = [ i.xtree for i in selection ]
        if len(selection) == 0:
            value = None
            text = "None"
        elif len(selection) == 1:
            selection = selection[0]
            value = selection.node
            try:
                text = selection.full_name
            except AttributeError:
                text = selection.name
                pass
            pass
        else:
            value = [ item.node for item in selection ]
            text = []
            for item in selection:
                try:
                    text.append(item.full_name)
                except AttributeError:
                    text.append(item.name)
                    pass
                pass
            text = ", ".join(text)
            pass
        #
        xtype = self.xattribute.xtype
        #
        if hasattr(value, '_narrow'):
            from xsalome import corba2python
            value = corba2python(value)
            pass
        #
        try:
            value = xtype(value)
        except:
            return
        message(value)
        self.setReadOnly(1)
        #
        self.theText = text
        self.theValue = value
        if text is None:
            text = ""
            pass
        self.setText(text)
        return
    
    def setValue(self, value):
        message(value, cls=XGUIQLineEdit)
        self.theValue = value
        self.theText = str(value)
        if isinstance(value, XObject):
            self.theText = "%s object"%(value.__class__.__name__)
        elif value.__class__ in [list, tuple]:
            self.theText = self.theText[1:-1]
            pass
        self.setText(self.theText)
        return
    
    def getValueAndText(self):
        try:
            value, text = self.theValue, self.theText
        except AttributeError:
            text = self.text()
            try:
                text = str(text)
            except UnicodeEncodeError:
                text = unicode(text)
                pass
            value = text
            if text == self.initial_text:
                value, text = self.initial_value, self.initial_text
                pass
            pass
        message(value, text, cls=XGUIQLineEdit)
        return value, text
    
    def addItemId(self, item_id, target):
        message(self, item_id, target)
        self.item_ids[item_id] = target
        # message(self.item_ids)
        return
    
    def contextMenuRequested_qt4(self, position):
        message(position, cls=XGUIQLineEdit)
        # self.contextMenuRequested(None, position, 0)
        menu = self.createPopupMenu()
        message(menu, cls=XGUIQLineEdit)
        position = self.mapToGlobal(position)
        menu.popup(position)
        menu.exec_()
        return
    
    def createPopupMenu(self):
        message(cls=XGUIQLineEdit)
        menu = QLineEdit.createPopupMenu(self)
        menu.clear()
        #
        xattribute = self.xattribute
        xtype = xattribute.xtype
        #
        pos_id = -1
        #
        try:
            value = self.theValue
        except AttributeError:
            value = self.initial_value
            pass
        #
        if xattribute.hasDefaultValue():
            value, text = self.getValueAndText()
            if value != xattribute.getDefaultValue():
                id = menu.insertItem("Default value", self.setDefaultValue, 0, -1, pos_id)
                pass
            pass
        #
        all_xtypes = [xtype]
        while 1:
            l = all_xtypes[:]
            all_xtypes = []
            is_xmultypes = 0
            for x in l:
                from xdata import XMulTypes
                if isinstance(x, XMulTypes):
                    is_xmultypes = 1
                    all_xtypes += x.xtypes
                else:
                    all_xtypes.append(x)
                    pass
                pass
            if not is_xmultypes:
                break
            pass
        message(all_xtypes, cls=XGUIQLineEdit)
        #
        if isinstance(value, XObject):
            customPopupUsualQAction(self, [value], "Edit").addTo(menu)
            CopyCustomPopupQAction(self, [value]).addTo(menu)
            pass
        if isinstance(value, list):
            xtype_ok = None
            for xtype in all_xtypes:
                from xdata import XValueError
                try:
                    xtype(value)
                    xtype_ok = xtype
                    break
                except XValueError:
                    pass
                pass
            if xtype_ok:
                qaction = customPopupUsualQAction(self, (xtype, value, ), "Edit")
                qaction.addTo(menu)
                pass
            pass
        #
        dict_xtypes = {
            "XInstance": None,
            "XList": None,
            "XInputFileName": None,
            "XInputDirName": None,
            }
        #
        isNewAllowed = 0
        for key in dict_xtypes.keys():
            mod = __import__('xdata')
            cls = getattr(mod, key)
            value = []
            for x in all_xtypes:
                if isinstance(x, cls):
                    value.append(x)
                    if key == 'XList':
                        isNewAllowed = 1
                    elif key == 'XInstance':
                        classes = x.classes
                        for c in classes:
                            if isinstance(c, str):
                                from xutilities import getRealClassFromString
                                c = getRealClassFromString(c)
                                pass
                            if issubclass(c, XObject):
                                isNewAllowed = 1
                                break
                            pass
                        pass
                    pass
                pass
            dict_xtypes[key] = value
            pass
        #
        for key in ["XInputFileName", "XInputDirName"]:
            value = dict_xtypes[key]
            if value:
                for v in value:
                    father = menu
                    string = "Browse"
                    if key == "XInputDirName":
                        string += " dir ..."
                        pass
                    if key == "XInputFileName":
                        xtype = v
                        if xtype.suffix_into:
                            filter = "("
                            for suffix in xtype.suffix_into:
                                filter += "*%s "%(suffix)
                                pass
                            filter += ")"
                            pass
                        else:
                            filter = "(*)"
                            pass
                        string += " " + filter
                        pass
                    item_id = father.insertItem(string, self.actionActivated)
                    self.addItemId(item_id, v)
                    pass
                pass
            pass
        #
        if isNewAllowed:
            key = "XInstance"
            value = dict_xtypes[key]
            if value:
                clsss = []
                for xtype in value:
                    classes = xtype.classes
                    for c in classes:
                        if isinstance(c, str):
                            from xutilities import getRealClassFromString
                            c = getRealClassFromString(c)
                            pass
                        clsss.append(c)
                        pass
                    pass
                from xtree import getMainXTree
                xtree = getMainXTree(depth_max=1)
                l = []
                for x in xtree.children:
                    if isinstance(x.node, tuple(clsss)):
                        l.append(x)
                        pass
                    pass
                if len(l) > 0:
                    existing_popup_menu = QPopupMenu(getMainWindow())
                    menu.insertItem("Existing", existing_popup_menu)
                    for x in l:
                        item_id = existing_popup_menu.insertItem(x.name, self.actionExistingInstanceActivated)
                        self.addItemId(item_id, x)
                        pass
                    pass
                pass
            pass
        #
        if isNewAllowed:
            new_popup_menu = QPopupMenu(getMainWindow())
            menu.insertItem("New", new_popup_menu)
            pass
        #
        num_non_empty = 0
        for val in dict_xtypes.values():
            if val: num_non_empty += 1
            pass
        shift = ( num_non_empty == 1 )
        #
        key = "XInstance"
        value = dict_xtypes[key]
        if value:
            is_xobj = 0
            for xtype in value:
                classes = xtype.classes
                for c in classes:
                    if isinstance(c, str):
                        from xutilities import getRealClassFromString
                        c = getRealClassFromString(c)
                        pass
                    if issubclass(c, XObject):
                        is_xobj = 1
                        break
                    pass
                if is_xobj:
                    break
                pass
            if is_xobj:
                if shift:
                    instance_popup_menu = new_popup_menu
                else:
                    instance_popup_menu = NewInstanceQPopupMenu(getMainWindow(), self)
                    new_popup_menu.insertItem("instance", instance_popup_menu)
                    pass
                pass
            pass
        is_buffer_available = 0
        classes_to_insert = []
        for v in value:
            classes = v.classes
            for c in classes:
                if isinstance(c, str):
                    from xutilities import getRealClassFromString
                    c = getRealClassFromString(c)
                    pass
                #
                if not is_buffer_available:
                    try:
                        buffer = getMainWindow().__buffer__
                    except AttributeError:
                        buffer = []
                        pass
                    if len(buffer) == 1:
                        obj = buffer[0]
                        if isinstance(obj, c):
                            is_buffer_available = 1
                            pass
                        pass
                    pass
                #
                if issubclass(c, XObject):
                    classes_to_insert.append(c)
                    pass
                pass
            pass
        if classes_to_insert:
            self.insertInstanceSubmenu(instance_popup_menu, classes_to_insert)
            pass
        #
        key = "XList"
        value = dict_xtypes[key]
        for v in value:
            seq = v.sequence
            if seq is None: continue
            len_multiple = v.len_multiple
            # if len_multiple > 1: continue
            string = "list with sequence : " + str(seq)
            father = new_popup_menu
            item_id = father.insertItem(string, self.actionActivated)
            self.addItemId(item_id, v)
            pass

        #
        if is_buffer_available:
            buffer_type = getMainWindow().__buffer__type__
            message(buffer_type)
            if buffer_type == "Cut":
                SpecialPasteCustomPopupQAction(self, [], "Usual").addTo(menu)
            else:
                for key in "Shallow", "Deep" :
                    SpecialPasteCustomPopupQAction(self, [], key).addTo(menu)
                    pass
                pass
            pass
        #
        from xtypes import XType
        if not issubclass(self.cls, XType):
            self.cls.customEditorPopup(self.xattribute, self, menu, self.xobject)
            pass
        #
        menu.insertItem("Cancel", self.my_close)
        #
        return menu

    def my_close(self, item_id):
        self.emit(PYSIGNAL('canceled'), (0, ))
        return
    
    def insertInstanceSubmenu(self, father, ccc):
        for c in ccc:
            # --
            bases = []
            from xdata import getXClasses
            for cls in getXClasses():
                if c not in cls.__bases__: continue
                bases.append(cls)
                pass
            from operator import attrgetter
            bases.sort(key=attrgetter('__name__'))
            # --
            if len(ccc) == 1:
                if c.__xabstract__:
                    if bases:
                        self.insertInstanceSubmenu(father, bases)
                        return
                    pass
                pass
            # --
            if not c.__xabstract__:
                item_id = father.insertItem(c.__name__, self.actionActivated)
                self.addItemId(item_id, c)
                pass
            # --
            if bases:
                c_popup_menu = NewInstanceQPopupMenu(getMainWindow(), self)
                father.insertItem("%s ..."%(c.__name__), c_popup_menu)
                self.insertInstanceSubmenu(c_popup_menu, bases)
                pass
            # --
            pass
        return
    
    def setInplaceActivation(self, value):
        self.inplace_activation = value
        self.emit(PYSIGNAL("inplace_activation"), (value, ))
        return

    def actionExistingInstanceActivated(self, item_id):
        if item_id not in self.item_ids: return
        target = self.item_ids[item_id]
        message(item_id, target, cls=XGUIQLineEdit)
        self.theText = target.name
        self.theValue = target.node
        self.setText(target.name)
        return
    
    def actionActivated(self, item_id):
        if item_id not in self.item_ids: return
        target = self.item_ids[item_id]
        message(item_id, target, cls=XGUIQLineEdit)
        #
        from xdata import XList
        from xdata import XInputFileName
        from xdata import XInputDirName
        #
        if 0:
            pass
        elif isinstance(target, XInputFileName):
            self.getOpenFileName(target)
            return
        elif isinstance(target, XInputDirName):
            self.getOpenDirName(target)
            return
        elif isinstance(target, XList):
            message("AAAAAAAFDSFDSFS")
            from xdatapropertyeditor import XGuiXObjectEditorDialog
            dialog = XGuiXObjectEditorDialog(
                cls = target,
                parent = self,
                instance_name = None,
                object_to_edit = None,
                editor = self,
                )
        else:
            cls = target
            dialog = cls.createDialog(
                parent = self,
                instance_name = None,
                xobject = None,
                editor = self,
                xattribute = None,
                )
            pass
        dialog.show()
        #
        self.setInplaceActivation(1)
        #
        baseCloseEvent = dialog.__class__.closeEvent
        def closeEvent(self, ev):
            self.emit(PYSIGNAL("inplace_activation"), (0, ))
            baseCloseEvent(self, ev)
            return
        dialog.__class__.closeEvent = closeEvent
        self.connect(dialog, PYSIGNAL("inplace_activation"), self.setInplaceActivation)
        #
        return
    
    
##            if item.xattribute.hasDefaultValue():
##                id = qt_menu.insertItem("Default value")
##                qt_menu.connectItem(id, self.setDefaultValue)
##                pass
##            #
##            # In-place creation/editing popup commands
##            #
##            from xtypes import XInstance, XMulTypes, XList, XTuple, XNone

##            classes = []
##            isEditable = 0
##            isList = 0
##            isNewAllowed = 0
##            if isinstance(item.xattribute.getXtype(), XInstance):
##                classes = item.xattribute.getXtype().getClasses()
##                isEditable = 1
##                pass
##            elif isinstance(item.xattribute.getXtype(), (XList, XTuple)):
##                classes = item.xattribute.getXtype().getSequence()
##                if classes is not None and isinstance(classes[0], XInstance):
##                    classes = classes[0].getClasses()
##                    isNewAllowed = 1
##                isList = 1
##                pass
##            elif isinstance(item.xattribute.getXtype(), XMulTypes):
##                classes = item.xattribute.getXtype().getXtypes()
##                if isinstance(classes[0], XNone):
##                    if isinstance(classes[1], XInstance):
##                        classes = classes[1].getClasses()
##                        isEditable = 1
##                    elif isinstance(classes[1], (XList, XTuple)):
##                        classes = classes[1].getSequence()
##                        if classes[0] is not None and isinstance(classes[0], XInstance):
##                            classes = classes[0].getClasses()
##                            isNewAllowed = 1
##                            pass
##                        isList = 1
##                        pass
##                    pass
##                pass
##            #
##            #for c in classes:
##            #    print c
##            #    pass
##            #print isList, isNewAllowed
            
##            if not isEditable and not isNewAllowed:
##                classes = []
##                pass
##            #
##            # In-place editing
##            # IMPORTANT!
##            # value.__instance__name__ should be None for in-place editing
##            #
##            if isEditable:
##                value, text = self.value_editor.getValueAndText()

##                try:
##                    if value is not None and value.__instance__name__ is None:
##                        id = qt_menu.insertItem("Edit")
##                        qt_menu.connectItem(id, self.edit)
##                        pass
##                    pass
##                except AttributeError:
##                    pass
##                pass
##            #
##            # In-place creation
##            #
##            from xguitools import inplaceCreationMenu
##            inplaceCreationMenu(self, qt_menu, item, classes)
##            #
##            # List-specific commands
##            #
##            if isList:
##                if qt_menu.count() > 0:
##                    qt_menu.insertSeparator()
##                    pass
                
##                id = qt_menu.insertItem("Add item")
##                qt_menu.connectItem(id, self.listAdd)
##                id = qt_menu.insertItem("Delete items")
##                qt_menu.connectItem(id, self.listDelete)
##                pass
##            #
##            if qt_menu.count() > 0:
##                qt_menu.popup(point)
##                pass
            
##            pass
##        pass



        
    def getOpenFileName(self, target):
        xtype = target
        if xtype.suffix_into:
            filter = "("
            for suffix in xtype.suffix_into:
                filter += "*%s "%(suffix)
                pass
            filter += ")"
            pass
        else:
            filter = QString.null
            pass
        fn = QFileDialog.getOpenFileName(QString.null,
                                         filter,
                                         self)
        if fn.isEmpty(): return
        fileName = str(fn)
        self.setText(fileName)
        return
    
    def getOpenDirName(self, target):
        fn = QFileDialog.getExistingDirectory(QString.null,
                                              self)
        if fn.isEmpty(): return
        fileName = str(fn)
        self.setText(fileName)
        return
    
    def setDefaultValue(self, action=None):
        self.setValue(self.xattribute.getDefaultValue())
        return
    
    pass





####        #
####        from xguitools import isXList            
####        isList, listSeq = isXList(xtree.xattribute)
####        if isList and listSeq[0] is not None and isinstance(listSeq[0], XInstance):
####            listSeq = listSeq[0].getClasses()
####            isNewAllowed = 1
####            pass
####        #
####        if non_xobj == 0:
####            depth = xtree.depth
####            if depth > max_depth: max_depth = depth
####            pass
####        pass
####        #
####        if non_xobj and has_collapsed == 0 and not isList: return
####        #
    
    
    
####        if non_xobj == 0:
####            if len(items) == 1:
####                id = menu.insertItem("Edit")
####                menu.connectItem(id, self.edit)
####                pass
####            if max_depth == 1:
####                id = menu.insertItem("Delete")
####                menu.connectItem(id, self.delete)
####                pass
####            pass
        
####        if isList and len(items) == 1:
####            if menu.count() > 0:
####                menu.insertSeparator()
####                pass
####            from xguitools import inplaceCreationMenu
####            if isNewAllowed and inplaceCreationMenu(self, menu, items[0], listSeq):
####                menu.insertSeparator()
####                pass
####            id = menu.insertItem("Add item")
####            menu.connectItem(id, self.listAdd)
####            id = menu.insertItem("Delete items")
####            menu.connectItem(id, self.listDelete)
####            pass
####        if has_collapsed:
####            if menu.count() > 0:
####                menu.insertSeparator()
####                pass
####            id = menu.insertItem("Expand All")
####            menu.connectItem(id, self.expandAll)
####            pass
        
####        #


    
    
##    # import SALOMEDS
####    i = 0
####    entry = salome.sg.getSelected(i)
####    myStudyId = salome.sg.getActiveStudyId()
####    myStudy = salome.myStudyManager.GetStudyByID(myStudyId)
####    sobj = myStudy.FindObjectID(entry)
####    #
####    attr = sobj.FindAttribute("AttributeName")[1]
####    attr = attr._narrow(SALOMEDS.AttributeName)
####    name = attr.Value()
####    attr = sobj.FindAttribute("AttributeIOR")[1]
####    if attr is None: return
####    attr = attr._narrow(SALOMEDS.AttributeIOR)
####    ior = attr.Value()
####    node = salome.orb.string_to_object(ior)
####    #
####    from xsalome import corba2python
####    obj = corba2python(node)
####    cls = obj.__class__
####    message("cls:", cls)
####    if cls is None: return
    
####    #
####    try:
####        actions = ["edit"]
####        for xmeth in cls.__object__xmethods__:
####            actions.append(xmeth.name)
####            pass
####        for action in actions:
####            qaction = customPopupQAction(action = action,
####                                         cls = cls,
####                                         name = name,
####                                         obj = obj,
####                                         sobject = sobj,
####                                         )
####            qaction.addTo(popup)
####            pass
####    except:
####        xobj, xattr = getXObjAttr(sobj)
####        if xattr is None:
####            return
        
####        #
####        # List-specific items
####        #
####        from xguitools import isXList            
####        isList, listSeq = isXList(xattr)
####        if isList:
####            if popup.count() > 0:
####                popup.insertSeparator()
                
####            from xdata import XInstance
####            if listSeq[0] is not None and isinstance(listSeq[0], XInstance):
####                listSeq = listSeq[0].getClasses()
####                from xguitools import inplaceCreationMenu
####                create_action = ListPopupAction(action = "---",
####                                                name = name,
####                                                xobj = xobj,
####                                                xattr = xattr,
####                                                classes = listSeq,
####                                                )
####                if inplaceCreationMenu(getMainWindow(), popup, create_action, listSeq):
####                    popup.insertSeparator()
####                    pass
####            else:
####                listSeq = [c.__class__ for c in listSeq]
                
####            action_add = ListPopupAction(action = "Add item",
####                                         name = name,
####                                         xobj = xobj,
####                                         xattr = xattr,                                             
####                                         classes = listSeq,
####                                         )
####            action_del = ListPopupAction(action = "Delete items",
####                                         name = name,
####                                         xobj = xobj,
####                                         xattr = xattr,                                             
####                                         classes = listSeq,
####                                         )
####            action_add.addTo(popup)
####            action_del.addTo(popup)
    pass

class NewInstanceQPopupMenu(QPopupMenu):
    def __init__(self, parent, editor):
        QPopupMenu.__init__(self, parent)
        self.editor = editor
        from xmainmenubar import DynamicTip
        if pyqt_module_name == "qt":
            self.t = DynamicTip(self)
            pass
        return
    def tip( self, p ):
        for key in range(self.count()):
            r = self.itemGeometry(key)
            if r.contains(p):
                pos_id = key
                item_id = self.idAt(pos_id)
                message(item_id, cls=NewInstanceQPopupMenu)
                try:
                    target = self.editor.item_ids[item_id]
                except KeyError:
                    return QRect( 0,0, -1,-1 ), None
                message(item_id, target, cls=NewInstanceQPopupMenu)
                text = target.getToolTip(target)
                message(text, cls=NewInstanceQPopupMenu)
                return r, text
            pass
        return QRect( 0,0, -1,-1 ), None
    pass
