
from xutilities import message
from xqt import *

class RunThread(QThread):
    
    def __init__(self, obj):
        QThread.__init__(self)
        self.obj = obj
        return
    
    def run(self):
        self.obj.run()
        return
    
    pass

class XSolverDialog(QDialog):
    
    def __init__(self, parent, obj):
        QDialog.__init__(self, parent)
        self.setWFlags(Qt.WDestructiveClose)
        self.setCaption(self.tr("Solver Control"))
        
        self.obj = obj
        
        nRows = 3
        grid_layout = QGridLayout(self, nRows, 1, 10)
        
        numRows = 0
        self.autoClose = QCheckBox(self.tr("Auto close after finishing"), self)
        self.autoClose.setChecked(1)
        grid_layout.addWidget(self.autoClose, numRows, 0)
        numRows += 1
        self.progress = QProgressBar(self)
        grid_layout.addWidget(self.progress, numRows, 0)
        numRows += 1
        button_layout = QHBoxLayout(None)
        grid_layout.addLayout(button_layout, numRows, 0)
        
        self.startBtn = QPushButton(self.tr("Run"), self)
        self.connect(self.startBtn, SIGNAL("clicked()"), self.onStart)
        self.stopBtn = QPushButton(self.tr("Stop"), self)
        self.connect(self.stopBtn, SIGNAL("clicked()"), self.onStop)
        self.quitBtn = QPushButton(self.tr("Quit"), self)
        self.connect(self.quitBtn, SIGNAL("clicked()"), self.onQuit)
        button_layout.addWidget(self.startBtn)
        button_layout.addWidget(self.stopBtn)
        button_layout.addWidget(self.quitBtn)
        
        self.timer = QTimer(self)
        self.connect(self.timer, SIGNAL("timeout()"), self.onTimer)
        
        self.time_interval = obj.getTimeInterval()
        
        self.startBtn.emit(SIGNAL("clicked()"), ())
        self.show()
        return
    
    def onStart(self):
        message("onStart", cls=XSolverDialog)
        text = self.startBtn.text().ascii()
        if text == "Start":
            text = "Run"
            pass
        text = "on" + text
        meth = getattr(self, text)
        meth()
        return
    
    def onRun(self):
        message("onRun", cls=XSolverDialog)
        self.qthread = RunThread(self.obj)
        self.qthread.start()
        self.timer.start(self.time_interval)
        # self.startBtn.setText(self.tr("Pause"))
        self.startBtn.setEnabled(0)
        return
    
    def onStop(self):
        message("onStop", cls=XSolverDialog)
        self.obj.stop()
        self.startBtn.setText(self.tr("Run"))
        return
    
    def onQuit(self):
        message("onQuit", cls=XSolverDialog)
        self.close()
        return
    
    def closeEvent(self, event):
        message("closeEvent", cls=XSolverDialog)
        self.obj.quit()
        QDialog.closeEvent(self, event)
        return
    
    def onTimer(self):
        message("onTimer", cls=XSolverDialog)
        if not self.qthread.running():
            if self.autoClose.isChecked():
                self.close()
            else:
                self.timer.stop()
                self.startBtn.setText(self.tr("Run"))
                pass
            pass
        
        self.progress.setTotalSteps(self.obj.getTotalSteps())
        self.progress.setProgress(self.obj.getProgress())
        
        return
    
    pass
