/* server functions auto-generated by pidl */
#include "../librpc/gen_ndr/ndr_frsrpc.h"

/* frsrpc - dcerpc server boilerplate generated by pidl */


static NTSTATUS frsrpc__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_FRSRPC_BIND
	return DCESRV_INTERFACE_FRSRPC_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void frsrpc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_FRSRPC_UNBIND
	DCESRV_INTERFACE_FRSRPC_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS frsrpc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_frsrpc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_frsrpc.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_frsrpc.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_frsrpc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_frsrpc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS frsrpc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct frsrpc_FrsSendCommPkt *r2 = (struct frsrpc_FrsSendCommPkt *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(frsrpc_FrsSendCommPkt, NDR_IN, r2);
		}
		r2->out.result = dcesrv_frsrpc_FrsSendCommPkt(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsrpc_FrsSendCommPkt will reply async\n"));
		}
		break;
	}
	case 1: {
		struct FRSRPC_VERIFY_PROMOTION_PARENT *r2 = (struct FRSRPC_VERIFY_PROMOTION_PARENT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_VERIFY_PROMOTION_PARENT, NDR_IN, r2);
		}
		dcesrv_FRSRPC_VERIFY_PROMOTION_PARENT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_VERIFY_PROMOTION_PARENT will reply async\n"));
		}
		break;
	}
	case 2: {
		struct FRSRPC_START_PROMOTION_PARENT *r2 = (struct FRSRPC_START_PROMOTION_PARENT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_START_PROMOTION_PARENT, NDR_IN, r2);
		}
		dcesrv_FRSRPC_START_PROMOTION_PARENT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_START_PROMOTION_PARENT will reply async\n"));
		}
		break;
	}
	case 3: {
		struct FRSRPC_NOP *r2 = (struct FRSRPC_NOP *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_NOP, NDR_IN, r2);
		}
		dcesrv_FRSRPC_NOP(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_NOP will reply async\n"));
		}
		break;
	}
	case 4: {
		struct FRSRPC_BACKUP_COMPLETE *r2 = (struct FRSRPC_BACKUP_COMPLETE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE, NDR_IN, r2);
		}
		dcesrv_FRSRPC_BACKUP_COMPLETE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE will reply async\n"));
		}
		break;
	}
	case 5: {
		struct FRSRPC_BACKUP_COMPLETE_5 *r2 = (struct FRSRPC_BACKUP_COMPLETE_5 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_5, NDR_IN, r2);
		}
		dcesrv_FRSRPC_BACKUP_COMPLETE_5(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_5 will reply async\n"));
		}
		break;
	}
	case 6: {
		struct FRSRPC_BACKUP_COMPLETE_6 *r2 = (struct FRSRPC_BACKUP_COMPLETE_6 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_6, NDR_IN, r2);
		}
		dcesrv_FRSRPC_BACKUP_COMPLETE_6(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_6 will reply async\n"));
		}
		break;
	}
	case 7: {
		struct FRSRPC_BACKUP_COMPLETE_7 *r2 = (struct FRSRPC_BACKUP_COMPLETE_7 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_7, NDR_IN, r2);
		}
		dcesrv_FRSRPC_BACKUP_COMPLETE_7(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_7 will reply async\n"));
		}
		break;
	}
	case 8: {
		struct FRSRPC_BACKUP_COMPLETE_8 *r2 = (struct FRSRPC_BACKUP_COMPLETE_8 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_8, NDR_IN, r2);
		}
		dcesrv_FRSRPC_BACKUP_COMPLETE_8(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_8 will reply async\n"));
		}
		break;
	}
	case 9: {
		struct FRSRPC_BACKUP_COMPLETE_9 *r2 = (struct FRSRPC_BACKUP_COMPLETE_9 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_9, NDR_IN, r2);
		}
		dcesrv_FRSRPC_BACKUP_COMPLETE_9(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_9 will reply async\n"));
		}
		break;
	}
	case 10: {
		struct FRSRPC_VERIFY_PROMOTION_PARENT_EX *r2 = (struct FRSRPC_VERIFY_PROMOTION_PARENT_EX *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_VERIFY_PROMOTION_PARENT_EX, NDR_IN, r2);
		}
		dcesrv_FRSRPC_VERIFY_PROMOTION_PARENT_EX(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_VERIFY_PROMOTION_PARENT_EX will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_frsrpc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS frsrpc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct frsrpc_FrsSendCommPkt *r2 = (struct frsrpc_FrsSendCommPkt *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function frsrpc_FrsSendCommPkt replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(frsrpc_FrsSendCommPkt, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in frsrpc_FrsSendCommPkt\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct FRSRPC_VERIFY_PROMOTION_PARENT *r2 = (struct FRSRPC_VERIFY_PROMOTION_PARENT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_VERIFY_PROMOTION_PARENT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_VERIFY_PROMOTION_PARENT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_VERIFY_PROMOTION_PARENT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct FRSRPC_START_PROMOTION_PARENT *r2 = (struct FRSRPC_START_PROMOTION_PARENT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_START_PROMOTION_PARENT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_START_PROMOTION_PARENT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_START_PROMOTION_PARENT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct FRSRPC_NOP *r2 = (struct FRSRPC_NOP *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_NOP replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_NOP, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_NOP\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct FRSRPC_BACKUP_COMPLETE *r2 = (struct FRSRPC_BACKUP_COMPLETE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_BACKUP_COMPLETE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct FRSRPC_BACKUP_COMPLETE_5 *r2 = (struct FRSRPC_BACKUP_COMPLETE_5 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_5 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_5, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_BACKUP_COMPLETE_5\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct FRSRPC_BACKUP_COMPLETE_6 *r2 = (struct FRSRPC_BACKUP_COMPLETE_6 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_6 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_6, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_BACKUP_COMPLETE_6\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct FRSRPC_BACKUP_COMPLETE_7 *r2 = (struct FRSRPC_BACKUP_COMPLETE_7 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_7 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_7, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_BACKUP_COMPLETE_7\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct FRSRPC_BACKUP_COMPLETE_8 *r2 = (struct FRSRPC_BACKUP_COMPLETE_8 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_8 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_8, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_BACKUP_COMPLETE_8\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct FRSRPC_BACKUP_COMPLETE_9 *r2 = (struct FRSRPC_BACKUP_COMPLETE_9 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_BACKUP_COMPLETE_9 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_BACKUP_COMPLETE_9, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_BACKUP_COMPLETE_9\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct FRSRPC_VERIFY_PROMOTION_PARENT_EX *r2 = (struct FRSRPC_VERIFY_PROMOTION_PARENT_EX *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function FRSRPC_VERIFY_PROMOTION_PARENT_EX replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(FRSRPC_VERIFY_PROMOTION_PARENT_EX, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in FRSRPC_VERIFY_PROMOTION_PARENT_EX\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_frsrpc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS frsrpc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_frsrpc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_frsrpc_interface = {
	.name		= "frsrpc",
	.syntax_id  = {{0xf5cc59b4,0x4264,0x101a,{0x8c,0x59},{0x08,0x00,0x2b,0x2f,0x84,0x26}},1.1},
	.bind		= frsrpc__op_bind,
	.unbind		= frsrpc__op_unbind,
	.ndr_pull	= frsrpc__op_ndr_pull,
	.dispatch	= frsrpc__op_dispatch,
	.reply		= frsrpc__op_reply,
	.ndr_push	= frsrpc__op_ndr_push
};


static NTSTATUS frsrpc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_frsrpc.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_frsrpc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_frsrpc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("frsrpc_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool frsrpc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_frsrpc_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_frsrpc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_frsrpc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool frsrpc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_frsrpc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_frsrpc_interface, sizeof(*iface));
		return true;
	}

	return false;	
}
	
NTSTATUS dcerpc_server_frsrpc_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "frsrpc";

	/* fill in all the operations */
	ep_server.init_server = frsrpc__op_init_server;

	ep_server.interface_by_uuid = frsrpc__op_interface_by_uuid;
	ep_server.interface_by_name = frsrpc__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'frsrpc' endpoint server!\n"));
		return ret;
	}

	return ret;
}

