/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_dbgidl.h"

static bool api_dummy_dbgidl(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct dummy_dbgidl *r;

	call = &ndr_table_dbgidl.calls[NDR_DUMMY_DBGIDL];

	r = talloc(talloc_tos(), struct dummy_dbgidl);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dummy_dbgidl, r);
	}

	_dummy_dbgidl(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dummy_dbgidl, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_dbgidl_cmds[] = 
{
	{"DUMMY_DBGIDL", NDR_DUMMY_DBGIDL, api_dummy_dbgidl},
};

void dbgidl_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_dbgidl_cmds;
	*n_fns = sizeof(api_dbgidl_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_dbgidl_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "dbgidl", "dbgidl", &ndr_table_dbgidl, api_dbgidl_cmds, sizeof(api_dbgidl_cmds) / sizeof(struct api_struct));
}
