/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_dcom.h"

static bool api_UseProtSeq(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct UseProtSeq *r;

	call = &ndr_table_dcom_Unknown.calls[NDR_USEPROTSEQ];

	r = talloc(talloc_tos(), struct UseProtSeq);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(UseProtSeq, r);
	}

	_UseProtSeq(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(UseProtSeq, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetCustomProtseqInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetCustomProtseqInfo *r;

	call = &ndr_table_dcom_Unknown.calls[NDR_GETCUSTOMPROTSEQINFO];

	r = talloc(talloc_tos(), struct GetCustomProtseqInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetCustomProtseqInfo, r);
	}

	_GetCustomProtseqInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetCustomProtseqInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_UpdateResolverBindings(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct UpdateResolverBindings *r;

	call = &ndr_table_dcom_Unknown.calls[NDR_UPDATERESOLVERBINDINGS];

	r = talloc(talloc_tos(), struct UpdateResolverBindings);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(UpdateResolverBindings, r);
	}

	_UpdateResolverBindings(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(UpdateResolverBindings, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_dcom_Unknown_cmds[] = 
{
	{"USEPROTSEQ", NDR_USEPROTSEQ, api_UseProtSeq},
	{"GETCUSTOMPROTSEQINFO", NDR_GETCUSTOMPROTSEQINFO, api_GetCustomProtseqInfo},
	{"UPDATERESOLVERBINDINGS", NDR_UPDATERESOLVERBINDINGS, api_UpdateResolverBindings},
};

void dcom_Unknown_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_dcom_Unknown_cmds;
	*n_fns = sizeof(api_dcom_Unknown_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_dcom_Unknown_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "dcom_Unknown", "dcom_Unknown", &ndr_table_dcom_Unknown, api_dcom_Unknown_cmds, sizeof(api_dcom_Unknown_cmds) / sizeof(struct api_struct));
}
static bool api_QueryInterface(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct QueryInterface *r;

	call = &ndr_table_IUnknown.calls[NDR_QUERYINTERFACE];

	r = talloc(talloc_tos(), struct QueryInterface);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(QueryInterface, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data = talloc_zero(r, struct MInterfacePointer *);
	if (r->out.data == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _QueryInterface(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(QueryInterface, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_AddRef(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct AddRef *r;

	call = &ndr_table_IUnknown.calls[NDR_ADDREF];

	r = talloc(talloc_tos(), struct AddRef);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(AddRef, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _AddRef(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(AddRef, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_Release(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Release *r;

	call = &ndr_table_IUnknown.calls[NDR_RELEASE];

	r = talloc(talloc_tos(), struct Release);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Release, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Release(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Release, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IUnknown_cmds[] = 
{
	{"QUERYINTERFACE", NDR_QUERYINTERFACE, api_QueryInterface},
	{"ADDREF", NDR_ADDREF, api_AddRef},
	{"RELEASE", NDR_RELEASE, api_Release},
};

void IUnknown_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IUnknown_cmds;
	*n_fns = sizeof(api_IUnknown_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IUnknown_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IUnknown", "IUnknown", &ndr_table_IUnknown, api_IUnknown_cmds, sizeof(api_IUnknown_cmds) / sizeof(struct api_struct));
}
static bool api_CreateInstance(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct CreateInstance *r;

	call = &ndr_table_IClassFactory.calls[NDR_CREATEINSTANCE];

	r = talloc(talloc_tos(), struct CreateInstance);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(CreateInstance, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppv = talloc_zero(r, struct MInterfacePointer);
	if (r->out.ppv == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _CreateInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(CreateInstance, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_RemoteCreateInstance(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemoteCreateInstance *r;

	call = &ndr_table_IClassFactory.calls[NDR_REMOTECREATEINSTANCE];

	r = talloc(talloc_tos(), struct RemoteCreateInstance);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemoteCreateInstance, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemoteCreateInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemoteCreateInstance, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_LockServer(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct LockServer *r;

	call = &ndr_table_IClassFactory.calls[NDR_LOCKSERVER];

	r = talloc(talloc_tos(), struct LockServer);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(LockServer, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _LockServer(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(LockServer, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_RemoteLockServer(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemoteLockServer *r;

	call = &ndr_table_IClassFactory.calls[NDR_REMOTELOCKSERVER];

	r = talloc(talloc_tos(), struct RemoteLockServer);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemoteLockServer, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemoteLockServer(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemoteLockServer, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IClassFactory_cmds[] = 
{
	{"CREATEINSTANCE", NDR_CREATEINSTANCE, api_CreateInstance},
	{"REMOTECREATEINSTANCE", NDR_REMOTECREATEINSTANCE, api_RemoteCreateInstance},
	{"LOCKSERVER", NDR_LOCKSERVER, api_LockServer},
	{"REMOTELOCKSERVER", NDR_REMOTELOCKSERVER, api_RemoteLockServer},
};

void IClassFactory_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IClassFactory_cmds;
	*n_fns = sizeof(api_IClassFactory_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IClassFactory_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IClassFactory", "IClassFactory", &ndr_table_IClassFactory, api_IClassFactory_cmds, sizeof(api_IClassFactory_cmds) / sizeof(struct api_struct));
}
static bool api_RemQueryInterface(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemQueryInterface *r;

	call = &ndr_table_IRemUnknown.calls[NDR_REMQUERYINTERFACE];

	r = talloc(talloc_tos(), struct RemQueryInterface);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemQueryInterface, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ip = talloc_zero_array(r, struct MInterfacePointer, r->in.cIids);
	if (r->out.ip == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemQueryInterface(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemQueryInterface, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_RemAddRef(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemAddRef *r;

	call = &ndr_table_IRemUnknown.calls[NDR_REMADDREF];

	r = talloc(talloc_tos(), struct RemAddRef);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemAddRef, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pResults = talloc_zero_array(r, WERROR, r->in.cInterfaceRefs);
	if (r->out.pResults == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemAddRef(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemAddRef, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_RemRelease(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemRelease *r;

	call = &ndr_table_IRemUnknown.calls[NDR_REMRELEASE];

	r = talloc(talloc_tos(), struct RemRelease);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemRelease, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemRelease(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemRelease, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IRemUnknown_cmds[] = 
{
	{"REMQUERYINTERFACE", NDR_REMQUERYINTERFACE, api_RemQueryInterface},
	{"REMADDREF", NDR_REMADDREF, api_RemAddRef},
	{"REMRELEASE", NDR_REMRELEASE, api_RemRelease},
};

void IRemUnknown_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IRemUnknown_cmds;
	*n_fns = sizeof(api_IRemUnknown_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IRemUnknown_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IRemUnknown", "IRemUnknown", &ndr_table_IRemUnknown, api_IRemUnknown_cmds, sizeof(api_IRemUnknown_cmds) / sizeof(struct api_struct));
}
static bool api_GetClassObject(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetClassObject *r;

	call = &ndr_table_IClassActivator.calls[NDR_GETCLASSOBJECT];

	r = talloc(talloc_tos(), struct GetClassObject);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetClassObject, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.data = talloc_zero(r, struct MInterfacePointer);
	if (r->out.data == NULL) {
		talloc_free(r);
		return false;
	}

	_GetClassObject(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetClassObject, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IClassActivator_cmds[] = 
{
	{"GETCLASSOBJECT", NDR_GETCLASSOBJECT, api_GetClassObject},
};

void IClassActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IClassActivator_cmds;
	*n_fns = sizeof(api_IClassActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IClassActivator_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IClassActivator", "IClassActivator", &ndr_table_IClassActivator, api_IClassActivator_cmds, sizeof(api_IClassActivator_cmds) / sizeof(struct api_struct));
}
static bool api_ISCMLocalActivator_CreateInstance(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ISCMLocalActivator_CreateInstance *r;

	call = &ndr_table_ISCMLocalActivator.calls[NDR_ISCMLOCALACTIVATOR_CREATEINSTANCE];

	r = talloc(talloc_tos(), struct ISCMLocalActivator_CreateInstance);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ISCMLocalActivator_CreateInstance, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ISCMLocalActivator_CreateInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ISCMLocalActivator_CreateInstance, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ISCMLocalActivator_cmds[] = 
{
	{"ISCMLOCALACTIVATOR_CREATEINSTANCE", NDR_ISCMLOCALACTIVATOR_CREATEINSTANCE, api_ISCMLocalActivator_CreateInstance},
};

void ISCMLocalActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ISCMLocalActivator_cmds;
	*n_fns = sizeof(api_ISCMLocalActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ISCMLocalActivator_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ISCMLocalActivator", "ISCMLocalActivator", &ndr_table_ISCMLocalActivator, api_ISCMLocalActivator_cmds, sizeof(api_ISCMLocalActivator_cmds) / sizeof(struct api_struct));
}
static bool api_IMachineLocalActivator_foo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct IMachineLocalActivator_foo *r;

	call = &ndr_table_IMachineLocalActivator.calls[NDR_IMACHINELOCALACTIVATOR_FOO];

	r = talloc(talloc_tos(), struct IMachineLocalActivator_foo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(IMachineLocalActivator_foo, r);
	}

	r->out.result = _IMachineLocalActivator_foo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(IMachineLocalActivator_foo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IMachineLocalActivator_cmds[] = 
{
	{"IMACHINELOCALACTIVATOR_FOO", NDR_IMACHINELOCALACTIVATOR_FOO, api_IMachineLocalActivator_foo},
};

void IMachineLocalActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IMachineLocalActivator_cmds;
	*n_fns = sizeof(api_IMachineLocalActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IMachineLocalActivator_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IMachineLocalActivator", "IMachineLocalActivator", &ndr_table_IMachineLocalActivator, api_IMachineLocalActivator_cmds, sizeof(api_IMachineLocalActivator_cmds) / sizeof(struct api_struct));
}
static bool api_ILocalObjectExporter_Foo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ILocalObjectExporter_Foo *r;

	call = &ndr_table_ILocalObjectExporter.calls[NDR_ILOCALOBJECTEXPORTER_FOO];

	r = talloc(talloc_tos(), struct ILocalObjectExporter_Foo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ILocalObjectExporter_Foo, r);
	}

	r->out.result = _ILocalObjectExporter_Foo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ILocalObjectExporter_Foo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ILocalObjectExporter_cmds[] = 
{
	{"ILOCALOBJECTEXPORTER_FOO", NDR_ILOCALOBJECTEXPORTER_FOO, api_ILocalObjectExporter_Foo},
};

void ILocalObjectExporter_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ILocalObjectExporter_cmds;
	*n_fns = sizeof(api_ILocalObjectExporter_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ILocalObjectExporter_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ILocalObjectExporter", "ILocalObjectExporter", &ndr_table_ILocalObjectExporter, api_ILocalObjectExporter_cmds, sizeof(api_ILocalObjectExporter_cmds) / sizeof(struct api_struct));
}
static bool api_ISystemActivatorRemoteCreateInstance(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct ISystemActivatorRemoteCreateInstance *r;

	call = &ndr_table_ISystemActivator.calls[NDR_ISYSTEMACTIVATORREMOTECREATEINSTANCE];

	r = talloc(talloc_tos(), struct ISystemActivatorRemoteCreateInstance);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(ISystemActivatorRemoteCreateInstance, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.unknown3 = talloc_zero(r, uint32_t);
	if (r->out.unknown3 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.iface2 = talloc_zero(r, struct MInterfacePointer);
	if (r->out.iface2 == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _ISystemActivatorRemoteCreateInstance(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(ISystemActivatorRemoteCreateInstance, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ISystemActivator_cmds[] = 
{
	{"ISYSTEMACTIVATORREMOTECREATEINSTANCE", NDR_ISYSTEMACTIVATORREMOTECREATEINSTANCE, api_ISystemActivatorRemoteCreateInstance},
};

void ISystemActivator_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ISystemActivator_cmds;
	*n_fns = sizeof(api_ISystemActivator_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ISystemActivator_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ISystemActivator", "ISystemActivator", &ndr_table_ISystemActivator, api_ISystemActivator_cmds, sizeof(api_ISystemActivator_cmds) / sizeof(struct api_struct));
}
static bool api_RemQueryInterface2(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct RemQueryInterface2 *r;

	call = &ndr_table_IRemUnknown2.calls[NDR_REMQUERYINTERFACE2];

	r = talloc(talloc_tos(), struct RemQueryInterface2);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(RemQueryInterface2, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.phr = talloc_zero_array(r, WERROR, r->in.cIids);
	if (r->out.phr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppMIF = talloc_zero_array(r, struct MInterfacePointer, r->in.cIids);
	if (r->out.ppMIF == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _RemQueryInterface2(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(RemQueryInterface2, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IRemUnknown2_cmds[] = 
{
	{"REMQUERYINTERFACE2", NDR_REMQUERYINTERFACE2, api_RemQueryInterface2},
};

void IRemUnknown2_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IRemUnknown2_cmds;
	*n_fns = sizeof(api_IRemUnknown2_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IRemUnknown2_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IRemUnknown2", "IRemUnknown2", &ndr_table_IRemUnknown2, api_IRemUnknown2_cmds, sizeof(api_IRemUnknown2_cmds) / sizeof(struct api_struct));
}
static bool api_GetTypeInfoCount(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetTypeInfoCount *r;

	call = &ndr_table_IDispatch.calls[NDR_GETTYPEINFOCOUNT];

	r = talloc(talloc_tos(), struct GetTypeInfoCount);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetTypeInfoCount, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pctinfo = talloc_zero(r, uint16_t);
	if (r->out.pctinfo == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetTypeInfoCount(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetTypeInfoCount, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetTypeInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetTypeInfo *r;

	call = &ndr_table_IDispatch.calls[NDR_GETTYPEINFO];

	r = talloc(talloc_tos(), struct GetTypeInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetTypeInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.ppTInfo = talloc_zero(r, struct REF_ITypeInfo);
	if (r->out.ppTInfo == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetTypeInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetTypeInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_GetIDsOfNames(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct GetIDsOfNames *r;

	call = &ndr_table_IDispatch.calls[NDR_GETIDSOFNAMES];

	r = talloc(talloc_tos(), struct GetIDsOfNames);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(GetIDsOfNames, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.rgDispId = talloc_zero_array(r, uint32_t, r->in.cNames);
	if (r->out.rgDispId == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _GetIDsOfNames(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(GetIDsOfNames, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_Invoke(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Invoke *r;

	call = &ndr_table_IDispatch.calls[NDR_INVOKE];

	r = talloc(talloc_tos(), struct Invoke);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Invoke, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pDispParams = r->in.pDispParams;
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pVarResult = talloc_zero(r, struct VARIANT);
	if (r->out.pVarResult == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pExcepInfo = talloc_zero(r, struct EXCEPINFO);
	if (r->out.pExcepInfo == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.puArgErr = talloc_zero(r, uint16_t);
	if (r->out.puArgErr == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Invoke(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Invoke, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IDispatch_cmds[] = 
{
	{"GETTYPEINFOCOUNT", NDR_GETTYPEINFOCOUNT, api_GetTypeInfoCount},
	{"GETTYPEINFO", NDR_GETTYPEINFO, api_GetTypeInfo},
	{"GETIDSOFNAMES", NDR_GETIDSOFNAMES, api_GetIDsOfNames},
	{"INVOKE", NDR_INVOKE, api_Invoke},
};

void IDispatch_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IDispatch_cmds;
	*n_fns = sizeof(api_IDispatch_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IDispatch_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IDispatch", "IDispatch", &ndr_table_IDispatch, api_IDispatch_cmds, sizeof(api_IDispatch_cmds) / sizeof(struct api_struct));
}
static bool api_MarshalInterface(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct MarshalInterface *r;

	call = &ndr_table_IMarshal.calls[NDR_MARSHALINTERFACE];

	r = talloc(talloc_tos(), struct MarshalInterface);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(MarshalInterface, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _MarshalInterface(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(MarshalInterface, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_UnMarshalInterface(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct UnMarshalInterface *r;

	call = &ndr_table_IMarshal.calls[NDR_UNMARSHALINTERFACE];

	r = talloc(talloc_tos(), struct UnMarshalInterface);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(UnMarshalInterface, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _UnMarshalInterface(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(UnMarshalInterface, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IMarshal_cmds[] = 
{
	{"MARSHALINTERFACE", NDR_MARSHALINTERFACE, api_MarshalInterface},
	{"UNMARSHALINTERFACE", NDR_UNMARSHALINTERFACE, api_UnMarshalInterface},
};

void IMarshal_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IMarshal_cmds;
	*n_fns = sizeof(api_IMarshal_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IMarshal_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IMarshal", "IMarshal", &ndr_table_IMarshal, api_IMarshal_cmds, sizeof(api_IMarshal_cmds) / sizeof(struct api_struct));
}
static bool api_MakeCoffee(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct MakeCoffee *r;

	call = &ndr_table_ICoffeeMachine.calls[NDR_MAKECOFFEE];

	r = talloc(talloc_tos(), struct MakeCoffee);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(MakeCoffee, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _MakeCoffee(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(MakeCoffee, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_ICoffeeMachine_cmds[] = 
{
	{"MAKECOFFEE", NDR_MAKECOFFEE, api_MakeCoffee},
};

void ICoffeeMachine_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_ICoffeeMachine_cmds;
	*n_fns = sizeof(api_ICoffeeMachine_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_ICoffeeMachine_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "ICoffeeMachine", "ICoffeeMachine", &ndr_table_ICoffeeMachine, api_ICoffeeMachine_cmds, sizeof(api_ICoffeeMachine_cmds) / sizeof(struct api_struct));
}
static bool api_Read(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Read *r;

	call = &ndr_table_IStream.calls[NDR_READ];

	r = talloc(talloc_tos(), struct Read);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Read, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.pv = talloc_zero_array(r, uint8_t, r->in.num_requested);
	if (r->out.pv == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_read = talloc_zero(r, uint32_t);
	if (r->out.num_read == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Read(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Read, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_Write(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct Write *r;

	call = &ndr_table_IStream.calls[NDR_WRITE];

	r = talloc(talloc_tos(), struct Write);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(Write, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ORPCthat = talloc_zero(r, struct ORPCTHAT);
	if (r->out.ORPCthat == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.num_written = talloc_zero(r, uint32_t);
	if (r->out.num_written == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _Write(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(Write, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_IStream_cmds[] = 
{
	{"READ", NDR_READ, api_Read},
	{"WRITE", NDR_WRITE, api_Write},
};

void IStream_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_IStream_cmds;
	*n_fns = sizeof(api_IStream_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_IStream_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "IStream", "IStream", &ndr_table_IStream, api_IStream_cmds, sizeof(api_IStream_cmds) / sizeof(struct api_struct));
}
