/* parser auto-generated by pidl */

#include "includes.h"
#include "../librpc/gen_ndr/ndr_dcerpc.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_dcerpc_ctx_list(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_ctx_list *r)
{
	uint32_t cntr_transfer_syntaxes_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_transfer_syntaxes));
		NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->abstract_syntax));
		for (cntr_transfer_syntaxes_0 = 0; cntr_transfer_syntaxes_0 < r->num_transfer_syntaxes; cntr_transfer_syntaxes_0++) {
			NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->transfer_syntaxes[cntr_transfer_syntaxes_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_ctx_list(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_ctx_list *r)
{
	uint32_t cntr_transfer_syntaxes_0;
	TALLOC_CTX *_mem_save_transfer_syntaxes_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_transfer_syntaxes));
		NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->abstract_syntax));
		NDR_PULL_ALLOC_N(ndr, r->transfer_syntaxes, r->num_transfer_syntaxes);
		_mem_save_transfer_syntaxes_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->transfer_syntaxes, 0);
		for (cntr_transfer_syntaxes_0 = 0; cntr_transfer_syntaxes_0 < r->num_transfer_syntaxes; cntr_transfer_syntaxes_0++) {
			NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->transfer_syntaxes[cntr_transfer_syntaxes_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transfer_syntaxes_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_ctx_list(struct ndr_print *ndr, const char *name, const struct dcerpc_ctx_list *r)
{
	uint32_t cntr_transfer_syntaxes_0;
	ndr_print_struct(ndr, name, "dcerpc_ctx_list");
	ndr->depth++;
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint8(ndr, "num_transfer_syntaxes", r->num_transfer_syntaxes);
	ndr_print_ndr_syntax_id(ndr, "abstract_syntax", &r->abstract_syntax);
	ndr->print(ndr, "%s: ARRAY(%d)", "transfer_syntaxes", (int)r->num_transfer_syntaxes);
	ndr->depth++;
	for (cntr_transfer_syntaxes_0=0;cntr_transfer_syntaxes_0<r->num_transfer_syntaxes;cntr_transfer_syntaxes_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_transfer_syntaxes_0) != -1) {
			ndr_print_ndr_syntax_id(ndr, "transfer_syntaxes", &r->transfer_syntaxes[cntr_transfer_syntaxes_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_bind(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_bind *r)
{
	uint32_t cntr_ctx_list_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_xmit_frag));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_recv_frag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->assoc_group_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_contexts));
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < r->num_contexts; cntr_ctx_list_0++) {
			NDR_CHECK(ndr_push_dcerpc_ctx_list(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_bind *r)
{
	uint32_t cntr_ctx_list_0;
	TALLOC_CTX *_mem_save_ctx_list_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_xmit_frag));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_recv_frag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->assoc_group_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_contexts));
		NDR_PULL_ALLOC_N(ndr, r->ctx_list, r->num_contexts);
		_mem_save_ctx_list_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ctx_list, 0);
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < r->num_contexts; cntr_ctx_list_0++) {
			NDR_CHECK(ndr_pull_dcerpc_ctx_list(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctx_list_0, 0);
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind(struct ndr_print *ndr, const char *name, const struct dcerpc_bind *r)
{
	uint32_t cntr_ctx_list_0;
	ndr_print_struct(ndr, name, "dcerpc_bind");
	ndr->depth++;
	ndr_print_uint16(ndr, "max_xmit_frag", r->max_xmit_frag);
	ndr_print_uint16(ndr, "max_recv_frag", r->max_recv_frag);
	ndr_print_uint32(ndr, "assoc_group_id", r->assoc_group_id);
	ndr_print_uint8(ndr, "num_contexts", r->num_contexts);
	ndr->print(ndr, "%s: ARRAY(%d)", "ctx_list", (int)r->num_contexts);
	ndr->depth++;
	for (cntr_ctx_list_0=0;cntr_ctx_list_0<r->num_contexts;cntr_ctx_list_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_ctx_list_0) != -1) {
			ndr_print_dcerpc_ctx_list(ndr, "ctx_list", &r->ctx_list[cntr_ctx_list_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_empty(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_empty *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_empty(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_empty *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_empty(struct ndr_print *ndr, const char *name, const struct dcerpc_empty *r)
{
	ndr_print_struct(ndr, name, "dcerpc_empty");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_object(struct ndr_push *ndr, int ndr_flags, const union dcerpc_object *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			default: {
				NDR_CHECK(ndr_push_dcerpc_empty(ndr, NDR_SCALARS, &r->empty));
			break; }

			case LIBNDR_FLAG_OBJECT_PRESENT: {
				NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->object));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			default:
			break;

			case LIBNDR_FLAG_OBJECT_PRESENT:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_object(struct ndr_pull *ndr, int ndr_flags, union dcerpc_object *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			default: {
				NDR_CHECK(ndr_pull_dcerpc_empty(ndr, NDR_SCALARS, &r->empty));
			break; }

			case LIBNDR_FLAG_OBJECT_PRESENT: {
				NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->object));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			default:
			break;

			case LIBNDR_FLAG_OBJECT_PRESENT:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_object(struct ndr_print *ndr, const char *name, const union dcerpc_object *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_object");
	switch (level) {
		default:
			ndr_print_dcerpc_empty(ndr, "empty", &r->empty);
		break;

		case LIBNDR_FLAG_OBJECT_PRESENT:
			ndr_print_GUID(ndr, "object", &r->object);
		break;

	}
}

static enum ndr_err_code ndr_push_dcerpc_request(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alloc_hint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->opnum));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->object, ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT));
		NDR_CHECK(ndr_push_dcerpc_object(ndr, NDR_SCALARS, &r->object));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_request(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_request *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alloc_hint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->opnum));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->object, ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT));
		NDR_CHECK(ndr_pull_dcerpc_object(ndr, NDR_SCALARS, &r->object));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_request(struct ndr_print *ndr, const char *name, const struct dcerpc_request *r)
{
	ndr_print_struct(ndr, name, "dcerpc_request");
	ndr->depth++;
	ndr_print_uint32(ndr, "alloc_hint", r->alloc_hint);
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint16(ndr, "opnum", r->opnum);
	ndr_print_set_switch_value(ndr, &r->object, ndr->flags & LIBNDR_FLAG_OBJECT_PRESENT);
	ndr_print_dcerpc_object(ndr, "object", &r->object);
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr_print_DATA_BLOB(ndr, "stub_and_verifier", r->stub_and_verifier);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_ack_ctx(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_ack_ctx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->result));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reason));
		NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, &r->syntax));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_ack_ctx(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_ack_ctx *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->result));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reason));
		NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, &r->syntax));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_ack_ctx(struct ndr_print *ndr, const char *name, const struct dcerpc_ack_ctx *r)
{
	ndr_print_struct(ndr, name, "dcerpc_ack_ctx");
	ndr->depth++;
	ndr_print_uint16(ndr, "result", r->result);
	ndr_print_uint16(ndr, "reason", r->reason);
	ndr_print_ndr_syntax_id(ndr, "syntax", &r->syntax);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_bind_ack(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_bind_ack *r)
{
	uint32_t cntr_ctx_list_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_xmit_frag));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_recv_frag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->assoc_group_id));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, strlen(r->secondary_address) + 1));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->secondary_address, strlen(r->secondary_address) + 1, sizeof(uint8_t), CH_DOS));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad1));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_results));
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < r->num_results; cntr_ctx_list_0++) {
			NDR_CHECK(ndr_push_dcerpc_ack_ctx(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_ack(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_bind_ack *r)
{
	uint32_t cntr_ctx_list_0;
	TALLOC_CTX *_mem_save_ctx_list_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_xmit_frag));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_recv_frag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->assoc_group_id));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->secondary_address_size));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->secondary_address, r->secondary_address_size, sizeof(uint8_t), CH_DOS));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad1));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_results));
		NDR_PULL_ALLOC_N(ndr, r->ctx_list, r->num_results);
		_mem_save_ctx_list_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ctx_list, 0);
		for (cntr_ctx_list_0 = 0; cntr_ctx_list_0 < r->num_results; cntr_ctx_list_0++) {
			NDR_CHECK(ndr_pull_dcerpc_ack_ctx(ndr, NDR_SCALARS, &r->ctx_list[cntr_ctx_list_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctx_list_0, 0);
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_ack(struct ndr_print *ndr, const char *name, const struct dcerpc_bind_ack *r)
{
	uint32_t cntr_ctx_list_0;
	ndr_print_struct(ndr, name, "dcerpc_bind_ack");
	ndr->depth++;
	ndr_print_uint16(ndr, "max_xmit_frag", r->max_xmit_frag);
	ndr_print_uint16(ndr, "max_recv_frag", r->max_recv_frag);
	ndr_print_uint32(ndr, "assoc_group_id", r->assoc_group_id);
	ndr_print_uint16(ndr, "secondary_address_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->secondary_address) + 1:r->secondary_address_size);
	ndr_print_string(ndr, "secondary_address", r->secondary_address);
	ndr_print_DATA_BLOB(ndr, "_pad1", r->_pad1);
	ndr_print_uint8(ndr, "num_results", r->num_results);
	ndr->print(ndr, "%s: ARRAY(%d)", "ctx_list", (int)r->num_results);
	ndr->depth++;
	for (cntr_ctx_list_0=0;cntr_ctx_list_0<r->num_results;cntr_ctx_list_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_ctx_list_0) != -1) {
			ndr_print_dcerpc_ack_ctx(ndr, "ctx_list", &r->ctx_list[cntr_ctx_list_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_bind_nak_versions(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_bind_nak_versions *r)
{
	uint32_t cntr_versions_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_versions));
		for (cntr_versions_0 = 0; cntr_versions_0 < r->num_versions; cntr_versions_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->versions[cntr_versions_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_nak_versions(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_bind_nak_versions *r)
{
	uint32_t cntr_versions_0;
	TALLOC_CTX *_mem_save_versions_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_versions));
		NDR_PULL_ALLOC_N(ndr, r->versions, r->num_versions);
		_mem_save_versions_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->versions, 0);
		for (cntr_versions_0 = 0; cntr_versions_0 < r->num_versions; cntr_versions_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->versions[cntr_versions_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_versions_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_nak_versions(struct ndr_print *ndr, const char *name, const struct dcerpc_bind_nak_versions *r)
{
	uint32_t cntr_versions_0;
	ndr_print_struct(ndr, name, "dcerpc_bind_nak_versions");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_versions", r->num_versions);
	ndr->print(ndr, "%s: ARRAY(%d)", "versions", (int)r->num_versions);
	ndr->depth++;
	for (cntr_versions_0=0;cntr_versions_0<r->num_versions;cntr_versions_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_versions_0) != -1) {
			ndr_print_uint32(ndr, "versions", r->versions[cntr_versions_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_bind_nak_versions_ctr(struct ndr_push *ndr, int ndr_flags, const union dcerpc_bind_nak_versions_ctr *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED: {
				NDR_CHECK(ndr_push_dcerpc_bind_nak_versions(ndr, NDR_SCALARS, &r->v));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_nak_versions_ctr(struct ndr_pull *ndr, int ndr_flags, union dcerpc_bind_nak_versions_ctr *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED: {
				NDR_CHECK(ndr_pull_dcerpc_bind_nak_versions(ndr, NDR_SCALARS, &r->v));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_nak_versions_ctr(struct ndr_print *ndr, const char *name, const union dcerpc_bind_nak_versions_ctr *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_bind_nak_versions_ctr");
	switch (level) {
		case DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED:
			ndr_print_dcerpc_bind_nak_versions(ndr, "v", &r->v);
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_dcerpc_bind_nak(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_bind_nak *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reject_reason));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->versions, r->reject_reason));
		NDR_CHECK(ndr_push_dcerpc_bind_nak_versions_ctr(ndr, NDR_SCALARS, &r->versions));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dcerpc_bind_nak_versions_ctr(ndr, NDR_BUFFERS, &r->versions));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_bind_nak(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_bind_nak *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reject_reason));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->versions, r->reject_reason));
		NDR_CHECK(ndr_pull_dcerpc_bind_nak_versions_ctr(ndr, NDR_SCALARS, &r->versions));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dcerpc_bind_nak_versions_ctr(ndr, NDR_BUFFERS, &r->versions));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_bind_nak(struct ndr_print *ndr, const char *name, const struct dcerpc_bind_nak *r)
{
	ndr_print_struct(ndr, name, "dcerpc_bind_nak");
	ndr->depth++;
	ndr_print_uint16(ndr, "reject_reason", r->reject_reason);
	ndr_print_set_switch_value(ndr, &r->versions, r->reject_reason);
	ndr_print_dcerpc_bind_nak_versions_ctr(ndr, "versions", &r->versions);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_response(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_response *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alloc_hint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->cancel_count));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_response(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_response *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alloc_hint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->cancel_count));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->stub_and_verifier));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_response(struct ndr_print *ndr, const char *name, const struct dcerpc_response *r)
{
	ndr_print_struct(ndr, name, "dcerpc_response");
	ndr->depth++;
	ndr_print_uint32(ndr, "alloc_hint", r->alloc_hint);
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint8(ndr, "cancel_count", r->cancel_count);
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr_print_DATA_BLOB(ndr, "stub_and_verifier", r->stub_and_verifier);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_fault(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_fault *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->alloc_hint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->context_id));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->cancel_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->status));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_fault(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_fault *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->alloc_hint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->context_id));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->cancel_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->status));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_fault(struct ndr_print *ndr, const char *name, const struct dcerpc_fault *r)
{
	ndr_print_struct(ndr, name, "dcerpc_fault");
	ndr->depth++;
	ndr_print_uint32(ndr, "alloc_hint", r->alloc_hint);
	ndr_print_uint16(ndr, "context_id", r->context_id);
	ndr_print_uint8(ndr, "cancel_count", r->cancel_count);
	ndr_print_uint32(ndr, "status", r->status);
	ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_AuthType(struct ndr_push *ndr, int ndr_flags, enum dcerpc_AuthType r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_AuthType(struct ndr_pull *ndr, int ndr_flags, enum dcerpc_AuthType *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_AuthType(struct ndr_print *ndr, const char *name, enum dcerpc_AuthType r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_AUTH_TYPE_NONE: val = "DCERPC_AUTH_TYPE_NONE"; break;
		case DCERPC_AUTH_TYPE_KRB5_1: val = "DCERPC_AUTH_TYPE_KRB5_1"; break;
		case DCERPC_AUTH_TYPE_SPNEGO: val = "DCERPC_AUTH_TYPE_SPNEGO"; break;
		case DCERPC_AUTH_TYPE_NTLMSSP: val = "DCERPC_AUTH_TYPE_NTLMSSP"; break;
		case DCERPC_AUTH_TYPE_KRB5: val = "DCERPC_AUTH_TYPE_KRB5"; break;
		case DCERPC_AUTH_TYPE_DPA: val = "DCERPC_AUTH_TYPE_DPA"; break;
		case DCERPC_AUTH_TYPE_MSN: val = "DCERPC_AUTH_TYPE_MSN"; break;
		case DCERPC_AUTH_TYPE_DIGEST: val = "DCERPC_AUTH_TYPE_DIGEST"; break;
		case DCERPC_AUTH_TYPE_SCHANNEL: val = "DCERPC_AUTH_TYPE_SCHANNEL"; break;
		case DCERPC_AUTH_TYPE_MSMQ: val = "DCERPC_AUTH_TYPE_MSMQ"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dcerpc_AuthLevel(struct ndr_push *ndr, int ndr_flags, enum dcerpc_AuthLevel r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_AuthLevel(struct ndr_pull *ndr, int ndr_flags, enum dcerpc_AuthLevel *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_AuthLevel(struct ndr_print *ndr, const char *name, enum dcerpc_AuthLevel r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_AUTH_LEVEL_NONE: val = "DCERPC_AUTH_LEVEL_NONE"; break;
		case DCERPC_AUTH_LEVEL_CONNECT: val = "DCERPC_AUTH_LEVEL_CONNECT"; break;
		case DCERPC_AUTH_LEVEL_CALL: val = "DCERPC_AUTH_LEVEL_CALL"; break;
		case DCERPC_AUTH_LEVEL_PACKET: val = "DCERPC_AUTH_LEVEL_PACKET"; break;
		case DCERPC_AUTH_LEVEL_INTEGRITY: val = "DCERPC_AUTH_LEVEL_INTEGRITY"; break;
		case DCERPC_AUTH_LEVEL_PRIVACY: val = "DCERPC_AUTH_LEVEL_PRIVACY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_auth(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_auth *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dcerpc_AuthType(ndr, NDR_SCALARS, r->auth_type));
		NDR_CHECK(ndr_push_dcerpc_AuthLevel(ndr, NDR_SCALARS, r->auth_level));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->auth_pad_length));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->auth_reserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->auth_context_id));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->credentials));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_auth(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_auth *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dcerpc_AuthType(ndr, NDR_SCALARS, &r->auth_type));
		NDR_CHECK(ndr_pull_dcerpc_AuthLevel(ndr, NDR_SCALARS, &r->auth_level));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->auth_pad_length));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->auth_reserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->auth_context_id));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->credentials));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_auth(struct ndr_print *ndr, const char *name, const struct dcerpc_auth *r)
{
	ndr_print_struct(ndr, name, "dcerpc_auth");
	ndr->depth++;
	ndr_print_dcerpc_AuthType(ndr, "auth_type", r->auth_type);
	ndr_print_dcerpc_AuthLevel(ndr, "auth_level", r->auth_level);
	ndr_print_uint8(ndr, "auth_pad_length", r->auth_pad_length);
	ndr_print_uint8(ndr, "auth_reserved", r->auth_reserved);
	ndr_print_uint32(ndr, "auth_context_id", r->auth_context_id);
	ndr_print_DATA_BLOB(ndr, "credentials", r->credentials);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_auth3(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_auth3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->_pad));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_auth3(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_auth3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_pad));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_auth3(struct ndr_print *ndr, const char *name, const struct dcerpc_auth3 *r)
{
	ndr_print_struct(ndr, name, "dcerpc_auth3");
	ndr->depth++;
	ndr_print_uint32(ndr, "_pad", r->_pad);
	ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_orphaned(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_orphaned *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->_pad));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_orphaned(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_orphaned *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_pad));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_orphaned(struct ndr_print *ndr, const char *name, const struct dcerpc_orphaned *r)
{
	ndr_print_struct(ndr, name, "dcerpc_orphaned");
	ndr->depth++;
	ndr_print_uint32(ndr, "_pad", r->_pad);
	ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_co_cancel(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_co_cancel *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->_pad));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_co_cancel(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_co_cancel *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_pad));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->auth_info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_co_cancel(struct ndr_print *ndr, const char *name, const struct dcerpc_co_cancel *r)
{
	ndr_print_struct(ndr, name, "dcerpc_co_cancel");
	ndr->depth++;
	ndr_print_uint32(ndr, "_pad", r->_pad);
	ndr_print_DATA_BLOB(ndr, "auth_info", r->auth_info);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_cl_cancel(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_cl_cancel *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->id));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_cl_cancel(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_cl_cancel *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->id));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_cl_cancel(struct ndr_print *ndr, const char *name, const struct dcerpc_cl_cancel *r)
{
	ndr_print_struct(ndr, name, "dcerpc_cl_cancel");
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "id", r->id);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_cancel_ack(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_cancel_ack *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->server_is_accepting));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_cancel_ack(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_cancel_ack *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->server_is_accepting));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_cancel_ack(struct ndr_print *ndr, const char *name, const struct dcerpc_cancel_ack *r)
{
	ndr_print_struct(ndr, name, "dcerpc_cancel_ack");
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "id", r->id);
	ndr_print_uint32(ndr, "server_is_accepting", r->server_is_accepting);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_fack(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_fack *r)
{
	uint32_t cntr_selack_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->_pad1));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->window_size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_tdsu));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_frag_size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->serial_no));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->selack_size));
		for (cntr_selack_0 = 0; cntr_selack_0 < r->selack_size; cntr_selack_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->selack[cntr_selack_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_fack(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_fack *r)
{
	uint32_t cntr_selack_0;
	TALLOC_CTX *_mem_save_selack_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->_pad1));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->window_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_tdsu));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_frag_size));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->serial_no));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->selack_size));
		NDR_PULL_ALLOC_N(ndr, r->selack, r->selack_size);
		_mem_save_selack_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->selack, 0);
		for (cntr_selack_0 = 0; cntr_selack_0 < r->selack_size; cntr_selack_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->selack[cntr_selack_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_selack_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_fack(struct ndr_print *ndr, const char *name, const struct dcerpc_fack *r)
{
	uint32_t cntr_selack_0;
	ndr_print_struct(ndr, name, "dcerpc_fack");
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint8(ndr, "_pad1", r->_pad1);
	ndr_print_uint16(ndr, "window_size", r->window_size);
	ndr_print_uint32(ndr, "max_tdsu", r->max_tdsu);
	ndr_print_uint32(ndr, "max_frag_size", r->max_frag_size);
	ndr_print_uint16(ndr, "serial_no", r->serial_no);
	ndr_print_uint16(ndr, "selack_size", r->selack_size);
	ndr->print(ndr, "%s: ARRAY(%d)", "selack", (int)r->selack_size);
	ndr->depth++;
	for (cntr_selack_0=0;cntr_selack_0<r->selack_size;cntr_selack_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_selack_0) != -1) {
			ndr_print_uint32(ndr, "selack", r->selack[cntr_selack_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_ack(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_ack *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_ack(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_ack *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_ack(struct ndr_print *ndr, const char *name, const struct dcerpc_ack *r)
{
	ndr_print_struct(ndr, name, "dcerpc_ack");
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_ping(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_ping *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_ping(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_ping *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_ping(struct ndr_print *ndr, const char *name, const struct dcerpc_ping *r)
{
	ndr_print_struct(ndr, name, "dcerpc_ping");
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_shutdown(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_shutdown *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_shutdown(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_shutdown *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_shutdown(struct ndr_print *ndr, const char *name, const struct dcerpc_shutdown *r)
{
	ndr_print_struct(ndr, name, "dcerpc_shutdown");
	ndr->depth++;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dcerpc_working(struct ndr_push *ndr, int ndr_flags, const struct dcerpc_working *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dcerpc_working(struct ndr_pull *ndr, int ndr_flags, struct dcerpc_working *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_working(struct ndr_print *ndr, const char *name, const struct dcerpc_working *r)
{
	ndr_print_struct(ndr, name, "dcerpc_working");
	ndr->depth++;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dcerpc_pkt_type(struct ndr_push *ndr, int ndr_flags, enum dcerpc_pkt_type r)
{
	NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_pkt_type(struct ndr_pull *ndr, int ndr_flags, enum dcerpc_pkt_type *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_pkt_type(struct ndr_print *ndr, const char *name, enum dcerpc_pkt_type r)
{
	const char *val = NULL;

	switch (r) {
		case DCERPC_PKT_REQUEST: val = "DCERPC_PKT_REQUEST"; break;
		case DCERPC_PKT_PING: val = "DCERPC_PKT_PING"; break;
		case DCERPC_PKT_RESPONSE: val = "DCERPC_PKT_RESPONSE"; break;
		case DCERPC_PKT_FAULT: val = "DCERPC_PKT_FAULT"; break;
		case DCERPC_PKT_WORKING: val = "DCERPC_PKT_WORKING"; break;
		case DCERPC_PKT_NOCALL: val = "DCERPC_PKT_NOCALL"; break;
		case DCERPC_PKT_REJECT: val = "DCERPC_PKT_REJECT"; break;
		case DCERPC_PKT_ACK: val = "DCERPC_PKT_ACK"; break;
		case DCERPC_PKT_CL_CANCEL: val = "DCERPC_PKT_CL_CANCEL"; break;
		case DCERPC_PKT_FACK: val = "DCERPC_PKT_FACK"; break;
		case DCERPC_PKT_CANCEL_ACK: val = "DCERPC_PKT_CANCEL_ACK"; break;
		case DCERPC_PKT_BIND: val = "DCERPC_PKT_BIND"; break;
		case DCERPC_PKT_BIND_ACK: val = "DCERPC_PKT_BIND_ACK"; break;
		case DCERPC_PKT_BIND_NAK: val = "DCERPC_PKT_BIND_NAK"; break;
		case DCERPC_PKT_ALTER: val = "DCERPC_PKT_ALTER"; break;
		case DCERPC_PKT_ALTER_RESP: val = "DCERPC_PKT_ALTER_RESP"; break;
		case DCERPC_PKT_AUTH3: val = "DCERPC_PKT_AUTH3"; break;
		case DCERPC_PKT_SHUTDOWN: val = "DCERPC_PKT_SHUTDOWN"; break;
		case DCERPC_PKT_CO_CANCEL: val = "DCERPC_PKT_CO_CANCEL"; break;
		case DCERPC_PKT_ORPHANED: val = "DCERPC_PKT_ORPHANED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dcerpc_payload(struct ndr_push *ndr, int ndr_flags, const union dcerpc_payload *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DCERPC_PKT_REQUEST: {
				NDR_CHECK(ndr_push_dcerpc_request(ndr, NDR_SCALARS, &r->request));
			break; }

			case DCERPC_PKT_PING: {
				NDR_CHECK(ndr_push_dcerpc_ping(ndr, NDR_SCALARS, &r->ping));
			break; }

			case DCERPC_PKT_RESPONSE: {
				NDR_CHECK(ndr_push_dcerpc_response(ndr, NDR_SCALARS, &r->response));
			break; }

			case DCERPC_PKT_FAULT: {
				NDR_CHECK(ndr_push_dcerpc_fault(ndr, NDR_SCALARS, &r->fault));
			break; }

			case DCERPC_PKT_WORKING: {
				NDR_CHECK(ndr_push_dcerpc_working(ndr, NDR_SCALARS, &r->working));
			break; }

			case DCERPC_PKT_NOCALL: {
				NDR_CHECK(ndr_push_dcerpc_fack(ndr, NDR_SCALARS, &r->nocall));
			break; }

			case DCERPC_PKT_REJECT: {
				NDR_CHECK(ndr_push_dcerpc_fault(ndr, NDR_SCALARS, &r->reject));
			break; }

			case DCERPC_PKT_ACK: {
				NDR_CHECK(ndr_push_dcerpc_ack(ndr, NDR_SCALARS, &r->ack));
			break; }

			case DCERPC_PKT_CL_CANCEL: {
				NDR_CHECK(ndr_push_dcerpc_cl_cancel(ndr, NDR_SCALARS, &r->cl_cancel));
			break; }

			case DCERPC_PKT_FACK: {
				NDR_CHECK(ndr_push_dcerpc_fack(ndr, NDR_SCALARS, &r->fack));
			break; }

			case DCERPC_PKT_CANCEL_ACK: {
				NDR_CHECK(ndr_push_dcerpc_cancel_ack(ndr, NDR_SCALARS, &r->cancel_ack));
			break; }

			case DCERPC_PKT_BIND: {
				NDR_CHECK(ndr_push_dcerpc_bind(ndr, NDR_SCALARS, &r->bind));
			break; }

			case DCERPC_PKT_BIND_ACK: {
				NDR_CHECK(ndr_push_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->bind_ack));
			break; }

			case DCERPC_PKT_BIND_NAK: {
				NDR_CHECK(ndr_push_dcerpc_bind_nak(ndr, NDR_SCALARS, &r->bind_nak));
			break; }

			case DCERPC_PKT_ALTER: {
				NDR_CHECK(ndr_push_dcerpc_bind(ndr, NDR_SCALARS, &r->alter));
			break; }

			case DCERPC_PKT_ALTER_RESP: {
				NDR_CHECK(ndr_push_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->alter_resp));
			break; }

			case DCERPC_PKT_SHUTDOWN: {
				NDR_CHECK(ndr_push_dcerpc_shutdown(ndr, NDR_SCALARS, &r->shutdown));
			break; }

			case DCERPC_PKT_CO_CANCEL: {
				NDR_CHECK(ndr_push_dcerpc_co_cancel(ndr, NDR_SCALARS, &r->co_cancel));
			break; }

			case DCERPC_PKT_ORPHANED: {
				NDR_CHECK(ndr_push_dcerpc_orphaned(ndr, NDR_SCALARS, &r->orphaned));
			break; }

			case DCERPC_PKT_AUTH3: {
				NDR_CHECK(ndr_push_dcerpc_auth3(ndr, NDR_SCALARS, &r->auth3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case DCERPC_PKT_REQUEST:
			break;

			case DCERPC_PKT_PING:
			break;

			case DCERPC_PKT_RESPONSE:
			break;

			case DCERPC_PKT_FAULT:
			break;

			case DCERPC_PKT_WORKING:
			break;

			case DCERPC_PKT_NOCALL:
			break;

			case DCERPC_PKT_REJECT:
			break;

			case DCERPC_PKT_ACK:
			break;

			case DCERPC_PKT_CL_CANCEL:
			break;

			case DCERPC_PKT_FACK:
			break;

			case DCERPC_PKT_CANCEL_ACK:
			break;

			case DCERPC_PKT_BIND:
			break;

			case DCERPC_PKT_BIND_ACK:
			break;

			case DCERPC_PKT_BIND_NAK:
				NDR_CHECK(ndr_push_dcerpc_bind_nak(ndr, NDR_BUFFERS, &r->bind_nak));
			break;

			case DCERPC_PKT_ALTER:
			break;

			case DCERPC_PKT_ALTER_RESP:
			break;

			case DCERPC_PKT_SHUTDOWN:
			break;

			case DCERPC_PKT_CO_CANCEL:
			break;

			case DCERPC_PKT_ORPHANED:
			break;

			case DCERPC_PKT_AUTH3:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dcerpc_payload(struct ndr_pull *ndr, int ndr_flags, union dcerpc_payload *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case DCERPC_PKT_REQUEST: {
				NDR_CHECK(ndr_pull_dcerpc_request(ndr, NDR_SCALARS, &r->request));
			break; }

			case DCERPC_PKT_PING: {
				NDR_CHECK(ndr_pull_dcerpc_ping(ndr, NDR_SCALARS, &r->ping));
			break; }

			case DCERPC_PKT_RESPONSE: {
				NDR_CHECK(ndr_pull_dcerpc_response(ndr, NDR_SCALARS, &r->response));
			break; }

			case DCERPC_PKT_FAULT: {
				NDR_CHECK(ndr_pull_dcerpc_fault(ndr, NDR_SCALARS, &r->fault));
			break; }

			case DCERPC_PKT_WORKING: {
				NDR_CHECK(ndr_pull_dcerpc_working(ndr, NDR_SCALARS, &r->working));
			break; }

			case DCERPC_PKT_NOCALL: {
				NDR_CHECK(ndr_pull_dcerpc_fack(ndr, NDR_SCALARS, &r->nocall));
			break; }

			case DCERPC_PKT_REJECT: {
				NDR_CHECK(ndr_pull_dcerpc_fault(ndr, NDR_SCALARS, &r->reject));
			break; }

			case DCERPC_PKT_ACK: {
				NDR_CHECK(ndr_pull_dcerpc_ack(ndr, NDR_SCALARS, &r->ack));
			break; }

			case DCERPC_PKT_CL_CANCEL: {
				NDR_CHECK(ndr_pull_dcerpc_cl_cancel(ndr, NDR_SCALARS, &r->cl_cancel));
			break; }

			case DCERPC_PKT_FACK: {
				NDR_CHECK(ndr_pull_dcerpc_fack(ndr, NDR_SCALARS, &r->fack));
			break; }

			case DCERPC_PKT_CANCEL_ACK: {
				NDR_CHECK(ndr_pull_dcerpc_cancel_ack(ndr, NDR_SCALARS, &r->cancel_ack));
			break; }

			case DCERPC_PKT_BIND: {
				NDR_CHECK(ndr_pull_dcerpc_bind(ndr, NDR_SCALARS, &r->bind));
			break; }

			case DCERPC_PKT_BIND_ACK: {
				NDR_CHECK(ndr_pull_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->bind_ack));
			break; }

			case DCERPC_PKT_BIND_NAK: {
				NDR_CHECK(ndr_pull_dcerpc_bind_nak(ndr, NDR_SCALARS, &r->bind_nak));
			break; }

			case DCERPC_PKT_ALTER: {
				NDR_CHECK(ndr_pull_dcerpc_bind(ndr, NDR_SCALARS, &r->alter));
			break; }

			case DCERPC_PKT_ALTER_RESP: {
				NDR_CHECK(ndr_pull_dcerpc_bind_ack(ndr, NDR_SCALARS, &r->alter_resp));
			break; }

			case DCERPC_PKT_SHUTDOWN: {
				NDR_CHECK(ndr_pull_dcerpc_shutdown(ndr, NDR_SCALARS, &r->shutdown));
			break; }

			case DCERPC_PKT_CO_CANCEL: {
				NDR_CHECK(ndr_pull_dcerpc_co_cancel(ndr, NDR_SCALARS, &r->co_cancel));
			break; }

			case DCERPC_PKT_ORPHANED: {
				NDR_CHECK(ndr_pull_dcerpc_orphaned(ndr, NDR_SCALARS, &r->orphaned));
			break; }

			case DCERPC_PKT_AUTH3: {
				NDR_CHECK(ndr_pull_dcerpc_auth3(ndr, NDR_SCALARS, &r->auth3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case DCERPC_PKT_REQUEST:
			break;

			case DCERPC_PKT_PING:
			break;

			case DCERPC_PKT_RESPONSE:
			break;

			case DCERPC_PKT_FAULT:
			break;

			case DCERPC_PKT_WORKING:
			break;

			case DCERPC_PKT_NOCALL:
			break;

			case DCERPC_PKT_REJECT:
			break;

			case DCERPC_PKT_ACK:
			break;

			case DCERPC_PKT_CL_CANCEL:
			break;

			case DCERPC_PKT_FACK:
			break;

			case DCERPC_PKT_CANCEL_ACK:
			break;

			case DCERPC_PKT_BIND:
			break;

			case DCERPC_PKT_BIND_ACK:
			break;

			case DCERPC_PKT_BIND_NAK:
				NDR_CHECK(ndr_pull_dcerpc_bind_nak(ndr, NDR_BUFFERS, &r->bind_nak));
			break;

			case DCERPC_PKT_ALTER:
			break;

			case DCERPC_PKT_ALTER_RESP:
			break;

			case DCERPC_PKT_SHUTDOWN:
			break;

			case DCERPC_PKT_CO_CANCEL:
			break;

			case DCERPC_PKT_ORPHANED:
			break;

			case DCERPC_PKT_AUTH3:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dcerpc_payload(struct ndr_print *ndr, const char *name, const union dcerpc_payload *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dcerpc_payload");
	switch (level) {
		case DCERPC_PKT_REQUEST:
			ndr_print_dcerpc_request(ndr, "request", &r->request);
		break;

		case DCERPC_PKT_PING:
			ndr_print_dcerpc_ping(ndr, "ping", &r->ping);
		break;

		case DCERPC_PKT_RESPONSE:
			ndr_print_dcerpc_response(ndr, "response", &r->response);
		break;

		case DCERPC_PKT_FAULT:
			ndr_print_dcerpc_fault(ndr, "fault", &r->fault);
		break;

		case DCERPC_PKT_WORKING:
			ndr_print_dcerpc_working(ndr, "working", &r->working);
		break;

		case DCERPC_PKT_NOCALL:
			ndr_print_dcerpc_fack(ndr, "nocall", &r->nocall);
		break;

		case DCERPC_PKT_REJECT:
			ndr_print_dcerpc_fault(ndr, "reject", &r->reject);
		break;

		case DCERPC_PKT_ACK:
			ndr_print_dcerpc_ack(ndr, "ack", &r->ack);
		break;

		case DCERPC_PKT_CL_CANCEL:
			ndr_print_dcerpc_cl_cancel(ndr, "cl_cancel", &r->cl_cancel);
		break;

		case DCERPC_PKT_FACK:
			ndr_print_dcerpc_fack(ndr, "fack", &r->fack);
		break;

		case DCERPC_PKT_CANCEL_ACK:
			ndr_print_dcerpc_cancel_ack(ndr, "cancel_ack", &r->cancel_ack);
		break;

		case DCERPC_PKT_BIND:
			ndr_print_dcerpc_bind(ndr, "bind", &r->bind);
		break;

		case DCERPC_PKT_BIND_ACK:
			ndr_print_dcerpc_bind_ack(ndr, "bind_ack", &r->bind_ack);
		break;

		case DCERPC_PKT_BIND_NAK:
			ndr_print_dcerpc_bind_nak(ndr, "bind_nak", &r->bind_nak);
		break;

		case DCERPC_PKT_ALTER:
			ndr_print_dcerpc_bind(ndr, "alter", &r->alter);
		break;

		case DCERPC_PKT_ALTER_RESP:
			ndr_print_dcerpc_bind_ack(ndr, "alter_resp", &r->alter_resp);
		break;

		case DCERPC_PKT_SHUTDOWN:
			ndr_print_dcerpc_shutdown(ndr, "shutdown", &r->shutdown);
		break;

		case DCERPC_PKT_CO_CANCEL:
			ndr_print_dcerpc_co_cancel(ndr, "co_cancel", &r->co_cancel);
		break;

		case DCERPC_PKT_ORPHANED:
			ndr_print_dcerpc_orphaned(ndr, "orphaned", &r->orphaned);
		break;

		case DCERPC_PKT_AUTH3:
			ndr_print_dcerpc_auth3(ndr, "auth3", &r->auth3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_ncacn_packet(struct ndr_push *ndr, int ndr_flags, const struct ncacn_packet *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->rpc_vers));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->rpc_vers_minor));
		NDR_CHECK(ndr_push_dcerpc_pkt_type(ndr, NDR_SCALARS, r->ptype));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->pfc_flags));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->drep, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->frag_length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->auth_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->call_id));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->ptype));
		NDR_CHECK(ndr_push_dcerpc_payload(ndr, NDR_SCALARS, &r->u));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dcerpc_payload(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ncacn_packet(struct ndr_pull *ndr, int ndr_flags, struct ncacn_packet *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->rpc_vers));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->rpc_vers_minor));
		NDR_CHECK(ndr_pull_dcerpc_pkt_type(ndr, NDR_SCALARS, &r->ptype));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pfc_flags));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->drep, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->frag_length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->auth_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->call_id));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->ptype));
		NDR_CHECK(ndr_pull_dcerpc_payload(ndr, NDR_SCALARS, &r->u));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dcerpc_payload(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ncacn_packet(struct ndr_print *ndr, const char *name, const struct ncacn_packet *r)
{
	ndr_print_struct(ndr, name, "ncacn_packet");
	ndr->depth++;
	ndr_print_uint8(ndr, "rpc_vers", r->rpc_vers);
	ndr_print_uint8(ndr, "rpc_vers_minor", r->rpc_vers_minor);
	ndr_print_dcerpc_pkt_type(ndr, "ptype", r->ptype);
	ndr_print_uint8(ndr, "pfc_flags", r->pfc_flags);
	ndr_print_array_uint8(ndr, "drep", r->drep, 4);
	ndr_print_uint16(ndr, "frag_length", r->frag_length);
	ndr_print_uint16(ndr, "auth_length", r->auth_length);
	ndr_print_uint32(ndr, "call_id", r->call_id);
	ndr_print_set_switch_value(ndr, &r->u, r->ptype);
	ndr_print_dcerpc_payload(ndr, "u", &r->u);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ncadg_packet(struct ndr_push *ndr, int ndr_flags, const struct ncadg_packet *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->rpc_vers));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->ptype));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->pfc_flags));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->ncadg_flags));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->drep, 3));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->serial_high));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->iface));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->activity));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->server_boot));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->iface_version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->seq_num));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->opnum));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ihint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ahint));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->fragnum));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->auth_proto));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->serial_low));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->ptype));
		NDR_CHECK(ndr_push_dcerpc_payload(ndr, NDR_SCALARS, &r->u));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dcerpc_payload(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ncadg_packet(struct ndr_pull *ndr, int ndr_flags, struct ncadg_packet *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->rpc_vers));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->ptype));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pfc_flags));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->ncadg_flags));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->drep, 3));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->serial_high));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->iface));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->activity));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->server_boot));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->iface_version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->seq_num));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->opnum));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ihint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ahint));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->fragnum));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->auth_proto));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->serial_low));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->ptype));
		NDR_CHECK(ndr_pull_dcerpc_payload(ndr, NDR_SCALARS, &r->u));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dcerpc_payload(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ncadg_packet(struct ndr_print *ndr, const char *name, const struct ncadg_packet *r)
{
	ndr_print_struct(ndr, name, "ncadg_packet");
	ndr->depth++;
	ndr_print_uint8(ndr, "rpc_vers", r->rpc_vers);
	ndr_print_uint8(ndr, "ptype", r->ptype);
	ndr_print_uint8(ndr, "pfc_flags", r->pfc_flags);
	ndr_print_uint8(ndr, "ncadg_flags", r->ncadg_flags);
	ndr_print_array_uint8(ndr, "drep", r->drep, 3);
	ndr_print_uint8(ndr, "serial_high", r->serial_high);
	ndr_print_GUID(ndr, "object", &r->object);
	ndr_print_GUID(ndr, "iface", &r->iface);
	ndr_print_GUID(ndr, "activity", &r->activity);
	ndr_print_uint32(ndr, "server_boot", r->server_boot);
	ndr_print_uint32(ndr, "iface_version", r->iface_version);
	ndr_print_uint32(ndr, "seq_num", r->seq_num);
	ndr_print_uint16(ndr, "opnum", r->opnum);
	ndr_print_uint16(ndr, "ihint", r->ihint);
	ndr_print_uint16(ndr, "ahint", r->ahint);
	ndr_print_uint16(ndr, "len", r->len);
	ndr_print_uint16(ndr, "fragnum", r->fragnum);
	ndr_print_uint8(ndr, "auth_proto", r->auth_proto);
	ndr_print_uint8(ndr, "serial_low", r->serial_low);
	ndr_print_set_switch_value(ndr, &r->u, r->ptype);
	ndr_print_dcerpc_payload(ndr, "u", &r->u);
	ndr->depth--;
}

