/* parser auto-generated by pidl */

#include "includes.h"
#include "../librpc/gen_ndr/ndr_named_pipe_auth.h"

#include "librpc/gen_ndr/ndr_netlogon.h"
static enum ndr_err_code ndr_push_named_pipe_auth_req_info2(struct ndr_push *ndr, int ndr_flags, const struct named_pipe_auth_req_info2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_addr));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->client_port));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_addr));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->server_port));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sam_info3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_key_length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->session_key));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_name, ndr_charset_length(r->client_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->client_addr) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client_addr, CH_DOS)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->client_addr, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_addr, ndr_charset_length(r->client_addr, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
		if (r->server_name) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_name, ndr_charset_length(r->server_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->server_addr) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_addr, CH_DOS)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_charset_length(r->server_addr, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_addr, ndr_charset_length(r->server_addr, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
		if (r->sam_info3) {
			NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam_info3));
		}
		if (r->session_key) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->session_key_length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->session_key, r->session_key_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_named_pipe_auth_req_info2(struct ndr_pull *ndr, int ndr_flags, struct named_pipe_auth_req_info2 *r)
{
	uint32_t _ptr_client_name;
	TALLOC_CTX *_mem_save_client_name_0;
	uint32_t _ptr_client_addr;
	TALLOC_CTX *_mem_save_client_addr_0;
	uint32_t _ptr_server_name;
	TALLOC_CTX *_mem_save_server_name_0;
	uint32_t _ptr_server_addr;
	TALLOC_CTX *_mem_save_server_addr_0;
	uint32_t _ptr_sam_info3;
	TALLOC_CTX *_mem_save_sam_info3_0;
	uint32_t _ptr_session_key;
	TALLOC_CTX *_mem_save_session_key_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_name));
		if (_ptr_client_name) {
			NDR_PULL_ALLOC(ndr, r->client_name);
		} else {
			r->client_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_addr));
		if (_ptr_client_addr) {
			NDR_PULL_ALLOC(ndr, r->client_addr);
		} else {
			r->client_addr = NULL;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->client_port));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_name));
		if (_ptr_server_name) {
			NDR_PULL_ALLOC(ndr, r->server_name);
		} else {
			r->server_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_addr));
		if (_ptr_server_addr) {
			NDR_PULL_ALLOC(ndr, r->server_addr);
		} else {
			r->server_addr = NULL;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->server_port));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sam_info3));
		if (_ptr_sam_info3) {
			NDR_PULL_ALLOC(ndr, r->sam_info3);
		} else {
			r->sam_info3 = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->session_key_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_session_key));
		if (_ptr_session_key) {
			NDR_PULL_ALLOC(ndr, r->session_key);
		} else {
			r->session_key = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client_name) {
			_mem_save_client_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client_name));
			if (ndr_get_array_length(ndr, &r->client_name) > ndr_get_array_size(ndr, &r->client_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client_name), ndr_get_array_length(ndr, &r->client_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client_name), sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_name, ndr_get_array_length(ndr, &r->client_name), sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_name_0, 0);
		}
		if (r->client_addr) {
			_mem_save_client_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client_addr));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client_addr));
			if (ndr_get_array_length(ndr, &r->client_addr) > ndr_get_array_size(ndr, &r->client_addr)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->client_addr), ndr_get_array_length(ndr, &r->client_addr));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->client_addr), sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_addr, ndr_get_array_length(ndr, &r->client_addr), sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_addr_0, 0);
		}
		if (r->server_name) {
			_mem_save_server_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_name));
			if (ndr_get_array_length(ndr, &r->server_name) > ndr_get_array_size(ndr, &r->server_name)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_name), ndr_get_array_length(ndr, &r->server_name));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_name), sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_name, ndr_get_array_length(ndr, &r->server_name), sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_name_0, 0);
		}
		if (r->server_addr) {
			_mem_save_server_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_addr, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_addr));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_addr));
			if (ndr_get_array_length(ndr, &r->server_addr) > ndr_get_array_size(ndr, &r->server_addr)) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->server_addr), ndr_get_array_length(ndr, &r->server_addr));
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->server_addr), sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_addr, ndr_get_array_length(ndr, &r->server_addr), sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_addr_0, 0);
		}
		if (r->sam_info3) {
			_mem_save_sam_info3_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sam_info3, 0);
			NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_SCALARS|NDR_BUFFERS, r->sam_info3));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sam_info3_0, 0);
		}
		if (r->session_key) {
			_mem_save_session_key_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->session_key, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->session_key));
			NDR_PULL_ALLOC_N(ndr, r->session_key, ndr_get_array_size(ndr, &r->session_key));
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->session_key, ndr_get_array_size(ndr, &r->session_key)));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_session_key_0, 0);
		}
		if (r->session_key) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->session_key, r->session_key_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_named_pipe_auth_req_info2(struct ndr_print *ndr, const char *name, const struct named_pipe_auth_req_info2 *r)
{
	ndr_print_struct(ndr, name, "named_pipe_auth_req_info2");
	ndr->depth++;
	ndr_print_ptr(ndr, "client_name", r->client_name);
	ndr->depth++;
	if (r->client_name) {
		ndr_print_string(ndr, "client_name", r->client_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "client_addr", r->client_addr);
	ndr->depth++;
	if (r->client_addr) {
		ndr_print_string(ndr, "client_addr", r->client_addr);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "client_port", r->client_port);
	ndr_print_ptr(ndr, "server_name", r->server_name);
	ndr->depth++;
	if (r->server_name) {
		ndr_print_string(ndr, "server_name", r->server_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_addr", r->server_addr);
	ndr->depth++;
	if (r->server_addr) {
		ndr_print_string(ndr, "server_addr", r->server_addr);
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "server_port", r->server_port);
	ndr_print_ptr(ndr, "sam_info3", r->sam_info3);
	ndr->depth++;
	if (r->sam_info3) {
		ndr_print_netr_SamInfo3(ndr, "sam_info3", r->sam_info3);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "session_key_length", r->session_key_length);
	ndr_print_ptr(ndr, "session_key", r->session_key);
	ndr->depth++;
	if (r->session_key) {
		ndr_print_array_uint8(ndr, "session_key", r->session_key, r->session_key_length);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_named_pipe_auth_req_info(struct ndr_push *ndr, int ndr_flags, const union named_pipe_auth_req_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 0: {
			break; }

			case 1: {
				NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_named_pipe_auth_req_info2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_push_named_pipe_auth_req_info2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_named_pipe_auth_req_info(struct ndr_pull *ndr, int ndr_flags, union named_pipe_auth_req_info *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 0: {
			break; }

			case 1: {
				NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_SCALARS, &r->info1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_named_pipe_auth_req_info2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
				NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_named_pipe_auth_req_info2(ndr, NDR_BUFFERS, &r->info2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_named_pipe_auth_req_info(struct ndr_print *ndr, const char *name, const union named_pipe_auth_req_info *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "named_pipe_auth_req_info");
	switch (level) {
		case 0:
		break;

		case 1:
			ndr_print_netr_SamInfo3(ndr, "info1", &r->info1);
		break;

		case 2:
			ndr_print_named_pipe_auth_req_info2(ndr, "info2", &r->info2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_named_pipe_auth_req(struct ndr_push *ndr, int ndr_flags, const struct named_pipe_auth_req *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_named_pipe_auth_req(r, ndr->iconv_convenience, ndr->flags) - 4));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, NAMED_PIPE_AUTH_MAGIC, 4, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_push_named_pipe_auth_req_info(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_named_pipe_auth_req_info(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_named_pipe_auth_req(struct ndr_pull *ndr, int ndr_flags, struct named_pipe_auth_req *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->magic, 4, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_pull_named_pipe_auth_req_info(ndr, NDR_SCALARS, &r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_named_pipe_auth_req_info(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_named_pipe_auth_req(struct ndr_print *ndr, const char *name, const struct named_pipe_auth_req *r)
{
	ndr_print_struct(ndr, name, "named_pipe_auth_req");
	ndr->depth++;
	ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_named_pipe_auth_req(r, ndr->iconv_convenience, ndr->flags) - 4:r->length);
	ndr_print_string(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NAMED_PIPE_AUTH_MAGIC:r->magic);
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->info, r->level);
	ndr_print_named_pipe_auth_req_info(ndr, "info", &r->info);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_named_pipe_auth_req(const struct named_pipe_auth_req *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_named_pipe_auth_req, ic);
}

static enum ndr_err_code ndr_push_named_pipe_auth_rep_info2(struct ndr_push *ndr, int ndr_flags, const struct named_pipe_auth_rep_info2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->file_type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->device_state));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->allocation_size));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_named_pipe_auth_rep_info2(struct ndr_pull *ndr, int ndr_flags, struct named_pipe_auth_rep_info2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->file_type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->device_state));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->allocation_size));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_named_pipe_auth_rep_info2(struct ndr_print *ndr, const char *name, const struct named_pipe_auth_rep_info2 *r)
{
	ndr_print_struct(ndr, name, "named_pipe_auth_rep_info2");
	ndr->depth++;
	ndr_print_uint16(ndr, "file_type", r->file_type);
	ndr_print_uint16(ndr, "device_state", r->device_state);
	ndr_print_hyper(ndr, "allocation_size", r->allocation_size);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_named_pipe_auth_rep_info(struct ndr_push *ndr, int ndr_flags, const union named_pipe_auth_rep_info *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		switch (level) {
			case 0: {
			break; }

			case 1: {
			break; }

			case 2: {
				NDR_CHECK(ndr_push_named_pipe_auth_rep_info2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 0:
			break;

			case 1:
			break;

			case 2:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_named_pipe_auth_rep_info(struct ndr_pull *ndr, int ndr_flags, union named_pipe_auth_rep_info *r)
{
	int level;
	uint32_t _level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r", _level);
		}
		switch (level) {
			case 0: {
			break; }

			case 1: {
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_named_pipe_auth_rep_info2(ndr, NDR_SCALARS, &r->info2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 0:
			break;

			case 1:
			break;

			case 2:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u", level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_named_pipe_auth_rep_info(struct ndr_print *ndr, const char *name, const union named_pipe_auth_rep_info *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "named_pipe_auth_rep_info");
	switch (level) {
		case 0:
		break;

		case 1:
		break;

		case 2:
			ndr_print_named_pipe_auth_rep_info2(ndr, "info2", &r->info2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_named_pipe_auth_rep(struct ndr_push *ndr, int ndr_flags, const struct named_pipe_auth_rep *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		{
			uint32_t _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_named_pipe_auth_rep(r, ndr->iconv_convenience, ndr->flags) - 4));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, NAMED_PIPE_AUTH_MAGIC, 4, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_push_named_pipe_auth_rep_info(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_named_pipe_auth_rep_info(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_named_pipe_auth_rep(struct ndr_pull *ndr, int ndr_flags, struct named_pipe_auth_rep *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		{
			uint32_t _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->magic, 4, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_pull_named_pipe_auth_rep_info(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_named_pipe_auth_rep_info(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_named_pipe_auth_rep(struct ndr_print *ndr, const char *name, const struct named_pipe_auth_rep *r)
{
	ndr_print_struct(ndr, name, "named_pipe_auth_rep");
	ndr->depth++;
	ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_named_pipe_auth_rep(r, ndr->iconv_convenience, ndr->flags) - 4:r->length);
	ndr_print_string(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NAMED_PIPE_AUTH_MAGIC:r->magic);
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->info, r->level);
	ndr_print_named_pipe_auth_rep_info(ndr, "info", &r->info);
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_named_pipe_auth_rep(const struct named_pipe_auth_rep *r, struct smb_iconv_convenience *ic, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_named_pipe_auth_rep, ic);
}

