#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

#echo; echo "${S}__ STARTING TEST COMPILE __${E}"; echo;
#echo Working directory: $PW_DIR

MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test x$MAKE = x; then
	MAKE="make -s"
    elif test x$MAKE = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
	fi
    fi
fi

#echo MAKE is $MAKE
#echo

testmake ()
{

	if test x$1 = x0; then
		echo "PASS: configure ${TEST}"; 
		$MAKE  > /dev/null 2>> test_log
		if test x$? = x0; then
		    echo "PASS: $MAKE  ${TEST}";
 		else
		    echo "FAIL: $MAKE  ${TEST} (see ./test_log)";
		fi
	else
		echo "FAIL: configure  ${TEST} (see ./test_log)"; 
	fi
}

testcompile ()
{
	rm -f ./test_log

	#
	# test standalone compilation
	#
        TEST="${S}standalone agent w/suidcheck${E}"
	#
	if test -r "Makefile"; then
		$MAKE distclean 
	fi
	#
	./configure --quiet  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  --enable-suidcheck > /dev/null 2>> test_log
	#
	testmake $?

	#
	# test standalone compilation
	#
        TEST="${S}standalone agent w/mounts-check and w/userfiles${E}"
	#
	if test -r "Makefile"; then
		$MAKE distclean 
	fi
	#
	./configure --quiet  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  --enable-mounts-check --enable-userfiles  > /dev/null 2>> test_log
	#
	testmake $?


	#
	# test standalone compilation
	#
        TEST="${S}standalone agent w/timeserver and w/message-queue${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean 
	fi
	#
	./configure --quiet  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  --enable-message-queue --with-timeserver=127.0.0.1 > /dev/null 2>> test_log
	#
	testmake $?

	#
	# test standalone compilation with --with-nocl=PW
	#
	TEST="${S}standalone agent w/nocl${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet  --prefix=$PW_DIR --enable-nocl="owl" --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test standalone compilation w/ debug
	#
	TEST="${S}standalone agent w/debug${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-debug  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	testmake $?

	#
	# test standalone compilation w/ gpg
	#
	TEST="${S}standalone agent w/gpg${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --with-gpg=/usr/bin/gpg  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test standalone compilation w/stealth
	#
	TEST="${S}standalone agent w/stealth${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-stealth=128 --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test standalone compilation w/logwatch
	#
	TEST="${S}standalone agent w/login-watch${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-login-watch  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test standalone compilation
	#
	TEST="${S}standalone agent w/o mail${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --disable-mail --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	testmake $?

	#
	# test standalone compilation
	#
	TEST="${S}standalone agent w/o external scripts${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --disable-external-scripts --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	# echo; echo "${S}__ TEST CLIENT/SERVER __${E}"; echo;

	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/timeserver${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client  --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test   --with-timeserver=127.0.0.1 > /dev/null 2>> test_log   
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server  --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test   --with-timeserver=127.0.0.1 > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test c/s compilation w/ gpg
	#
	TEST="${S}client/server application w/gpg${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server  --enable-srp --with-gpg=/usr/bin/gpg  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client  --enable-srp --with-gpg=/usr/bin/gpg  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?


	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/o srp${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server --disable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client --disable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test client/server compilation w/ debug
	#
	TEST="${S}client/server application w/debug${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test client/server compilation w/stealth
	#
	TEST="${S}client/server application w/stealth${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server  --enable-srp --enable-stealth=128 --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client  --enable-srp --enable-stealth=128 --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	testmake $?

	#
	# test  client/server compilation w/logwatch
	#
	TEST="${S}client/server application w/login-watch${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server  --enable-srp --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client  --enable-srp --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	testmake $?

	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/o mail${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server  --disable-mail --enable-srp --enable-stealth=128 --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client  --disable-mail --enable-srp --enable-stealth=128 --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?

	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/o external scripts${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=server  --disable-srp --disable-external-scripts --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	./configure --quiet --enable-network=client  --disable-srp --disable-external-scripts --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	testmake $?
}



	testcompile


# echo; echo "${S}__ END TEST COMPILE __${E}"; echo;

exit

