.\" $Id: sane-niash.man,v 1.1 2003/12/13 22:08:29 bertrik Exp $
.TH sane-niash 5 "17 Dec 2001"
.IX sane-niash

.SH NAME
sane-niash - SANE backend for scanners based on the NIASH chipset.

.SH DESCRIPTION
The
.B sane-niash
implements a SANE (Scanner Access Now Easy) backend that
provides access to NIASH chipset based scanners. This backend will try to support 
the following models:

MANUFACTURER:    MODEL:         USB ID:   
.br
---------------  --------------  ---------  
.br
Agfa             Snapscan Touch  06BD-0100 (1)(a)
.br
Hewlett-Packard  Scanjet 3300c   03F0-0205 (1)(a)(b)
.br
Hewlett-Packard  Scanjet 3400c   03F0-0405 (2)(b)
.br 
Hewlett-Packard  Scanjet 4300c   03F0-0305 (2)(a)
.PP
.br
ASIC: (1) - NIASH00014 / (2) - NIASH00019
.br
ANALOG FRONT-END: (a) - ESIC ES8100QA / (b) - WM8143-12
.br

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is a path-name for the special device that corresponds to a USB scanner.
With GNU/Linux systems, such a device name could be
.I /dev/usb/scanner0
or
.IR /dev/usbscanner1 ,
for example.


.SH CONFIGURATION
The
.I niash.conf
file contains the device name that correspond to the NIASH
scanner.  Empty lines and lines starting with a hash mark (#) are
ignored.
.PP
A sample configuration file is shown below:
.PP
.RS
# Comment
.br
/dev/usbscanner
.RE
.PP
The first line is ignored. The second line is the device filename to use
in order to access the NIASH Scanner. If no device is given, the
backend will use libUSB.

.SH FILES
.TP
.I @CONFIGDIR@/niash.conf
The backend configuration file (see also description of SANE_CONFIG_DIR below).

.TP
.I @LIBDIR@/libsane-niash.a
The static library implementing this backend.

.TP
.I @LIBDIR@/libsane-niash.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT

.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP

.B SANE_DEBUG_NIASH
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  Higher
debug levels increase the verbosity of the output. 

Example: 
export SANE_DEBUG_NIASH=255

.SH "SEE ALSO"
sane(7), sane\-usb(5)
.br
http://www.sourceforge.net/projects/hp3300backend
.SH AUTHOR
Bertrik Sikken <bertrik@zonnet.nl>
