#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc HelpRef {} {
    global help

    HV hlpref "Reference Manual" $help(refman) 2 0 {}
}

proc HelpKeyboard {} {
    global help

    HV hlpkeyboard "Keyboard Shortcuts" $help(keyboard) 2 0 {}
}

proc HelpFAQ {} {
    global help

    HV hlpfaq "FAQ" $help(faq) 2 0 {}
}

proc HelpNew {} {
    global help

    HV hlpnew "New Features" $help(new) 2 0 {}
}

proc HelpIssue {} {
    global help

    HV hlpissue "Known Issues" $help(issue) 2 0 {}
}

proc HelpRelease {} {
    global help

    HV hlprelease "Release Notes" $help(release) 2 0 {}
}

proc HelpDesk {} {
    global help

    HV hlpdsk "Help Desk" $help(helpdesk) 2 0 {}
}

proc HelpAck {} {
    global help

    HV hlpack "Acknowledgment" $help(ack) 2 0 {}
}

proc HelpHome {} {
    global help

    HV hlphome "DS9 Home Page" $help(home) 2 0 {}
}

proc DumpHelp {} {
    global help
    puts "$help(commands)"
}

proc InitHelp {} {
    global help
    global ds9

    set help(refman) "doc/ref/index.html"
    set help(command) "doc/ref/command.html"
    set help(keyboard) "doc/ref/keyboard.html"
    set help(faq) "doc/faq.html"
    set help(new) "doc/new.html"
    set help(issue) "doc/issue.html"
    set help(release) "doc/release/r3.0.html"
    set help(helpdesk) "doc/helpdesk.html"
    set help(ack) "doc/acknowledgment.html"
    set help(home) "http://hea-www.harvard.edu/RD/ds9/"

    set help(about,message) "SAOImage DS9\nVersion $ds9(version)\n\nAuthors:\nWilliam Joye (SAO)\nEric Mandel (SAO)\nSteve Murray (SAO)\nJohn Roll (SAO)\n\nContributions from:\nD.S. Berry (Starlink)\nL. Brown (HEASARC)\nMark Calabretta (ATNF)\nMike Fitzpatrick (NOAO)\nDong Mink (SAO)\nDoug Tody (NOAO)\nP.T. Wallace (Starlink)\nR.F. Warren-Smith (Starlink)\nPeter Wilson (HEASARC)\n\nOther Contributors:\nMark Adler, Jean-loup Gailly,\nD. Richard Hip, G. Howlett,\nJan Nijtmans, John Ousterhout"

    set help(about) "Display credits"

    set help(bin) "\t\[about <x> <y>\]\n\t\t\[buffersize <value>\]\n\t\t\[cols <x> <y>\]\n\t\t\[factor <value>\]\n\t\t\[depth <value>\]\n\t\t\[filter <string>\]\n\t\t\[function average|sum\]\n\t\t\[to fit\]\n\t\t\[smooth yes|no\]\n\t\t\[smooth function boxchar|tophat|gaussian\]\n\t\t\[smooth radius <value>\]"

    set help(contour) "\[yes|no\]\n\t\t\[<coordinate system> \[<sky frame>\]\]\n\t\t\[copy\]\n\t\t\[paste <coordinate system> \[<sky frame\] <color> <width>\]\n\t\t\[load <filename> <coord system> \[<sky frame>\] <color> <width>\]\n\t\t\[save <filename> <coordinate system> \[<sky frame>\]\]"

    set help(cmap) "\t\[<colormap>\]\n\t\t\[file <filename>\]\n\t\t\[invert yes|no\]\n\t\t\[value <constrast> <bias>\]"

    set help(data) "\t\[<coordinate system> \[<sky frame>\] <x> <y> <w> <h> \[yes|no\]\]"

    set help(datacube) "\[play|stop|next|prev|first|last]\n\t\t\[\#\]\n\t\t\[interval \#\]"

    set help(dss) "\t\[<object>\]\n\t\t\[name <object>\]\n\t\t\[coordinate <ra> <dec>\]\n\t\t\[server sao|stsci|eso\]\n\t\t\[survey dss|dss2red|dss2blue\]\n\t\t\[size <width> <height>\]"

    set help(grid) "\t\[yes|no]\n\t\t\[load <filename>\]\n\t\t\[save <filename>\]\n\t\t\[system <coordinate system>\]\n\t\t\[sky <sky frame>\]\n\t\t\[skyformat <skyformat>\]\n\t\t\[type analysis|publication\]\n\t\t\[type axes interior|exterior\]\n\t\t\[type numerics interior|exterior\]\n\t\t\[view grid|axes|title|border|vertical yes|no\]\n\t\t\[view axes numbers|tickmarks|label yes|no\]"

    set help(file) "\t\[new\]\[<filename>\]\n\t\t\[new\]\[fits <filename>\]\n\t\t\[new\]\[medatacube <filename>\]\n\t\t\[new\]\[mosaicimage \[iraf|wcs|wcsa...wcsz|wfpc2\] <filename>\]\n\t\t\[new\]\[mosaicimagenext \[wcs|wcsa...wcsz\] <filename>\]\n\t\t\[new\]\[mosaic \[iraf|wcs|wcsa...wcsz\] <filename>\]\n\t\t\[new\]\[rgbimage <filename>\]\n\t\t\[new\]\[rgbcube <filename>\]\n\t\t\[new\]\[rgbarray <filename>\]\n\t\t\[new\]\[array <filename>\]\n\t\t\[new\]\[url <url>\]\n\t\t\[save \[gz\] <filename>\]"

    set help(fits) "\t\[size\]\n\t\t\[size \[image|phyical|wcs|wcsa...wcsz\] \[degrees|arcmin|arcsec\]\]\n\t\t\[depth\]\n\t\t\[header \[\#\]\n\t\t\[type\]\n\t\t\[image|table|resample\] \[gz\]\n\t\t\[new\]\[mosaicimage \[iraf|wcs|wcsa...wcsz|wfpc2\] <options>\]\n\t\t\[new\]\[mosaicimagenext \[wcs|wcsa...wcsz\] <options>\]\n\t\t\[new\]\[mosaic \[iraf|wcs|wcsa...wcsz\] <options>\]\n\t\t\[new\]\[medatacube <filename>\]\n\t\t\[new\]\\n\t\t\[new\]\[rgbcube <options>\]\n\t\t\[new\]\[rgbimage <options>\]"

    set help(frame) "\t\[center \[\#|all\]\]\n\t\t\[clear \[\#|all\]\]\n\t\t\[new \[rgb\]\]\]\n\t\t\[delete \[\#|all\]\]\n\t\t\[reset \[\#|all\]\]\n\t\t\[refresh \[\#|all\]\]\n\t\t\[hide \[\#|all\]\]\n\t\t\[show \[\#|all\]\]\n\t\t\[first\]\n\t\t\[next\]\n\t\t\[prev\]\n\t\t\[last\]\n\t\t\[frameno \#\]\n\t\t\[\#\]"

    set help(lock) "\t\[crosshairs none|wcs|wcsa...wcsz|physical|image\]"

    set help(match) "\t\[frames wcs|physical|image\]\n\t\t\[colorbars\]\n\t\t\[scales\]"

    set help(minmax) "\t\[\]\n\t\t\[scan|sample|datamin|irafmin\]\n\t\t\[mode scan|sample|datamin|irafmin\]\n\t\t\[interval <value>\]"

    set help(mode) "\t\[none|pointer|crosshair|colorbar|pan|zoom|rotate|examine\]"

    set help(nsvr) "\[<object>\]\n\t\t\[name <object>\]\n\t\t\[server ned-sao|ned-eso|simbad-sao|simbad-eso\]\n\t\t\[skyformat degrees|sexagesimal\]"

    set help(orient) "\t\[none|x|y|xy\]"

    set help(pagesetup)	"\[orientation portrait|landscape\]\n\t\t\[pagescale scaled|fixed\]\n\t\t\[pagesize letter|legal|a4\]"

    set help(pan) "\t\[x y <coordinate system> \[<sky frame>\]\]\n\t\t\[to x y <coordinate system> \[<sky frame>\]\]"

    set help(prefs) "\t\[mosaic fast yes|no\]\n\t\t\[bgcolor <color>\]\n\t\t\[nancolor <color>\]"

    set help(preserve) "\t\[scale yes|no\]\n\t\t\[pan yes|no\]\n\t\t\[regions yes|no\]"

    set help(print) "\t\[destination printer|file\]\n\t\t\[command <command>\]\n\t\t\[filename <filename>\]\n\t\t\[palette rgb|cmyk|gray\]\n\t\t\[level 1|2\]\n\t\t\[interpolate yes|no\]\n\t\t\[resolution 53|72|75|150|300|600\]"

    set help(plot) "\t\[new\]\n\t\t\[new stdin\]\n\t\t\[new <title> <xaxis label> <yaxis label>  xy|xyex|xyey|xyexey\]\n\t\t\[<plotname>\]\[load <filename> xy|xyex|xyey|xyexey\]\n\t\t\[<plotname>\]\[save <filename>\]\n\t\t\[<plotname>\]\[clear\]\n\t\t\[<plotname>\]\[loadconfig <filename>\]\n\t\t\[<plotname>\]\[saveconfig <filename>\]\n\t\t\[<plotname>\]\[print\]\n\t\t\[<plotname>\]\[print destination printer|file\]\n\t\t\[<plotname>\]\[print command <command>\]\n\t\t\[<plotname>\]\[print filename <filename>\]\n\t\t\[<plotname>\]\[print palette rgb|cmyk|gray\]\n\t\t\[<plotname>\]\[page orientation portrait|landscape\]\n\t\t\[<plotname>\]\[page pagescale scaled|fixed\]\n\t\t\[<plotname>\]\[page pagesize letter|legal|tabloid|poster|a4\]\n\t\t\[<plotname>\]\[close\]\n\t\t\[<plotname>\]\[graph grid yes|no\]\n\t\t\[<plotname>\]\[graph scale \n\t\t\tlinearlinear|linearlog|loglinear|loglog\]\n\t\t\[<plotname>\]\[graph range x|y auto yes|no\]\n\t\t\[<plotname>\]\[graph range x|y min <value>\]\n\t\t\[<plotname>\]\[graph range x|y max <value>\]\n\t\t\[<plotname>\]\[graph labels title|xaxis|yaxis <value>\]\n\t\t\[<plotname>\]\[font numbers|labels|title font \n\t\t\ttimes|helvetica|symbol|courier\]\n\t\t\[<plotname>\]\[font numbers|labels|title size <value>\]\n\t\t\[<plotname>\]\[font numbers|labels|title style plain|bold|italic\]\n\t\t\[<plotname>\]\[dataset #\]\n\t\t\[<plotname>\]\[view discrete|line|step|quadratic|errorbar yes|no\]\n\t\t\[<plotname>\]\[color discrete|line|step|quadratic|errorbar \n\t\t\tred|green|blue|cyan|magenta|yellow|black|white\]\n\t\t\[<plotname>\]\[line discrete circle|diamond|plus|cross\]\n\t\t\[<plotname>\]\[line line|step|quadratic|errorbar width <value>\]\n\t\t\[<plotname>\]\[line line|step|quadratic dash yes|no\]\n\t\t\[<plotname>\]\[line errorbar style yes|no\]"

    set help(regions) "\[fg|bg\]\[move front\]\n\t\t\[fg|bg\]\[move back\]\n\t\t\[fg|bg\]\[select all\]\n\t\t\[fg|bg\]\[select none\]\n\t\t\[fg|bg\]\[select group <groupname>\]\n\t\t\[fg|bg\]\[delete all\]\n\t\t\[fg|bg\]\[delete select\]\n\t\t\[fg|bg\]\[load <filename>\]\n\t\t\[fg|bg\]\[save <filename>\]\n\t\t\[format\]\n\t\t\[-format ds9|ciao|saotng|saoimage|pros|xy\]\n\t\t\[system\]\n\t\t\[-system image|physical|wcs|wcsa...wcsz\]\n\t\t\[sky\]\n\t\t\[-sky fk4|fk5|icrs|galactic|ecliptic\]\n\t\t\[skyformat\]\n\t\t\[-skyformat degrees|sexagesimal\]\n\t\t\[strip\]\n\t\t\[-strip yes|no\]\n\t\t\[shape <shape>\]\n\t\t\[color <color>\]\n\t\t\[width <width>\]\n\t\t\[fg|bg\]\[include|exclude|source|background|selected\]\n\t\t\[fg|bg\]\[-prop <property>\]"

    set help(rgb) "\t\[\]\n\t\t\[red|green|blue\]\n\t\t\[channel \[red|green|blue\]\]\n\t\t\[lock scale|bin|colorbar \[yes|no\]\]\n\t\t\[view \[red|green|blue\] \[yes|no\]\]\n\t\t\[system <coordinate system>\]"

    set help(rotate) "\t\[<value>\]\n\t\t\[to <value>\]"

    set help(save,image) "\t\[fits|jpeg|tiff|png|ppm|mpeg <filename>\]"
    set help(save,fits) "\t\[<filename>\]"
    set help(save,mpeg) "\t\[<filename>\]"

    set help(scale) "\t\[linear|log|squared|sqrt|histequ\]\n\t\t\[datasec yes|no\]\n\t\t\[limits <minvalue> <maxvalue>\]\n\t\t\[mode minmax|<value>|zscale|zmax\]\n\t\t\[scope local|global\]"

    set help(shm) "\t\[<key> \[<filename>\]\] \n\t\t\[key <key> \[<filename>\]\]\n\t\t\[shmid <shmid> \[<filename>\]\]\n\t\t\[fits \[key|shmid\] <id> \[filename\]\]\n\t\t\[sfits \[key|shmid\] <id> <id> \[filename\]\]\n\t\t\[mosaicimage \[iraf|wcs|wcsa...wcsz|wfpc2\] \[key|shmid\] <id> \[<filename>\]\]\n\t\t\[mosaicimagenext \[wcs|wcsa...wcsz\] \[key|shmid\] <id> \[<filename>\]\]\n\t\t\[mosaic \[iraf|wcs|wcsa...wcsz\] \[key|shmid\] <id> \[<filename>\]\]\n\t\t\[smosaic \[iraf|wcs|wcsa...wcsz\] \[key|shmid\] <id> <id> \[<filename>\]\]\n\t\t\[rgbcube \[key|shmid\] <id> \[<filename>\]\]\n\t\t\[srgbcube \[key|shmid\] <id> <id> \[<filename>\]\]\n\t\t\[rgbimage \[key|shmid\] <id> \[<filename>\]\]\n\t\t\[rgbarray \[key|shmid\] <id> \[dim=<dim>,zdim=3,bitpix=<b>,\[skip=<s>\]\]\n\t\t\[array \[key|shmid\] <id> \[dim=<dim>,bitpix=<b>,\[skip=<s>\]\]"

    set help(tile) "\t\[yes|no\]\n\t\t\[mode grid|row|column\]\n\t\t\[grid\]\n\t\t\[grid mode \[automatic|manual\]\]\n\t\t\[grid layout <row> <col>\]\n\t\t\[grid gap <pixels>\]\n\t\t\[row\]\n\t\t\[column\]"

    set help(view) "\t\[info yes|no\]\n\t\t\[panner yes|no\]\n\t\t\[magnifier yes|no\]\n\t\t\[buttons yes|no\]\n\t\t\[colorbar yes|no\]\n\t\t\[horzgraph yes|no\]\n\t\t\[vertgraph yes|no\]\n\t\t\[filename yes|no\]\n\t\t\[object yes|no\]\n\t\t\[minmax yes|no\]\n\t\t\[frame yes|no\]\n\t\t\[image|physical|wcs|wcsa...wcsz yes|no\]\n\t\t\[red yes|no\]\n\t\t\[green yes|no\]\n\t\t\[blue yes|no\]" 

    set help(vo) "\t<url>"

    set help(wcs) "\t\[wcs|wcsa...wcsz\]\n\t\t\[system wcs|wcsa...wcsz\]\n\t\t\[sky fk4|fk5|icrs|galactic|ecliptic\]\n\t\t\[skyformat degrees|sexagesimal\]\n\t\t\[align yes|no\]\n\t\t\[reset\]\n\t\t\[replace file <filename>\]\]\n\t\t\[append file <filename>\]\]"

    set help(web) "\t<url>"

    set help(version) "-- display version"

    set help(xpa) "\t\[yes|no\]\n\t\t\[inet|local|unix|localhost\]\n\t\t\[noxpans\]\n\t\t\[tcl yes|no\]"

    set help(zoom) "\t\[<value>\]\n\t\t\[to fit\]\n\t\t\[to <value>\]"

    global ds9
    set help(commands) " DS9 version $ds9(version)\n\
          Usage: ds9 \[options\] \[filename(s)...\]\n\
          \-?\t\tDisplay this message\n\
          \-about \t$help(about)\n\
          \-analysis \t<filename>\n\
          \-array \t<filename>\n\
          \-bin \t$help(bin)\n\
          \-blink\n\
          \-blue\n\
          \-cmap \t$help(cmap)\n\
          \-contour \t$help(contour)\n\
          \-datacube \t$help(datacube)\n\
          \-dss \t$help(dss)\n\
          \-exit\n\
          \-frame $help(frame)\n\
          \-fifo \t\t<name>\n\
          \-fifo_only\n\
          \-fits \t\t<filename>\n\
          \-sfits \t\t<filename> <filename>\n\
          \-geometry \t<value>\n\
          \-green\t\n\
          \-grid \t$help(grid)\n\
          \-help \t\tDisplay this message\n\
          \-histequ\n\
          \-iconify\n\
          \-inet_only\n\
          \-invert\n\
          \-linear\n\
          \-lock \t$help(lock)\n\
          \-log\n\
          \-lower\n\
          \-match $help(match)\n\
          \-medatacube \t\t<filename>\n\
          \-minmax $help(minmax)\n\
          \-mode \t$help(mode)\n\
          \-mosaicimage \t\[iraf|wcs|wcsa...wcsz|wfpc2\] <filename>\n\
          \-mosaicimagenext \t\[wcs|wcsa...wcsz\] <filename>\n\
          \-mosaic \t\[iraf|wcs|wcsa...wcsz\] <filename>\n\
          \-smosaic \t\[iraf|wcs|wcsa...wcsz\] <filename> <filename>\n\
          \-nameserver \t$help(nsvr)\n\
          \-orient $help(orient)\n\
          \-pagesetup \t$help(pagesetup)\n\
          \-pan \t$help(pan)\n\
          \-\[no\]pixeltable\n\
          \-plot \t$help(plot)\n\
          \-prefs $help(prefs)\n\
          \-preserve $help(preserve)\n\
          \-print $help(print)\n\
          \-private\n\
          \-port \t\t<number>\n\
          \-port_only\n\
          \-quit\n\
          \-raise\n\
          \-red\n\
          \-region \t<filename>\n\
          \-rgb \t$help(rgb)\n\
          \-rgbcube \t<filename>\n\
          \-srgbcube \t<filename> <filename>\n\
          \-rgbimage \t<filename>\n\
          \-rgbarray \t<filename>\n\
          \-rotate $help(rotate)\n\
          \-saveimage $help(save,image)\n\
          \-savefits $help(save,fits)\n\
          \-savempeg $help(save,mpeg)\n\
          \-scale $help(scale)\n\
          \-shm \t$help(shm)\n\
          \-single\n\
          \-squared\n\
          \-sqrt\n\
          \-source \t<filename>\n\
          \-tile \t$help(tile)\n\
          \-title \t<name>\n\
          \-unix \t\t<name>\n\
          \-unix_only\n\
          \-url \t\t<url>\n\
          \-version \t$help(version)\n\
          \-view \t$help(view)\n\
          \-visual \t\[pseudocolor8|truecolor8|truecolor16|truecolor24\]\n\
          \-vo \t$help(vo)\n\
          \-wcs \t$help(wcs)\n\
          \-web \t$help(web)\n\
          \-xpa \t$help(xpa)\n\
          \-zmax\n\
          \-zscale\n\
          \-zoom \t$help(zoom)\n
"
    set help(email) "If you encounter any problems or have suggestions with ds9, please contact us at: 

saord@cfa.harvard.edu
http://hea-www.harvard.edu/RD/ds9/

William Joye
Eric Mandel
Smithsonian Astrophysical Observatory
Garden St.
Cambridge, MA 02138 USA"

    set help(shortcuts) " DS9 version $ds9(version)\n\n\
          Key Stroke       Description\n\
          ----------       -----------\n\
          TAB              Goto next frame\n\
          DELETE           Deletes selected regions\n\
          C                Print Mouse Coordinates and Pixel value.\n\
          F                Toggles Infobox freeze\n\
          I                Set include property for region\n\
          E                Set exclude property for region\n\
          S                Set source property for region\n\
          B                Set background property for region\n\
          +                Goto next 3D Fits Slice\n\
          -                Goto previous 3D Fits Slice\n\
          Up Arrow         Move selected regions/cursor up one pixel.\n\
          Right Arrow      Move selected regions/cursor right one pixel.\n\
          Left Arrow       Move selected regions/cursor left one pixel.\n\
          Down Arrow       Move selected regions/cursor down one pixel.\n\
          Shift-Drag       Select all regions within the indicated region.\n\
          Control-Drag     Selected ANNULUS Regions, will create new radii.\n
"
}

