// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <stdlib.h>
#include <limits.h>

#include "tcl.h"
#include <Xlib.h>
#include <Xutil.h>

#include "colorbarrgbtrue.h"
#include "util.h"

ColorbarRGBTrueColor::ColorbarRGBTrueColor(Tcl_Interp* i, Tk_Canvas c,
					   Tk_Item* item) 
  : ColorbarRGB(i, c, item)
{
  colorCount = 0;
  xmap = NULL;
}

ColorbarRGBTrueColor::~ColorbarRGBTrueColor()
{
  if (xmap)
    XDestroyImage(xmap);
}

void ColorbarRGBTrueColor::invalidPixmap()
{
  Widget::invalidPixmap();

  if (xmap)
    XDestroyImage(xmap);
  xmap = NULL;
}

int ColorbarRGBTrueColor::updatePixmap(const BBox& bb)
{
  // create a valid pixmap if needed
  // bb is in canvas coords

  if (!pixmap || !xmap) {
    int& width = options->width;
    int& height = options->height;
    
    // pixmap

    if (!pixmap)
      if (!(pixmap = Tk_GetPixmap(display, Tk_WindowId(tkwin), 
				  width, height, depth))) {
	cerr << "ColorbarRGBTrueColor Internal Error: Unable to Create Pixmap" 
	     << endl;
	exit(1);
      }

    // xmap

    if (!xmap) {
      if (!(xmap = XGETIMAGE(display, pixmap, 0, 0, width, height, 
			     AllPlanes, ZPixmap))){
	cerr << "ColorbarRGBTrueColor Internal Error: Unable to Create XImage" 
	     << endl;
	exit(1);
      }

      updateColors();
    }
  }

  return TCL_OK;
}

int ColorbarRGBTrueColor::initColormapForReal()
{
  colorCells = new unsigned char[colorCount*3];

 // needed to initialize colorCells
  reset();

  return TCL_OK;
}

void ColorbarRGBTrueColor::updateColorCells()
{
  // fill rgb table
  // note: its filled bgr to match XImage

  for(int i=0; i<colorCount; i++) {
    int idr = calcContrastBias(i,bias[0],contrast[0]);
    int idg = calcContrastBias(i,bias[1],contrast[1]);
    int idb = calcContrastBias(i,bias[2],contrast[2]);

    colorCells[i*3]   = (int)(256.*idr/colorCount);
    colorCells[i*3+1] = (int)(256.*idg/colorCount);
    colorCells[i*3+2] = (int)(256.*idb/colorCount);
  }
}
