// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __basecircle_h__
#define __basecircle_h__

#include "basemarker.h"

class BaseCircle : public BaseMarker {
 protected:
  double* radii;

 private:
  virtual void render(Drawable, const Matrix&, double, RenderMode);

 public:
  BaseCircle(const BaseCircle&);
  BaseCircle(FrameBase* p, const Vector& ctr, double r,
	     const char* clr, int w, const char* f, 
	     const char* t, unsigned short prop, const char* c,
	     const List<Tag>& tag);
  
  virtual ~BaseCircle();

  virtual Marker* dup() =0;
  virtual void updateBBox() =0;
  virtual void updateCoords(const Matrix&);

  virtual void rotateBegin() {}
  virtual void rotate(const Vector& v, int h) {}
  virtual void rotateEnd() {}

  virtual void ps(int);
  int isIn(const Vector&);

  virtual void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
  virtual void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char) {}
  virtual void listSAOimage(ostream&,CoordSystem,SkyFrame,SkyFormat,char) {}
  virtual void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char) {}
};

#endif
