#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc 2MASSDialog {} {
    global 2mass
    global menu

    if [winfo exists $2mass(top)] {
	raise $2mass(top)
	return
    }

    set w $2mass(top)
    IMGSVRInit 2mass "2MASS Server" 2MASSExec 2MASSAck 2MASSUpdate

    # custom dialog
    label $w.param.wtitle -text "Radius"
    entry $w.param.w -textvariable 2mass(radius) -width 14
    label $w.param.format -textvariable 2mass(rformat) \
	-width 10 -relief groove

    grid $w.param.wtitle $w.param.w x x $w.param.format \
	-padx 4 -pady 1 -sticky w

    # menu
    IMGSVRFileMenu 2mass
    AREditMenu 2mass
    NSVRServerMenu 2mass
    $2mass(mb) add cascade -label Survey -menu $2mass(mb).survey
    IMGSVRPrefsMenu 2mass

    menu $2mass(mb).survey -tearoff 0 -selectcolor $menu(selectcolor)
    $2mass(mb).survey add radiobutton -label "2MASS (J Band)" \
	-variable 2mass(survey) -value j
    $2mass(mb).survey add radiobutton -label "2MASS (H Band)" \
	-variable 2mass(survey) -value h
    $2mass(mb).survey add radiobutton -label "2MASS (K Band)" \
	-variable 2mass(survey) -value k

    IMGSVRUpdate 2mass 1
}

proc 2MASSDestroyDialog {} {
    global 2mass

    set varname 2mass
    IMGSVRDestroy $varname
}

proc 2MASSExec {} {
    global 2mass

    if {$2mass(save)} {
	set 2mass(fn) [SaveFileDialog 2massfbox]
	if {$2mass(fn) == {}} {
	    return
	}

    } else {
	set 2mass(fn) [tmpnam 2mass ".fits.gz"]
    }

    if {$2mass(radius)>3600} {
	set 2mass(radius) 3600
    }
    set foo "$2mass(x) $2mass(y)"
    set query [http::formatQuery objstr $foo size $2mass(radius) band $2mass(survey)]

    IMGSVRLoad 2mass "http://irsa.ipac.caltech.edu/cgi-bin/Oasis/2MASSImg/nph-2massimg" $query
}

proc 2MASSAck {} {
set msg {Acknowledgements for the 2MASS 

This publication makes use of data products from the Two Micron All
Sky Survey, which is a joint project of the University of
Massachusetts and the Infrared Processing and Analysis
Center/California Institute of Technology, funded by the National
Aeronautics and Space Administration and the National Science
Foundation.
}

    SimpleTextDialog 2massack Acknowledgement 80 40 insert top $msg
}

proc 2MASSUpdate {} {
    global 2mass
    global current

    set size [$current(frame) get fits size $2mass(system) $2mass(rformat)]
    set 2mass(radius) [lindex $size 0]
}

proc Process2MASSCmd {varname iname flag fcName} {
    upvar $varname var
    upvar $iname i
    upvar $fcName fc

    global current
    global 2mass

    # do we have a rgb frame
    if {[$current(frame) get type] == "rgb"} {
	set base 0
    } else {
	set base 1
    }

    switch -- [string tolower [lindex $var $i]] {
	survey {
	    incr i
	    set 2mass(survey) [lindex $var $i]
	}
	size {
	    incr i
	    set 2mass(radius) [lindex $var $i]
	}
	coord {
	    if {$flag} {
		MultiLoad fc
	    }
	    incr i
	    set 2mass(x) [lindex $var $i]
	    incr i
	    set 2mass(y) [lindex $var $i]
	    2MASSDoItCmd
	}
	x {
	    incr i
	    set 2mass(x) [lindex $var $i]
	}
	y {
	    incr i
	    set 2mass(y) [lindex $var $i]
	}
	name {
	    if {$flag && $base} {
		MultiLoad fc
	    }
	    incr i
	    set 2mass(name) [lindex $var $i]
	    2MASSDoItCmd
	}
	default {
	    if {$flag && $base} {
		MultiLoad fc
	    }
	    set 2mass(name) [lindex $var $i]
	    2MASSDoItCmd
	}
    }
}

proc 2MASSDoItCmd {} {
    global 2mass

    if {$2mass(radius) == ""} {
	set 2mass(radius) 900
    }
    set 2mass(mode) current
    
    2MASSDialog
    IMGSVRApply 2mass 1
}
