#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ButtonCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair begin motion canvas $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		switch -- $ds9(display,mode) {
		    single {$f crosshair $crosshair(lock) $coord}
		    tile {$f crosshair begin motion $crosshair(lock) $coord}
		    blink {}
		}
	    }
	}
    }
}

proc MotionCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair motion canvas $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		switch -- $ds9(display,mode) {
		    single {$f crosshair $crosshair(lock) $coord}
		    tile {$f crosshair motion $crosshair(lock) $coord}
		    blink {}
		}
	    }
	}
    }
}

proc ReleaseCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair canvas $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		$f crosshair $crosshair(lock) $coord
	    }
	}
    }
}

proc ArrowKeyCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair warp $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		$f crosshair $crosshair(lock) $coord 
	    }
	}
    }
}

proc ProcessCrosshairCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global current
    global ds9
    global crosshair

    set x [lindex $var 0]
    set y [lindex $var 1]
    set sys [lindex $var 2]
    set sky [lindex $var 3]
    incr i 3

    switch -- $sys {
	{} {set sys physical}
	fk4 -
	fk5 -
	icrs -
	galactic -
	ecliptic {set sky $sys; set sys wcs}
    }

    set ds9(mode) crosshair
    ChangeMode

    if {$current(frame) != {}} {
	$current(frame) crosshair $sys $sky $x $y
	set coord [$current(frame) get crosshair canvas]
	UpdateInfoBox $current(frame) \
	    [lindex $coord 0] [lindex $coord 1] canvas
    }
}
