#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc EpandaDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base panda rect dialog
    MarkerBasePandaRectDialog $frame $id 275 150
}

# actions

proc EpandaClose {frame id} {
    MarkerBasePandaRectClose $frame $id
}

proc EpandaApply {frame id} {
    MarkerBasePandaRectApply $frame $id
}

proc EpandaGenerate {frame id} {
    MarkerBaseAnnulusGenerateEllipse $frame $id
    MarkerBasePandaGenerateAngles $frame $id
}

# callbacks

proc EpandaCoordCB {frame id} {
    MarkerBasePandaRectCoordCB $frame $id
}

proc EpandaEditCB {frame id} {
    MarkerBasePandaRectEditCB $frame $id
}

proc EpandaDistCB {frame id} {
    MarkerBasePandaDistCB $frame $id
}

proc EpandaDefaultDialog {} {
    MarkerBasePandaRectDefaultDialog epanda
}
