#! /bin/sh

if [ "$2" = "val" ]; then
#    CMD="valgrind --leak-check=yes --show-reachable=yes ../ds9val"
    CMD="valgrind --leak-check=yes ../ds9val"
    XPA=ds9val
else
    CMD=../ds9
    XPA=ds9
fi

# functions

testit () {
    echo "Test $1 $2 $3 $4 $5"
    xpaset -p $XPA regions format $1
    xpaset -p $XPA regions system $2
    xpaset -p $XPA regions sky $3
    xpaset -p $XPA regions skyformat $4
    xpaset -p $XPA regions file $5
    xpaset -p $XPA regions save ${5}.out
    sleep .5
    xpaset -p $XPA regions deleteall

    o=`diff $5 ${5}.out`
    if [ "$o" = "" ]
    then
	echo "PASSED"
    else
        echo "FAILED"
	echo "$o"
    fi
    rm -f ${5}.out
}

testit2 () {
    echo "Test $1 $2 $3 $4 $5 $6"
    xpaset -p $XPA regions format $1
    xpaset -p $XPA regions system $2
    xpaset -p $XPA regions sky $3
    xpaset -p $XPA regions skyformat $4
    xpaset -p $XPA regions file $5
    xpaset -p $XPA regions save ${5}.out
    sleep .5
    xpaset -p $XPA regions deleteall

    o=`diff $6 ${5}.out`
    if [ "$o" = "" ]
    then
	echo "PASSED"
    else
        echo "FAILED"
	echo "$o"
    fi
    rm -f ${5}.out
}

testit3 () {
    echo "Test $1 $2 $3 $4 $5"
    xpaset -p $XPA regions format $1
    xpaset -p $XPA regions system $2
    xpaset -p $XPA regions sky $3
    xpaset -p $XPA regions skyformat $4
    xpaset -p $XPA regions file $5
    sleep .5
    xpaset -p $XPA regions deleteall
    echo "PASSED"
}

echo "Starting DS9..."
if [ `xpaaccess $XPA` = no ]; then
    $CMD&

    i=1
    while [ "$i" -le 30 ]
    do
        sleep 2
        if [ `xpaaccess $XPA` = yes ]
        then
	    break
        fi

        i=`expr $i + 1`
    done
fi

echo "Loading Data..."
xpaset -p $XPA file img16.fits

if [ "$1" = "ds9" -o  -z "$1" ]; then
echo
echo "Testing DS9 Format..."
testit ds9 image fk5 degrees ds9.image.reg
testit ds9 physical fk5 degrees ds9.physical.reg
testit ds9 wcs fk4 degrees ds9.fk4.reg
testit ds9 wcs fk4 sexagesimal ds9.fk4.hms.reg
testit ds9 wcs fk5 degrees ds9.fk5.reg
testit ds9 wcs fk5 sexagesimal ds9.fk5.hms.reg
testit ds9 wcs icrs degrees ds9.icrs.reg
testit ds9 wcs icrs sexagesimal ds9.icrs.hms.reg
testit ds9 wcs galactic degrees ds9.galactic.reg
testit ds9 wcs galactic sexagesimal ds9.galactic.hms.reg
testit ds9 wcs ecliptic degrees ds9.ecliptic.reg
testit ds9 wcs ecliptic sexagesimal ds9.ecliptic.hms.reg
fi

if [ "$1" = "ds9strip" -o  -z "$1" ]; then
echo
xpaset -p $XPA regions strip yes

echo "Testing ds9 strip Regions Format..."
testit2 ds9 image fk5 degrees ds9.image.reg ds9.image.strip.reg
testit2 ds9 physical fk5 degrees ds9.physical.reg ds9.physical.strip.reg
testit2 ds9 wcs fk4 degrees ds9.fk4.reg ds9.fk4.strip.reg
testit2 ds9 wcs fk4 sexagesimal ds9.fk4.hms.reg ds9.fk4.hms.strip.reg
testit2 ds9 wcs fk5 degrees ds9.fk5.reg ds9.fk5.strip.reg
testit2 ds9 wcs fk5 sexagesimal ds9.fk5.hms.reg ds9.fk5.hms.strip.reg
testit2 ds9 wcs icrs degrees ds9.icrs.reg ds9.icrs.strip.reg
testit2 ds9 wcs icrs sexagesimal ds9.icrs.hms.reg ds9.icrs.hms.strip.reg
testit2 ds9 wcs galactic degrees ds9.galactic.reg ds9.galactic.strip.reg
testit2 ds9 wcs galactic sexagesimal ds9.galactic.hms.reg ds9.galactic.hms.strip.reg
testit2 ds9 wcs ecliptic degrees ds9.ecliptic.reg ds9.ecliptic.strip.reg
testit2 ds9 wcs ecliptic sexagesimal ds9.ecliptic.hms.reg ds9.ecliptic.hms.strip.reg

xpaset -p $XPA regions strip no
fi

if [ "$1" = "3.0" -o  -z "$1" ]; then
echo
echo "Testing ds9 3.0 Regions Format..."
testit2 ds9 image fk5 degrees ds9.image.3.0.reg ds9.image.reg
testit2 ds9 physical fk5 degrees ds9.physical.3.0.reg ds9.physical.reg
testit2 ds9 wcs fk4 degrees ds9.fk4.3.0.reg ds9.fk4.reg
testit2 ds9 wcs fk4 sexagesimal ds9.fk4.hms.3.0.reg ds9.fk4.hms.reg
testit2 ds9 wcs fk5 degrees ds9.fk5.3.0.reg ds9.fk5.reg
testit2 ds9 wcs fk5 sexagesimal ds9.fk5.hms.3.0.reg ds9.fk5.hms.reg
testit2 ds9 wcs icrs degrees ds9.icrs.3.0.reg ds9.icrs.reg
testit2 ds9 wcs icrs sexagesimal ds9.icrs.hms.3.0.reg ds9.icrs.hms.reg
testit2 ds9 wcs galactic degrees ds9.galactic.3.0.reg ds9.galactic.reg
testit2 ds9 wcs galactic sexagesimal ds9.galactic.hms.3.0.reg ds9.galactic.hms.reg
testit2 ds9 wcs ecliptic degrees ds9.ecliptic.3.0.reg ds9.ecliptic.reg
testit2 ds9 wcs ecliptic sexagesimal ds9.ecliptic.hms.3.0.reg ds9.ecliptic.hms.reg
fi

if [ "$1" = "ciao" -o  -z "$1" ]; then
echo
echo "Testing CIAO Format..."
testit ciao physical fk5 degrees ciao.physical.reg
testit ciao wcs fk5 sexagesimal ciao.fk5.reg
fi

if [ "$1" = "saotng" -o  -z "$1" ]; then
echo
echo "Testing SAOtng Format..."
testit saotng image fk5 degrees saotng.image.reg
testit saotng wcs fk4 degrees saotng.fk4.reg
testit saotng wcs fk4 sexagesimal saotng.fk4.hms.reg
testit saotng wcs fk5 degrees saotng.fk5.reg
testit saotng wcs fk5 sexagesimal saotng.fk5.hms.reg
testit saotng wcs icrs degrees saotng.icrs.reg
testit saotng wcs icrs sexagesimal saotng.icrs.hms.reg
testit saotng wcs galactic degrees saotng.galactic.reg
testit saotng wcs galactic sexagesimal saotng.galactic.hms.reg
testit saotng wcs ecliptic degrees saotng.ecliptic.reg
testit saotng wcs ecliptic sexagesimal saotng.ecliptic.hms.reg
fi

if [ "$1" = "pros" -o  -z "$1" ]; then
echo
echo "Testing IRAF Pros Format..."
testit pros image fk5 degrees pros.image.reg
testit pros physical fk5 degrees pros.physical.reg
testit pros wcs fk4 degrees pros.fk4.reg
testit pros wcs fk4 sexagesimal pros.fk4.hms.reg
testit pros wcs fk5 degrees pros.fk5.reg
testit pros wcs fk5 sexagesimal pros.fk5.hms.reg
testit pros wcs galactic degrees pros.galactic.reg
testit pros wcs galactic sexagesimal pros.galactic.hms.reg
testit pros wcs ecliptic degrees pros.ecliptic.reg
testit pros wcs ecliptic sexagesimal pros.ecliptic.hms.reg
fi

if [ "$1" = "saoimage" -o  -z "$1" ]; then
echo
echo "Testing SAOimage Format..."
testit saoimage image fk5 degrees saoimage.reg
fi

if [ "$1" = "xy" -o  -z "$1" ]; then
echo
echo "Testing X Y Format..."
testit xy image fk5 degrees xy.image.reg
testit xy physical fk5 degrees xy.physical.reg
testit xy wcs fk4 degrees xy.fk4.reg
testit xy wcs fk4 sexagesimal xy.fk4.hms.reg
testit xy wcs fk5 degrees xy.fk5.reg
testit xy wcs fk5 sexagesimal xy.fk5.hms.reg
testit xy wcs icrs degrees xy.icrs.reg
testit xy wcs icrs sexagesimal xy.icrs.hms.reg
testit xy wcs galactic degrees xy.galactic.reg
testit xy wcs galactic sexagesimal xy.galactic.hms.reg
testit xy wcs ecliptic degrees xy.ecliptic.reg
testit xy wcs ecliptic sexagesimal xy.ecliptic.hms.reg
fi

if [ "$1" = "windows" -o  -z "$1" ]; then
echo
echo "Testing Windows /CR/NL Format..."
testit3 ds9 physical fk5 degrees ds9.physical.windows.reg
testit3 ciao physical fk5 degrees ciao.physical.windows.reg
testit3 saotng image fk5 degrees saotng.image.windows.reg
testit3 saoimage image fk5 degrees saoimage.windows.reg
testit3 pros physical fk5 degrees pros.physical.windows.reg
testit3 xy physical fk5 degrees xy.physical.windows.reg
fi

if [ "$1" = "composite" -o  -z "$1" ]; then
echo
echo "Loading Composite Data..."
testit ds9 wcs fk5 degrees ds9.composite.reg
fi

if [ "$1" = "fits" -o  -z "$1" ]; then
echo
echo "Testing FITS Regions Format..."
testit2 ds9 physical fk5 degrees ds9.reg.fits ds9.fits.reg
fi

if [ "$1" = "mosaic" -o  -z "$1" ]; then
echo
echo "Loading Mosaic Data..."
xpaset -p $XPA frame clear
xpaset -p $XPA file mosaicimage mosaicimage.fits
xpaset -p $XPA zoom .5

echo
echo "Testing DS9 Mosaic Format..."
testit ds9 image fk5 degrees ds9.mosaic.image.reg
testit ds9 physical fk5 degrees ds9.mosaic.physical.reg
testit ds9 wcs fk4 degrees ds9.mosaic.fk4.reg
testit ds9 wcs fk4 sexagesimal ds9.mosaic.fk4.hms.reg
testit ds9 wcs fk5 degrees ds9.mosaic.fk5.reg
testit ds9 wcs fk5 sexagesimal ds9.mosaic.fk5.hms.reg
testit ds9 wcs icrs degrees ds9.mosaic.icrs.reg
testit ds9 wcs icrs sexagesimal ds9.mosaic.icrs.hms.reg
testit ds9 wcs galactic degrees ds9.mosaic.galactic.reg
testit ds9 wcs galactic sexagesimal ds9.mosaic.galactic.hms.reg
testit ds9 wcs ecliptic degrees ds9.mosaic.ecliptic.reg
testit ds9 wcs ecliptic sexagesimal ds9.mosaic.ecliptic.hms.reg
fi

if [ "$1" = "mosaic3.0" -o  -z "$1" ]; then
echo
echo "Loading Mosaic Data..."
xpaset -p $XPA frame clear
xpaset -p $XPA file mosaicimage mosaicimage.fits
xpaset -p $XPA zoom .5

echo
echo "Testing DS9 Mosaic 3.0 Format..."
testit2 ds9 image fk5 degrees ds9.mosaic.image.3.0.reg ds9.mosaic.image.reg
testit2 ds9 physical fk5 degrees ds9.mosaic.physical.3.0.reg ds9.mosaic.physical.reg
testit2 ds9 wcs fk4 degrees ds9.mosaic.fk4.3.0.reg ds9.mosaic.fk4.reg
testit2 ds9 wcs fk4 sexagesimal ds9.mosaic.fk4.hms.3.0.reg ds9.mosaic.fk4.hms.reg
testit2 ds9 wcs fk5 degrees ds9.mosaic.fk5.3.0.reg ds9.mosaic.fk5.reg
testit2 ds9 wcs fk5 sexagesimal ds9.mosaic.fk5.hms.3.0.reg ds9.mosaic.fk5.hms.reg
testit2 ds9 wcs icrs degrees ds9.mosaic.icrs.3.0.reg ds9.mosaic.icrs.reg
testit2 ds9 wcs icrs sexagesimal ds9.mosaic.icrs.hms.3.0.reg ds9.mosaic.icrs.hms.reg
testit2 ds9 wcs galactic degrees ds9.mosaic.galactic.3.0.reg ds9.mosaic.galactic.reg
testit2 ds9 wcs galactic sexagesimal ds9.mosaic.galactic.hms.3.0.reg ds9.mosaic.galactic.hms.reg
testit2 ds9 wcs ecliptic degrees ds9.mosaic.ecliptic.3.0.reg ds9.mosaic.ecliptic.reg
testit2 ds9 wcs ecliptic sexagesimal ds9.mosaic.ecliptic.hms.3.0.reg ds9.mosaic.ecliptic.hms.reg
fi

if [ "$1" = "linear" -o  -z "$1" ]; then
echo
echo "Loading Linear Data..."
xpaset -p $XPA scale minmax
xpaset -p $XPA frame clear
xpaset -p $XPA file mosaicimage ds9_8amp_2x2.fits
xpaset -p $XPA zoom .5

echo
echo "Testing DS9 Linear Format..."
testit ds9 wcs fk5 degrees ds9.linear.wcs.reg
testit ds9 wcsa fk5 degrees ds9.linear.wcsa.reg
testit ds9 wcsc fk5 degrees ds9.linear.wcsc.reg
testit ds9 wcsd fk5 degrees ds9.linear.wcsd.reg
testit ds9 wcsi fk5 degrees ds9.linear.wcsi.reg
testit ds9 wcsp fk5 degrees ds9.linear.wcsp.reg
fi

if [ "$1" = "linear3.0" -o  -z "$1" ]; then
echo
echo "Loading Linear 3.0 Data..."
xpaset -p $XPA scale minmax
xpaset -p $XPA frame clear
xpaset -p $XPA file mosaicimage ds9_8amp_2x2.fits
xpaset -p $XPA zoom .5

echo
echo "Testing DS9 Linear Format..."
testit2 ds9 wcs fk5 degrees ds9.linear.wcs.3.0.reg ds9.linear.wcs.reg
testit2 ds9 wcsa fk5 degrees ds9.linear.wcsa.3.0.reg ds9.linear.wcsa.reg
testit2 ds9 wcsc fk5 degrees ds9.linear.wcsc.3.0.reg ds9.linear.wcsc.reg
testit2 ds9 wcsd fk5 degrees ds9.linear.wcsd.3.0.reg ds9.linear.wcsd.reg
testit2 ds9 wcsi fk5 degrees ds9.linear.wcsi.3.0.reg ds9.linear.wcsi.reg
testit2 ds9 wcsp fk5 degrees ds9.linear.wcsp.3.0.reg ds9.linear.wcsp.reg
fi

echo
echo "Done"

if [ -z "$1" ]; then
xpaset -p $XPA quit
fi
