// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorbarrgbtrue_h__
#define __colorbarrgbtrue_h__

#include "colorbarrgb.h"

class ColorbarRGBTrueColor : public ColorbarRGB {
protected:
  XImage* xmap;

protected:
  int updatePixmap(const BBox&);   // renders image/graphics into pixmap
  void invalidPixmap();           // update pixmap and xmap

  int initColormapForReal();
  void updateColorCells();

  void psLevel1(PSColorSpace, int, int, float);
  void psLevel2(PSColorSpace, int, int, float);

public:
  ColorbarRGBTrueColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~ColorbarRGBTrueColor();

  void setColormapWindowCmd(char*) {}
};

#endif
