// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __intensity_h__
#define __intensity_h__

#include "colormap.h"
#include "rgb.h"
#include "itt.h"

class LASCColorMap : public ColorMapInfo {
private:
  int size;
  RGBColor* colors;
  ITT* itt;

private:
  unsigned char getColorChar(int, int, float (RGBColor::*)());
  unsigned short getColorShrt(int, int, float (RGBColor::*)());

public:
  LASCColorMap();
  ~LASCColorMap();

  void setITT(ITT* t);

  int load();
  int save(const char*);

  unsigned char getRedChar(int i, int count) 
    {return getColorChar(i,count,&RGBColor::getRed);}
  unsigned char getGreenChar(int i, int count) 
    {return getColorChar(i,count,&RGBColor::getGreen);}
  unsigned char getBlueChar(int i, int count) 
    {return getColorChar(i,count,&RGBColor::getBlue);}

  unsigned short getRedShrt(int i, int count) 
    {return getColorShrt(i,count,&RGBColor::getRed);}
  unsigned short getGreenShrt(int i, int count) 
    {return getColorShrt(i,count,&RGBColor::getGreen);}
  unsigned short getBlueShrt(int i, int count) 
    {return getColorShrt(i,count,&RGBColor::getBlue);}

  friend ostream& operator<<(ostream&, LASCColorMap&);
};

#endif

