// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "baseline.h"
#include "framebase.h"
#include "fitsimage.h"
#include "util.h"

BaseLine::BaseLine(const BaseLine& a) : Marker(a)
{
  p1 = a.p1;
  p2 = a.p2;
}

BaseLine::BaseLine(FrameBase* p, const Vector& ptr1, const Vector& ptr2,
	   const char* clr, int wth, const char* fnt, const char* txt,
	   unsigned short prop, const char* cmt, 
	   const List<Tag>& tg, const List<CallBack>& cb) 
  : Marker(p, ptr1, 0, clr, wth, fnt, txt, prop, cmt, tg, cb)
{
  p1 = ptr1;
  p2 = ptr2;
}

void BaseLine::updateCoords(const Matrix& mx)
{
  p1*=mx;
  p2*=mx;

  updateBBox();
  Marker::updateCoords(mx);
}

void BaseLine::move(const Vector& v)
{
  p1+=v;
  p2+=v;

  updateBBox();
  doCallBack(CallBack::MOVECB);
}

void BaseLine::moveTo(const Vector& v)
{
  // v is the new location of the center
  Vector diff = v - center;
  p1+=diff;
  p2+=diff;

  updateBBox();
  doCallBack(CallBack::MOVECB);
}

void BaseLine::edit(const Vector& v, int h)
{
  switch (h) {
  case 1:
    p1 = v;
    break;
  case 2:
    p2 = v;
    break;
  }

  updateBBox();
  doCallBack(CallBack::EDITCB);
}

void BaseLine::setPoints(const Vector& v1, const Vector& v2)
{
  p1 = v1;
  p2 = v2;

  updateBBox();
  doCallBack(CallBack::EDITCB);
}

// special composite funtionallity

void BaseLine::setComposite(const Matrix& mx, double aa)
{
  p1 *= mx;
  p2 *= mx;

  updateBBox();
}
