// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "basepanda.h"
#include "framebase.h"
#include "fitsimage.h"
#include "util.h"

BasePanda::BasePanda(const BasePanda& a)
{
  numAngles_ = a.numAngles_;
  angles_ = new double[numAngles_];
  for (int i=0; i<numAngles_; i++)
    angles_[i] = a.angles_[i];
}

BasePanda::BasePanda(double a1, double a2, int an)
{
  numAngles_ = an+1;
  angles_ = new double[numAngles_];

  if (a2<=a1)
    a2 += 2*M_PI;

  for (int i=0; i<numAngles_; i++)
    angles_[i] = i*(a2-a1)/an+a1;

  sortAngles();
}

BasePanda::BasePanda(int an, double* a)
{
  numAngles_ = an;
  angles_ = new double[numAngles_];

  for (int i=0; i<numAngles_; i++)
    angles_[i] = a[i];

  sortAngles();
}

BasePanda::~BasePanda()
{
  if (angles_)
    delete [] angles_;
}


void BasePanda::sortAngles()
{
  for (int i=0; i<numAngles_; i++) {
    if (angles_[i] > 0) 
      while(angles_[i] > 2*M_PI)
	angles_[i] -= 2*M_PI;
    else
      while(angles_[i] < 0)
	angles_[i] += 2*M_PI;
  }  

  if (numAngles_>1 && angles_[0] == 0 && angles_[numAngles_-1] == 0)
    angles_[numAngles_-1] += 2*M_PI;
}

void BasePanda::setAngles(double a1, double a2, int an)
{
  numAngles_ = an+1;
  if (angles_)
    delete [] angles_;
  angles_ = new double[numAngles_];

  if (a2<=a1)
    a2 += 2*M_PI;
  for (int i=0; i<numAngles_; i++)
    angles_[i] = i*(a2-a1)/an+a1;

  sortAngles();
}

void BasePanda::setAngles(int an, const double* a)
{
  numAngles_ = an;
  if (angles_)
    delete [] angles_;
  angles_ = new double[numAngles_];

  for (int i=0; i<numAngles_; i++)
    angles_[i] = a[i];
  sortAngles();
}

void BasePanda::addAngle(double aa)
{
  // we need to insert into the next to the last location
  // new size array
  double* old = angles_;
  angles_ = new double[numAngles_+1];

  // copy old values
  for (int i=0; i<numAngles_; i++)
    angles_[i] = old[i];

  // save last
  angles_[numAngles_] = old[numAngles_-1];

  // delete old
  if (old)
    delete [] old;

  // new size on next to last
  angles_[numAngles_-1] = aa;

  numAngles_++;
}

void BasePanda::deleteAngle(int hh)
{
  // new angles array
  double* old = angles_;
  angles_ = new double[numAngles_-1];

  // copy up to angles in question
  for (int i=0; i<hh; i++)
    angles_[i] = old[i];

  // copy remainder
  for (int i=hh; i<numAngles_-1; i++)
    angles_[i] = old[i+1];

  if (old)
    delete [] old;
  numAngles_--;
}

// this is special version, that allows 0-360
double BasePanda::radToDeg(double r)
{
  double d = 180. * r / M_PI;
 
  if (d > 0) 
    while(d > 360)
      d -= 360.;
  else
    while(d < 0)
      d += 360.;
 
  return d;
}

