// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __contourscale_h__
#define __contourscale_h__

#include <iostream>
using namespace std;

class ContourScale {
protected:
  float* level_;
  int size_;

public:
  ContourScale(int);
  ContourScale(int, float*);
  virtual ~ContourScale();

  int size() {return size_;}
  float level(int i) {return level_[i];}

  friend ostream& operator<<(ostream&, const ContourScale&);
};

class LinearContourScale : public ContourScale {
public:
  LinearContourScale(int, float, float);
};

class LogContourScale : public ContourScale {
public:
  LogContourScale(int, float, float);
};

class SquaredContourScale : public ContourScale {
public:
  SquaredContourScale(int, float, float);
};

class SqrtContourScale : public ContourScale {
public:
  SqrtContourScale(int, float, float);
};

class HistEquContourScale : public ContourScale {
public:
  HistEquContourScale(int, float, float, double*, int);
};

#endif
