// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "framebase.h"
#include "fitsimage.h"
#include "contour.h"
#include "tkpostscript.h"

int FrameBase::postscriptProc(int prepass)
{
  TkPostscriptInfo* psInfo = (TkPostscriptInfo*)(((TkCanvas*)canvas)->psInfo);

  if (!visible)
    return TCL_OK;

  if (prepass)
    return TCL_OK;

  Vector org = psOrigin();

  // Image

  if (*channelFits) {

    // save graphics state
    Tcl_AppendResult(interp, "gsave\n", NULL);

    float scale = psInfo->scale * psResolution / 72.;
    int width = (int)(options->width * scale);
    int height = (int)(options->height * scale);

    // scale
    {
      ostringstream str;
      str << org[0] << ' ' << org[1] << " translate" << endl
	  << 1/scale << ' ' << 1/scale << " scale" << endl
	  << ends;
      Tcl_AppendResult(interp, str.str().c_str(), NULL);
    }

    switch (psLevel) {
    case 1:
      switch (psColorSpace) {
      case BW:
      case GRAY:
	psLevel1(GRAY, width, height, scale);
	break;
      case RGB:
      case CMYK:
	psLevel1(RGB, width, height, scale);
	break;
      }
      break;
    case 2:
      psLevel2(psColorSpace, width, height, scale);
      break;
    }

    // restore gstate
    Tcl_AppendResult(interp, "grestore\n", NULL);
  }

  // Markers & Contours & Grids

  // clip path
  {
    ostringstream str;
    str << org[0]+1 << ' ' << org[1]+1 << ' ' 
    	<< options->width-2 << ' ' << options->height-4
    	<< " rectclip" << endl << ends;
    Tcl_AppendResult(interp, str.str().c_str(), NULL);
  }

  switch (psLevel) {
  case 1:
    switch (psColorSpace) {
    case BW:
    case GRAY:
      psContours(GRAY);
      if (grid)
	grid->ps(GRAY);

      if (showCatalogMarkers)
	psMarkers(&catalogMarkers, GRAY);
      if (showUserMarkers)
	psMarkers(&userMarkers, GRAY);

      if (useCrosshair)
	psCrosshair(GRAY);
      break;
    case RGB:
    case CMYK:
      psContours(RGB);
      if (grid)
	grid->ps(RGB);

      if (showCatalogMarkers)
	psMarkers(&catalogMarkers, RGB);
      if (showUserMarkers)
	psMarkers(&userMarkers, RGB);

      if (useCrosshair)
	psCrosshair(RGB);
      break;
    }
    break;
  case 2:
    psContours(psColorSpace);
    if (grid)
      grid->ps(psColorSpace);

      if (showCatalogMarkers)
	psMarkers(&catalogMarkers, psColorSpace);
      if (showUserMarkers)
	psMarkers(&userMarkers, psColorSpace);

    if (useCrosshair)
      psCrosshair(psColorSpace);
    break;
  }

  return TCL_OK;
}

Matrix FrameBase::psMatrix(float psZoom, int width, int height)
{
  Matrix m;
  if (!isIIS()) {
    // Note: imageCenter() is in IMAGE coords
    Vector center = imageCenter() * imageToData;
    m = Translate(-center) * FlipY() * Translate(center);
  }

  return m *
    Translate(-cursor) *                // translate to cursor position
    orientationMatrix *                 // flip x/y axis about cursor position
    wcsOrientationMatrix *              // flip x/y axis about center
    Scale(zoom_) *                       // scale about cursor position
    Scale(psZoom) *
    Rotate(rotation) *                  // rotate about cursor position
    Rotate(wcsRotation) *               // rotate about center position

    FlipY() *
    Translate(Vector(width,height)/2.);
}

void FrameBase::psContours(PSColorSpace cs)
{
  // render back to front
  // aux contours
  Contour* ptr=auxcontours.tail();
  while (ptr) {
    ptr->ps(cs);
    ptr=ptr->previous();
  }

  // main contour
  if (*currentcontour)
    (*currentcontour)->ps(cs);
}

