// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __util_h__
#define __util_h__

#include <iostream>
using namespace std;

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

#ifndef _WIN32
#define XWARPPOINTER XWarpPointer
#define XGETIMAGE XGetImage
#define XDRAWLINE XDrawLine
#define XDRAWLINES XDrawLines
#define XDRAWARC XDrawArc
#define XDRAWRECTANGLE XDrawRectangle
#define XFILLPOLYGON XFillPolygon
#define XFILLARC XFillArc
#else
#include <xxlib.h>
#define XWARPPOINTER XXWarpPointer
#define XGETIMAGE XXGetImage
#define XDRAWLINE XXDrawLine
#define XDRAWLINES XXDrawLines
#define XDRAWARC XXDrawArc
#define XDRAWRECTANGLE XXDrawRectangle
#define XFILLPOLYGON XXFillPolygon
#define XFILLARC XXFillArc
#endif

extern int lsb();

extern void swap2(char* src, char* dest);
extern void swap4(char* src, char* dest);
extern void swap8(char* src, char* dest);

extern char* dupstr(const char*);
extern char* toLower(const char*);
extern char* toUpper(const char*);

extern double degToRad(double);
extern double radToDeg(double);
extern double hmsToDegree(int, double, double, double);
extern double dmsToDegree(int, double, double, double);
extern double parseDMS(const char*);

extern unsigned char decodeMask(unsigned char, int*);
extern unsigned short decodeMask(unsigned short, int*);
extern int decodeMask(unsigned long);

extern double RGB2Gray(double, double, double);
extern unsigned char RGB2Gray(unsigned char, unsigned char, unsigned char);
extern void RGB2CMYK(unsigned char, unsigned char, unsigned char,
		     unsigned char*, unsigned char*, unsigned char*, 
		     unsigned char*);
extern ostream& psColorGray(const char*, ostream&);
extern ostream& psColorRGB(const char*, ostream&);
extern ostream& psColorCMYK(const char*, ostream&);

extern char* psQuote(const char*);

extern int fCompare(const void*, const void*);
extern int dCompare(const void*, const void*);

#endif
