#! /bin/sh

KillIt () {
    i=1
    while [ "$i" -le 15 ]; do
      sleep 1
      if [ `xpaaccess ds9` = yes ]; then
	  if [ $slow = "1" ]; then
	      sleep 1
	  fi
	  xpaset -p ds9 quit
	  break
      fi
      
      i=`expr $i + 1`
    done
}

DoXPA () {
    echo "$1"
    xpaset -p ds9 scale $4
    xpaset -p ds9 scale mode $5
    xpaset -p ds9 file $2 $3
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

DoSXPA () {
    echo "$1"
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    xpaset -p ds9 file $2 $3 $4
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

DoXPA2 () {
    echo "$1"
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    cat $3 | xpaset ds9 $2 $4
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

StartDS9 () {
    if [ `xpaaccess ds9` = no ]; then
	ds9&

	i=1
	while [ "$i" -le 30 ]
	    do
	    sleep 2
	    if [ `xpaaccess ds9` = yes ]; then
		break
	    fi

	    i=`expr $i + 1`
	done
    fi
}

# slow down?
slow=1
if [ "$1" = "slow" ]; then
    slow=1
    shift
fi

# Fits

if [ "$1" = "fits" -o  -z "$1" ]; then
echo "Testing Fits"

StartDS9
xpaset -p ds9 scale linear
xpaset -p ds9 scale mode zscale

echo "..Bitpix = 8"
xpaset -p ds9 file fits img8.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = 16"
xpaset -p ds9 file fits img16.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = 32"
xpaset -p ds9 file fits img32.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = -32"
xpaset -p ds9 file fits img-32.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = -64"
xpaset -p ds9 file fits img-64.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..BSCALE"
xpaset -p ds9 file fits imgbscale.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..BLANK"
xpaset -p ds9 file fits imgblank.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..NaN"
xpaset -p ds9 file fits imgnan.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..INF"
xpaset -p ds9 file fits imginf.fits
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

xpaset -p ds9 quit
echo "PASSED"

fi

# Command Line

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Testing Command Line File"

echo "..fits"
ds9 -zscale img16.fits &
KillIt

echo "..fits gz"
ds9 -zscale img16.fits.gz &
KillIt

echo "..fits bz2"
ds9 -zscale img32.fits.bz2 &
KillIt

echo "..fits"
ds9 -zscale -fits img16.fits &
KillIt

echo "..sfits"
ds9 -zscale -sfits sfits.hdr sfits.arr &
KillIt

echo "..events table"
ds9 -log table.fits &
KillIt

echo "..events table filter"
ds9 -log table.fits[bin=rawx,rawy] &
KillIt

echo "..healpix table"
ds9 -log wmap.fits &
KillIt

echo "..multiple extension cube"
ds9 -zscale -mecube mosaicimage.fits &
KillIt

echo "..slice"
ds9 -zscale -slice img*.fits &
KillIt

echo "..multiple extension multiple frame"
ds9 -zscale -memf mosaicimage.fits &
KillIt

echo "..mosaic image iraf"
ds9 -zscale -mosaicimage iraf mosaicimage.fits &
KillIt

echo "..mosaic image iraf cube"
ds9 -zscale -mosaicimage iraf naxis4.fits &
KillIt

echo "..mosaic image wcs"
ds9 -zscale -mosaicimage wcs mosaicimage.fits &
KillIt

echo "..mosaic image wcsp"
ds9 -zscale -mosaicimage wcsp ds9_8amp_2x2.fits&
KillIt

echo "..mosaic image wfpc2"
ds9 -zscale -mosaicimage wfpc2 hst.fits &
KillIt

echo "..mosaic iraf"
ds9 -zscale -mosaic iraf mosaicimage.fits &
KillIt

echo "..mosaic iraf cube"
ds9 -zscale -mosaic iraf naxis4.fits &
KillIt

echo "..mosaic wcs"
ds9 -zscale -mosaic wcs mosaicimage.fits &
KillIt

echo "..mosaic wcsp"
ds9 -mosaic wcsp ds9_8amp_2x2.fits &
KillIt

echo "..mosaic wcs sfits"
ds9 -zscale -smosaic wcs sfits.hdr sfits.arr &
KillIt

echo "..rgb cube"
ds9 -rgbcube rgbcube.fits &
KillIt

echo "..rgb cube sfits"
ds9 -srgbcube rgb.hdr rgb.arr &
KillIt

echo "..rgb image"
ds9 -rgbimage rgbimage.fits &
KillIt

echo "..3d"
ds9 -zscale -3d 3d.fits -3d vp 45 30&
sleep 2
KillIt

echo "..url ftp"
ds9 -zscale -url 'ftp://sao-ftp.harvard.edu/pub/rd/ds9/data/img-32.fits' &
KillIt

echo "..url http"
ds9 -zscale -url 'http://hea-www.harvard.edu/saord/download/ds9/data/img-32.fits' &
KillIt

echo "..external"
ds9 -zscale ds9.bar&
KillIt

echo "PASSED"
fi

# Stdin

if [ "$1" = "stdin" -o  -z "$1" ]; then
echo "Testing Stdin File"

echo "..fits"
cat img16.fits | ds9 -zscale - &
KillIt

echo "..fits gz"
cat img16.fits.gz | ds9 -zscale - &
KillIt

echo "..events table"
cat table.fits | ds9 -log - &
KillIt

echo "..events table filter"
cat table.fits | ds9 -log -[bin=rawx,rawy] &
KillIt

echo "..healpix table"
cat wmap.fits | ds9 -log - &
KillIt

echo "..multiple extension cube"
cat mosaicimage.fits | ds9 -zscale -mecube - &
KillIt

echo "..slice"
cat img16.fits | ds9 -zscale -slice - &
KillIt

echo "..mosaic image iraf"
cat mosaicimage.fits | ds9 -zscale -mosaicimage iraf - &
KillIt

echo "..mosaic image iraf cube"
cat naxis4.fits | ds9 -zscale -mosaicimage iraf - &
KillIt

echo "..mosaic image wcs"
cat mosaicimage.fits | ds9 -zscale -mosaicimage wcs - &
KillIt

echo "..mosaic image wcsp"
cat ds9_8amp_2x2.fits | ds9 -mosaicimage wcsp - &
KillIt

echo "..mosaic image wfpc2"
cat hst.fits | ds9 -zscale -mosaicimage wfpc2 - &
KillIt

echo "..mosaic iraf"
cat mosaicimage.fits | ds9 -zscale -mosaic iraf - &
KillIt

echo "..mosaic iraf cube"
cat naxis4.fits | ds9 -zscale -mosaic iraf - &
KillIt

echo "..mosaic wcs"
cat mosaicimage.fits | ds9 -zscale -mosaic wcs - &
KillIt

echo "..mosaic wcsp"
cat ds9_8amp_2x2.fits | ds9 -mosaic wcsp - &
KillIt

echo "..rgb cube"
cat rgbcube.fits | ds9 -rgbcube - &
KillIt

echo "..rgb image"
cat rgbimage.fits | ds9 -rgbimage - &
KillIt

echo "..3d"
cat 3d.fits | ds9 -zscale -3d - -3d vp 45 30&
sleep 2
KillIt

echo "PASSED"
fi

# XPA
if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "Testing XPA File"

StartDS9

DoXPA "..fits" fits img16.fits linear zscale
DoXPA "..fits gz" fits img16.fits.gz linear zscale
DoXPA "..fits bz2" fits img32.fits.bz2 linear zscale
DoSXPA "..sfits" sfits sfits.hdr sfits.arr linear zscale
DoXPA "..events table" fits table.fits log minmax
DoXPA "..events table filter" fits table.fits[bin=rawx,rawy] log minmax
DoXPA "..healpix table" fits wmap.fits linear minmax
DoXPA "..multiple extension cube" mecube mosaicimage.fits linear zscale
DoXPA "..slice" slice img16.fits linear zscale
DoXPA "..multiple extension multiple frame" multiframe mosaicimage.fits linear zscale
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame clear
xpaset -p ds9 single
DoXPA "..mosaicimage iraf" "mosaicimage iraf" mosaicimage.fits linear zscale

DoXPA "..mosaicimage iraf cube" "mosaicimage iraf" naxis4.fits linear zscale
DoXPA "..mosaicimage wcs" "mosaicimage wcs" mosaicimage.fits linear zscale
DoXPA "..mosaicimage wcsp" "mosaicimage wcsp" ds9_8amp_2x2.fits linear zscale
DoXPA "..mosaicimage wfpc2" "mosaicimage wfpc2" hst.fits linear zscale
DoXPA "..mosaic iraf" "mosaic iraf" mosaicimage.fits linear zscale
DoXPA "..mosaic wcs" "mosaic wcs" mosaicimage.fits linear zscale
DoXPA "..mosaic iraf cube" "mosaic iraf" naxis4.fits linear zscale
DoXPA "..mosaic wcsp" "mosaic wcsp" ds9_8amp_2x2.fits linear zscale
DoSXPA "..mosaic wcs sfits" "smosaic wcs" sfits.hdr sfits.arr linear zscale

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p ds9 rgb
DoXPA "..rgbcube" rgbcube rgbcube.fits linear minmax
DoSXPA "..rgbcube sfits" srgbcube rgb.hdr rgb.arr linear minmax
DoXPA "..rgbimage" rgbimage rgbimage.fits linear minmax
xpaset -p ds9 frame delete

xpaset -p ds9 3d
xpaset -p ds9 3d vp 45 30
DoXPA "..3d" fits 3d.fits linear zscale
sleep 2
xpaset -p ds9 frame delete

#DoXPA "..url ftp" url 'ftp://sao-ftp.harvard.edu/pub/rd/ds9/data/img-32.fits' linear zscale
#DoXPA "..url http" url 'http://hea-www.harvard.edu/RD/ds9/data/img-32.fits' linear zscale

DoXPA "..external" "" ds9.bar linear zscale 

xpaset -p ds9 frame delete

xpaset -p ds9 quit
echo "PASSED"
fi

# XPA
if [ "$1" = "xpa2" -o  -z "$1" ]; then
echo "Testing XPA Fits"

StartDS9

echo "Testing Fits"
DoXPA2 "..fits" fits img16.fits foo linear zscale
DoXPA2 "..fits gz" fits img16.fits.gz foo linear zscale
DoXPA2 "..events table" fits table.fits foo log minmax
DoXPA2 "..events table filter" fits table.fits 'table.fits[bin=rawx,rawy]' log minmax
DoXPA2 "..healpix table" fits wmap.fits foo linear minmax
DoXPA2 "..multiple extension cube" "fits mecube" mosaicimage.fits foo linear zscale
DoXPA2 "..slice" "fits slice" img16.fits foo linear zscale
DoXPA2 "..mosaicimage iraf" "fits mosaicimage iraf" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaicimage iraf cube" "fits mosaicimage iraf" naxis4.fits foo linear zscale
DoXPA2 "..mosaicimage wcs" "fits mosaicimage wcs" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaicimage wcsp" "fits mosaicimage wcsp" ds9_8amp_2x2.fits foo linear minmax
DoXPA2 "..mosaicimage wfpc2" "fits mosaicimage wfpc2" hst.fits foo linear zscale
DoXPA2 "..mosaic iraf" "fits mosaic iraf" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic wcs" "fits mosaic wcs" mosaicimage.fits foo linear zscale
DoXPA2 "..mosaic iraf cube" "fits mosaic iraf" naxis4.fits foo linear zscale
DoXPA2 "..mosaic wcsp" "fits mosaic wcsp" ds9_8amp_2x2.fits foo linear minmax

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p ds9 rgb
DoXPA2 "..rgbcube" "fits rgbcube" rgbcube.fits foo linear minmax
DoXPA2 "..rgbimage" "fits rgbimage" rgbimage.fits foo linear minmax
xpaset -p ds9 frame delete

xpaset -p ds9 3d
xpaset -p ds9 3d vp 45 30
DoXPA2 "..3d" fits 3d.fits foo linear zscale
sleep 2
xpaset -p ds9 frame delete

xpaset -p ds9 quit
echo "PASSED"
fi

# Crop

if [ "$1" = "crop" -o  -z "$1" ]; then
echo "Testing Crop Filename"

echo "..fits[xmin:xmax,ymin:ymax]"
ds9 -zscale img16.fits[100:300,100:300] &
KillIt

echo "..fits[*,ymin:ymax]"
ds9 -zscale img16.fits[*,100:300] &
KillIt

echo "..fits[xmin:xmax,*]"
ds9 -zscale img16.fits[100:300,*] &
KillIt

echo "..fits[xdim@xcen,ydim@ycen]"
ds9 -zscale img16.fits[256@400,256@400] &
KillIt

echo "..fits[dim@xcen@ycen]"
ds9 -zscale img16.fits[256@400@400] &
KillIt

echo "..fits[xmin:xmax,ymin:ymax,zmin:zmax]"
ds9 -zscale -3d 3d.fits[100:300,100:300,25:75] -3d vp 45 30&
KillIt

echo "..fits[*,*,zmin:zmax]"
ds9 -zscale -3d 3d.fits[*,*,25:75] -3d vp 45 30&
KillIt

echo "..fits[xdim@xcen,ydim@ycen,zdim@zcen]"
ds9 -zscale -3d 3d.fits[100@150,100@150,25@50] -3d vp 45 30&
KillIt

echo "..fits[dim@xcen@ycen@zcen]"
ds9 -zscale -3d 3d.fits[25@150@150@50] -3d vp 45 30&
KillIt

echo "PASSED"
fi

echo "DONE"
