// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorbarpseudocolor_h__
#define __colorbarpseudocolor_h__

#include "colorbarpseudo.h"
#include "colorbar.h"

class ColorbarPseudoColor : public virtual ColorbarBase, 
  public Colorbar, public ColorbarPseudo {
 protected:
  int privateUsed;           // flag to indicate private allocated
  Colormap colormap;         // current Colormap

 private:
  int initDefaultMap();
  int initPrivateMap();

 protected:
  int initColormap();
  void updateColors();

 public:
  ColorbarPseudoColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);

  void setColormapWindowCmd(char*);
};

#endif
