// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "grid.h"
#include "context.h"
#include "fitsimage.h"

extern "C" {
  #include "ast.h"
}

Grid::Grid(Coord::CoordSystem sys, Coord::SkyFrame sky, 
	   Coord::SkyFormat format, GridType type, const char* v) 
   :  system_(sys), sky_(sky), skyFormat_(format), type_(type)
{
  vars_ = dupstr(v);
}

Grid::~Grid()
{
  if (vars_)
    delete [] vars_;
}
