// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __raytrace_h__
#define __raytrace_h__

#include "list.h"

class RayTrace {
 public:
  double az_;
  double el_;
  float* zbuf_;
  unsigned char* mkzbuf_;

  RayTrace* next_;
  RayTrace* previous_;

 public:
  RayTrace();
  RayTrace(double, double);
  ~RayTrace();

  double az() {return az_;}
  double el() {return el_;}
  float* zbuf() {return zbuf_;}
  unsigned char* mkzbuf() {return mkzbuf_;}

  RayTrace* previous() {return previous_;}
  void setPrevious(RayTrace* r) {previous_ = r;}
  RayTrace* next() {return next_;}
  void setNext(RayTrace* r) {next_ = r;}
};

#endif
