/*
 * AUTHOR: Pedro Lineu Orso                          orso@brturbo.com.br
 *                                                            1998, 2005
 * SARG Squid Analysis Report Generator            http://sarg-squid.org
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"

int vhexclude(char *excludefile, char *ip)
{

   char whost[1024];
   char wip1[1024], wip2[1024];
   char sn1[4], sn2[4], sn3[4];
   char str[strlen(excludefile)];

   whost[0]='\0';
   strcpy(str,excludefile);
   getword(whost,str,' ');
   
   while(strcmp(whost,"*FIM*") != 0) {
      if(strcmp(ip,whost) ==0)
         return(0);

      strcpy(wip1,ip);
      getword(sn1,wip1,'.');
      getword(sn2,wip1,'.');
      getword(sn3,wip1,'.');

      sprintf(wip1,"%s.%s.%s.0",sn1,sn2,sn3);
      sprintf(wip2,"%s.%s.0.0",sn1,sn2);

      if(strstr(whost,wip1) !=0)
         return(0);

      if(strstr(whost,wip2) !=0)
         return(0);

      getword(whost,str,' ');
   }

   return(1);
}


int vuexclude(char *excludeuser, char *user)
{

   char wuser[MAXLEN];

   strcpy(wuser,user);
   strcat(wuser," ");

   if(strstr(excludeuser,wuser) != 0 )
      return(0);

   return(1);
}
