/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

static char **files_done = NULL;
static int nfiles_done = 0;


static void read_log(const char *wentp, FILE *fp_ou)
{
   FILE *fp_in = NULL;
   char bufbsf[255];
   char leks[5], sep[2], res[MAXLEN];
   char mon[10], hour[15];
   char list[MAXLEN];
   char wdata[127];
   int  idata=0;
   int  i;
   char *str;

   if(debug) {
      strcpy(buf,text[7]);
      if (getword(urly,sizeof(urly),buf,' ')<0 || getword(href,sizeof(href),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s string.\n",text[7]);
         exit(1);
      }
      debuga("%s squidGuard %s: %s",urly,buf,wentp);
   }

   /* With squidGuard, you can log groups in only one log file.
      We must parse each log files only one time.  Example :
      dest porn {
          domainlist porn/domains
          urllist    porn/urls
          log file1.log
      }
      dest aggressive {
          domainlist aggressive/domains
          urllist    aggressive/urls
          log file2.log
      }
      dest audio-video {
          domainlist audio-video/domains
          urllist    audio-video/urls
          log file1.log
      }
   */
   for (i=0; i<nfiles_done; i++)
      if (!strcmp(wentp, files_done[i])) return;

   nfiles_done++;
   files_done = realloc(files_done, nfiles_done*sizeof(char *));
   if (!files_done) {
       perror("parse squidGuard - realloc");
       exit(EXIT_FAILURE);
   }
   files_done[nfiles_done-1] = strdup(wentp);
   if (!files_done[nfiles_done-1]) {
       perror("parse squidGuard - strdup");
       exit(EXIT_FAILURE);
   }

   if ((fp_in=fopen(wentp,"r"))==NULL) {
      fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],wentp);
      exit(1);
   }

   while (fgets(buf,sizeof(buf),fp_in) != NULL) {
      if(strlen(SquidGuardLogFormat) > 0) {
         strcpy(bufbsf,SquidGuardLogFormat);
         leks[0]='\0';
         if (getword(leks,sizeof(leks),bufbsf,'#')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wentp);
            exit(1);
         }
         while(strcmp(leks,"end") != 0) {
            if (getword(leks,sizeof(leks),bufbsf,'#')<0 || getword(sep,sizeof(sep),bufbsf,'#')<0) {
               printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wentp);
               exit(1);
            }
            if(strcmp(leks,"end") != 0) {
               if (getword(res,sizeof(res),buf,sep[0])<0) {
                  printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wentp);
                  exit(1);
               }
               if(strcmp(leks,"year") == 0)
                  strcpy(year,res);
               else if(strcmp(leks,"year") == 0)
                  strcpy(year,res);
               else if(strcmp(leks,"mon") == 0)
                  strcpy(mon,res);
               else if(strcmp(leks,"day") == 0)
                  strcpy(day,res);
               else if(strcmp(leks,"hour") == 0)
                  strcpy(hour,res);
               else if(strcmp(leks,"list") == 0)
                  strcpy(list,res);
               else if(strcmp(leks,"ip") == 0)
                  strcpy(ip,res);
               else if(strcmp(leks,"user") == 0)
                  strcpy(user,res);
               else if(strcmp(leks,"url") == 0)
                  strcpy(url,res);
            }
         }
      } else {
         if (getword(year,sizeof(year),buf,'-')<0 || getword(mon,sizeof(mon),buf,'-')<0 ||
             getword(day,sizeof(day),buf,' ')<0 || getword(hour,sizeof(hour),buf,' ')<0 ||
             getword(list,sizeof(list),buf,'/')<0 || getword(list,sizeof(list),buf,'/')<0 ||
             getword(tmp5,sizeof(tmp5),buf,'/')<0 || getword(tmp5,sizeof(tmp5),buf,'/')<0 ||
             getword(url,sizeof(url),buf,' ')<0 ||
             getword(ip,sizeof(ip),buf,'/')<0 || getword(user,sizeof(user),buf,' ')<0 ||
             getword(user,sizeof(user),buf,' ')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wentp);
            exit(1);
          }
          str=strchr(url,'/');
          if (str) *str='\0';
      }

      sprintf(warea,"%s%s%s",year,mon,day);
      sprintf(wdata,"%s%s%s",year,mon,day);
      idata = atoi(wdata);

      if(strcmp(SquidguardIgnoreDate,"on") == 0) {
         if(idata < dfrom || idata > duntil)
            continue;
      }

      if (strcmp(user,"-") == 0) {
         strcpy(user,ip);
         memset(ip,0,sizeof(ip));
      }
      fprintf(fp_ou,"%s %s%s%s %s %s %s %s\n",user,year,mon,day,hour,ip,url,list);
      squidguard_count++;
   }
   if (fp_in) fclose(fp_in);
   return;
}


void squidguard_log(void)
{
   FILE *fp_ou = NULL, *fp_guard = NULL;
   char guard_in[MAXLEN];
   char guard_ou[MAXLEN];
   char logdir[MAXLEN];
   char year[10], day[10], mon[10];
   char user[MAXLEN];
   int  y;
   int cstatus;
   char *str;
   char *str2;

   str2 = user;

   if(strlen(SquidGuardConf) < 1 && strlen(SquidGuardLogAlternate) < 1)
     return;

   if (strlen(SquidGuardLogAlternate) > 0)
      SquidGuardConf[0]='\0';

   sprintf(guard_in,"%s/squidguard.unsort",tmp);
   sprintf(guard_ou,"%s/squidguard.log",tmp);
   if((fp_ou=fopen(guard_in,"a"))==NULL) {
      fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],guard_in);
      exit(1);
   }

   bzero(day, 3);
   bzero(mon, 4);
   bzero(year, 5);

   if(strcmp(SquidguardIgnoreDate,"on") == 0) {
      if(strcmp(df,"e") == 0) {
         strncpy(day,period,2);
         strncpy(mon,period+2,3);
         strncpy(year,period+5,4);
         conv_month(mon);
         sprintf(warea,"%s%s%s",year,mon,day);
         dfrom=atoi(warea);
         strncpy(day,period+10,2);
         strncpy(mon,period+12,3);
         strncpy(year,period+15,4);
         conv_month(mon);
         sprintf(warea,"%s%s%s",year,mon,day);
         duntil=atoi(warea);
      } else {
         strncpy(day,period+7,2);
         strncpy(mon,period+4,3);
         strncpy(year,period,4);
         conv_month(mon);
         sprintf(warea,"%s%s%s",year,mon,day);
         dfrom=atoi(warea);
         strncpy(day,period+17,2);
         strncpy(mon,period+14,3);
         strncpy(year,period+10,4);
         conv_month(mon);
         sprintf(warea,"%s%s%s",year,mon,day);
         duntil=atoi(warea);
      }
   }

   if(strlen(SquidGuardConf) > 0) {
      if(access(SquidGuardConf, R_OK) != 0) {
         debuga("Cannot open squidGuard config file: %s",SquidGuardConf);
         exit(1);
      }

      if((fp_guard=fopen(SquidGuardConf,"r"))==NULL) {
         fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],SquidGuardConf);
         exit(1);
      }

      logdir[0]=0;
      while(fgets(buf,sizeof(buf),fp_guard)!=NULL) {
         if(strstr(buf,"\n") != 0)
            buf[strlen(buf)-1]='\0';
         if((str=get_param_value("logdir",buf))!=NULL) {
            if (getword(logdir,sizeof(logdir),str,' ')<0) {
               printf("SARG: Maybe you have an invalid logdir line in your %s file.\n",SquidGuardConf);
               exit(1);
            }
         } else if((str=get_param_value("log",buf))!=NULL) {
            if((str2=get_param_value("anonymous",str))!=NULL)
               str=str2;

            /*
            If logdir is defined, we prepend it to the log file name, otherwise, we assume
            the log directive provides an absolute file name to the log file. Therefore,
            we don't need to add an additionnal / at the beginning of the log file name.
            */
            y=(logdir[0]) ? sprintf(wentp,"%s/",logdir) : 0;
            /*
            Spaces are allowed in the name of the log file. The file name ends at the first #
            because it is assumed it is an end of line comment. Any space before the # is then
            removed. Any control character (i.e. a character with a code lower than 32) ends
            the file name. That includes the terminating zero.
            */
            while((unsigned char)*str>=' ' && *str!='#' && y<sizeof(wentp)-1)
               wentp[y++]=*str++;
            if(*str=='#') {
               str--;
               while(*str==' ' && y>0) {
                  str--;
                  y--;
               }
            }
            wentp[y]=0;
            read_log(wentp,fp_ou);
         }
      }
   } else {
      sprintf(wentp,"%s",SquidGuardLogAlternate);
      read_log(wentp,fp_ou);
   }

   if (fp_guard) fclose(fp_guard);
   if (fp_ou) fclose(fp_ou);

   if (files_done) {
      for (y=0; y<nfiles_done; y++)
         if (files_done[y]) free(files_done[y]);
      free(files_done);
   }

   if(debug) {
      debuga("%s: %s",text[54],guard_ou);
   }

   sprintf(tmp6,"sort -k 1,1 -k 2,2 -k 4,4 \"%s\" -o \"%s\"",guard_in, guard_ou);
   cstatus=system(tmp6);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",tmp6);
      exit(1);
   }

   unlink(guard_in);
   return;
}
