use strict;

my $block_size;
my $sorting;
my $merging;
my $single_block_sort_time;

if (@ARGV >= 1 && $ARGV[0] =~ /^-(\d+)/) {
    $single_block_sort_time = $1;
    shift @ARGV;
}

while (<>) {
    if (/^= (.*)$/) {
	$block_size = $1;
    } 
    if (/sort:.*Time: (.*)$/) {
	$sorting = tosec($1);
    } 
    if (/merge:.*Time: (.*)$/) {
	$merging = tosec($1);
	my $total = $sorting + $merging;
	printf "%d\t%d\t%d\t%d\t%d\n", 
	$block_size, $sorting, $merging, $total, $single_block_sort_time;
    }
}

sub tosec {
    my ($time) = @_;
    $time =~ /(\d\d):(\d\d):(\d\d)/;
    return $1 * 3600 + $2 * 60 + $3
}
