#! /bin/sh
test -z $1 && echo "Usage gengraph.sh <data>..." && exit

dat=$1
img=`basename $dat .dat`.png

echo // Image: $img

cat <<EOF | gnuplot > $img
set title "Costs of sorting and merging: $dat"
set xlabel "Block Size (KB)"
set ylabel "Time (sec)"
set grid
set yrange [0:]
set logscale x 2
set terminal png color
set size 0.6
plot    "$dat" using 1:2 title 'sorting' with linespoints, \
        "$dat" using 1:3 title 'merging' with linespoints, \
        "$dat" using 1:4 title 'total'   with linespoints, \
	"$dat" using 1:5 title 'single block sorting' with lines
EOF
