
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ComponentConfiguration.hh"

IIRBase_ComponentConfiguration::IIRBase_ComponentConfiguration(){
  set_component_name( NULL );
  set_entity_aspect( NULL );
  set_block_configuration( NULL );
}

IIRBase_ComponentConfiguration::~IIRBase_ComponentConfiguration(){}

void 
IIRBase_ComponentConfiguration::set_component_name( IIR *component_name ){
  my_component_name = component_name;
}

IIR *
IIRBase_ComponentConfiguration::get_component_name(){
  return my_component_name;
}

void 
IIRBase_ComponentConfiguration::set_entity_aspect( IIR_LibraryUnit *entity_aspect ){
  my_entity_aspect = entity_aspect;
}

IIR_LibraryUnit *
IIRBase_ComponentConfiguration::get_entity_aspect(){
  if( my_entity_aspect == NULL ){
    my_entity_aspect = _find_default_binding( get_component_name() );
  }
  
  return my_entity_aspect;
}

void 
IIRBase_ComponentConfiguration::set_block_configuration( IIR_BlockConfiguration *block_configuration ){
  my_block_configuration = block_configuration;
}

IIR_BlockConfiguration *IIRBase_ComponentConfiguration::get_block_configuration(){
  return my_block_configuration;
}
