
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Prashanth Cherukuri cherukps@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_SourceQuantityDeclaration.hh"
#include "savant.hh"

IIRBase_SourceQuantityDeclaration::IIRBase_SourceQuantityDeclaration() {
  set_magnitude_expression(NULL);
  set_phase_expression(NULL);
  set_noise_expression(NULL);
}

IIRBase_SourceQuantityDeclaration::~IIRBase_SourceQuantityDeclaration() {}

void
IIRBase_SourceQuantityDeclaration::set_magnitude_expression(IIR* magnitude_exp){
  this->magnitude_expression = magnitude_exp;
}

IIR*
IIRBase_SourceQuantityDeclaration::get_magnitude_expression() {
  return magnitude_expression;
}

void
IIRBase_SourceQuantityDeclaration::set_phase_expression(IIR* phase) {
  this->phase_expression = phase;
}

IIR*
IIRBase_SourceQuantityDeclaration::get_phase_expression() {
  return phase_expression;
}

void
IIRBase_SourceQuantityDeclaration::set_noise_expression(IIR* noise_exp  ) {
  this->noise_expression = noise_exp;
}

IIR*
IIRBase_SourceQuantityDeclaration::get_noise_expression() {
  return noise_expression;
}

void
IIRBase_SourceQuantityDeclaration::set_subtype(IIR_TypeDefinition * type){
  this->type= type;
}

IIR_TypeDefinition *
IIRBase_SourceQuantityDeclaration::get_subtype() {
  return type;
}
