
#ifndef IIRSCRAM_ASSERTION_STATEMENT_HH
#define IIRSCRAM_ASSERTION_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani  

#include "IIRBase_AssertionStatement.hh"

class IIR_List;
template <class type> class set;
class IIR_AboveAttribute;

class IIRScram_AssertionStatement : public IIRBase_AssertionStatement {
public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc( published_file &_cc_out );
  
  // Just to keep _report_undefined_scram_fn quiet
  void _get_list_of_input_signals( set<IIR> * );

  void _type_check();
  IIR *_clone();

  IIR *_get_assertion_condition(){ return get_assertion_condition(); }
  void _set_assertion_condition( IIR *new_expr ){ set_assertion_condition( new_expr ); }
  
  IIR *_get_report_expression(){ return get_report_expression(); }
  void _set_report_expression( IIR *new_expr ){ set_report_expression( new_expr ); }
  
  IIR *_get_severity_expression(){ return get_severity_expression(); }
  void _set_severity_expression( IIR *new_expr ){ set_severity_expression( new_expr ); }

  /** This is an assertion statement.  Returns true. */
  IIR_Boolean _is_assert_statement(){ return true; }
  
  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);
  
protected:  
  IIRScram_AssertionStatement() {};
  virtual ~IIRScram_AssertionStatement() = 0;
    
private:
};
#endif
