
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam
//          Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram_ConcurrentGenerateIfStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_ComponentDeclaration.hh"
#include "IIR_ComponentInstantiationStatement.hh"
#include "IIR_BlockStatement.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_AliasDeclaration.hh"
#include "IIR_Designator.hh"
#include "IIR_LibraryUnit.hh"
#include "IIR_LibraryDeclaration.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "set.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "symbol_table.hh"
#include "published_cc_file.hh"
#include "published_header_file.hh"
#include "sstream-wrap.hh"


IIRScram_ConcurrentGenerateIfStatement::~IIRScram_ConcurrentGenerateIfStatement(){}

void 
IIRScram_ConcurrentGenerateIfStatement::_type_check(){
  set_if_condition( _type_check_and_resolve_boolean_condition( get_if_condition() ) );
  block_declarative_part._type_check_attribute_specifications( concurrent_statement_part );
}

void 
IIRScram_ConcurrentGenerateIfStatement::_publish_vhdl(ostream &_vhdl_out) {

  _publish_vhdl_stmt_label(_vhdl_out);

  _vhdl_out << " if (";
   get_if_condition()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ") generate\n";

  if(block_declarative_part.num_elements() != 0) {
    block_declarative_part._publish_vhdl_decl(_vhdl_out);
  }

  _vhdl_out << "   begin\n";

  concurrent_statement_part._publish_vhdl(_vhdl_out);

  _vhdl_out << "   end generate ";
  if(get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << ";\n";

}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_generate_elaborate( published_file &_cc_out ){
  IIR_ArchitectureStatement *arch_stmt;
  const string temp = _get_current_architecture_name();
  const string old_current_name = _get_current_publish_name();

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_generate_elaborate" );

  ostringstream newName;

  _set_current_publish_name( "SG" );
  arch_stmt =  concurrent_statement_part.first();
  
  while (arch_stmt != NULL) {
    // Need to check if generate statements can have other concurrent
    // statements that will need elaboration. If so that check should
    // be added to the following if condition.
    
    switch (arch_stmt->get_kind())  {
    case IIR_CONCURRENT_GENERATE_FOR_STATEMENT:
    case IIR_CONCURRENT_GENERATE_IF_STATEMENT:
    case IIR_BLOCK_STATEMENT:
      arch_stmt->_publish_cc_elaborate( _cc_out );
      break;

    case IIR_PROCESS_STATEMENT:
    case IIR_COMPONENT_INSTANTIATION_STATEMENT:
      // Prevent the error message from being printed for process statementso
      break;
      
    default:
      cerr << "ERROR! IIRScram_ConcurrentGenerateIfStatement::"
	   << "_publish_cc_generate_elaborate( _cc_out ): unknown conc_statement "
	   << "type |" << arch_stmt->get_kind_text() << "|" << endl;
      break;
    }
    
    arch_stmt = concurrent_statement_part.successor(arch_stmt);
  }

  _set_current_architecture_name( temp );
  _set_current_publish_name( old_current_name );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_init( published_file &_cc_out )
{
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc( published_file &_cc_out ) {
  ostringstream ent_arch_generate_if;
  string generate_for_unit_name;
  IIR *temp                   = _get_current_publish_node();
  const string old_architecture_name = _get_current_architecture_name();
  const string old_current_name      = _get_current_publish_name();
  ostringstream arch_name;

  PublishedUnit saved_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(GENERATE_IF);
  _set_current_publish_node( this );
  
  ent_arch_generate_if << _get_current_entity_name()
			<< "_" << _get_current_architecture_name();
  _publish_cc_enclosing_stmt_to_architecture_path(ent_arch_generate_if);
  ent_arch_generate_if << "_" <<*_get_label() << "_waits";
  
  generate_for_unit_name = ent_arch_generate_if.str();
  _publish_cc_declarations();

  published_header_file header_file( _get_work_library()->_get_path_to_directory(), 
				     generate_for_unit_name,
				     this );
  SCRAM_CC_REF( header_file, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc" );
  header_file << "#define " << generate_for_unit_name << "_WAITS_HH\n" << NL();
  header_file << "class State;\n\n";

  published_cc_file cc_file( _get_work_library()->_get_path_to_directory(), 
			     generate_for_unit_name,
			     this );
  SCRAM_CC_REF( cc_file, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc" );

  _set_current_publish_name( "SG" );
  concurrent_statement_part._publish_cc( cc_file );

  _set_current_publish_name( old_current_name );
  _set_current_architecture_name( old_architecture_name );
  
  _set_current_publish_node( temp );

  _set_currently_publishing_unit(saved_publishing_unit);
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_declarations( ){
  string generate_unit_name;
  ostringstream ent_arch_generate;

  ent_arch_generate << _get_current_entity_name() << "_"
		    << _get_current_architecture_name();
  _publish_cc_enclosing_stmt_to_architecture_path(ent_arch_generate);
  ent_arch_generate << "_" << *_get_label();
  generate_unit_name = ent_arch_generate.str();

  published_header_file header_file( _get_work_library()->_get_path_to_directory(), 
				     generate_unit_name,
				     this );
  SCRAM_CC_REF( header_file, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_declarations" );

  header_file << "#include\"";
  header_file << _get_current_entity_name() << "_" << _get_current_architecture_name();
  _publish_cc_enclosing_stmt_to_architecture_path( header_file.get_stream() );
  header_file << ".hh\"\n\n";

  block_declarative_part._publish_cc( header_file );

  published_cc_file cc_file( _get_work_library()->_get_path_to_directory(), 
			     generate_unit_name,
			     this );
  SCRAM_CC_REF( cc_file, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_declarations" );

  cc_file << "#include \"" << generate_unit_name << ".hh\"\n\n";

  block_declarative_part._publish_cc_decl( cc_file );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_class( published_file &_cc_out ) {
  _publish_cc_class_generate_stmt( _cc_out );
}


void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_headerfile(){
  ostringstream filename;
  _publish_cc_class_name(filename);
  string filename_ptr = filename.str();
  
  published_header_file header_file( _get_work_library()->_get_path_to_directory(), 
				     filename_ptr,
				     this );
  
  SCRAM_CC_REF( header_file, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_headerfile" );

  header_file << "#include \"";
  ASSERT ( _get_enclosing_scope() != NULL );
  _get_enclosing_scope()->_publish_cc_class_name(header_file.get_stream());
  header_file << ".hh\"\n";

  // Include the current declarative region 
  header_file << "#include \"";
  header_file << _get_current_entity_name() << "_"
	      << _get_current_architecture_name();
  _publish_cc_enclosing_stmt_to_architecture_path( header_file.get_stream() );
  header_file << "_" << *_get_label() << ".hh\"\n";

  // Request the Hierarchy.hh for our hierarchy stuff
  IIRScram::_publish_cc_include( header_file, "tyvis/Hierarchy.hh" );

  //  _publish_cc_headers( header_file );
  header_file << "\n";
  _publish_cc_class_includes( header_file, &concurrent_statement_part );
  header_file << "\n";
  _publish_cc_class( header_file );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_elaborate( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_elaborate" );

  _publish_cc_headerfile();
  _publish_cc_ccfile();
  _publish_cc_generate_elaborate( _cc_out );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_ccfile( ){
  ostringstream filename;

  _publish_cc_class_name(filename);
  published_cc_file cc_file( _get_work_library()->_get_path_to_directory(), 
			     filename.str(),
			     this );
  SCRAM_CC_REF( cc_file, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_ccfile" );

  cc_file << "#include \"" << filename.str() << ".hh\"\n\n";
  _publish_cc_headerfiles_for_cc( cc_file );

  _publish_cc_constructor( cc_file );
  _publish_cc_destructor( cc_file, &concurrent_statement_part );
  _publish_cc_instantiate( cc_file );
  _publish_cc_createNetInfo( cc_file );
  _publish_cc_connect( cc_file );

}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_headerfiles_for_cc( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_headerfiles_for_cc" );

  _publish_cc_headerfiles_for_cc_generate_statement( _cc_out );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_constructor( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_constructor" );

  _publish_cc_constructor_with_no_arguments( _cc_out );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_constructor_with_no_arguments( published_file &_cc_out )
{

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_constructor_with_no_arguments" );
  _cc_out << _get_cc_elaboration_class_name() << "::"
	  << _get_cc_elaboration_class_name() << "(";

  _cc_out << _get_current_publish_name() << _get_current_entity_name() << "_"
   	  << _get_current_architecture_name();
  _publish_cc_enclosing_stmt_to_architecture_path( _cc_out.get_stream() );

  _cc_out << "_elab* outerScope)  {\n";

  _cc_out << "  enclosingScope = outerScope;\n";

  _publish_cc_generate_condition( _cc_out );
  _cc_out << "{\n";
  _publish_cc_object_pointers_init( _cc_out );
  _cc_out << "}\n}\n";
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_signal_objects_init( published_file &_cc_out,
									IIR_Boolean firstDeclFlag){
  IIR_Declaration *decl;
  int first = 0;

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_signal_objects_init" );

  decl = block_declarative_part.first();

  while (decl != NULL) {
    if (decl->get_kind() == IIR_SIGNAL_DECLARATION) {
      if ((first == 0) && (firstDeclFlag == TRUE)) {
	_cc_out << ":\n";
	first = 1;
      }
      else {
	_cc_out << ",\n";
      }
      
      decl->_publish_cc_elaborate( _cc_out );
      _cc_out << "(ObjectBase::SIGNAL_NETINFO";

      if (((decl->get_subtype()->_is_array_type() == TRUE) ||
	   (decl->get_subtype()->_is_record_type() ==  TRUE)) &&
	  (decl->get_subtype()->_is_access_type() == FALSE)) {
	decl->get_subtype()->_publish_cc_object_type_info( _cc_out );
	_cc_out << ", ";
	decl->get_subtype()->_publish_cc_resolution_function_id( _cc_out );
	
	if (decl->get_subtype()->_is_anonymous() == TRUE) {
	  _cc_out << ", ";
	  decl->get_subtype()->_publish_cc_range( _cc_out );
	}
      }
      
      _cc_out <<  ")";
      
      if( decl->_get_implicit_declarations() != NULL &&
	  decl->_get_implicit_declarations()->num_elements() != 0 ) {
	IIR_Declaration* imp_decl = decl->_get_implicit_declarations()->get_element();
	while (imp_decl != NULL) {
	  if (imp_decl->get_kind() == IIR_SIGNAL_DECLARATION) {
	    _cc_out << ",\n";
	    imp_decl->_publish_cc_elaborate( _cc_out );
	    _cc_out << "(ObjectBase::SIGNAL_NETINFO";

	    if (((imp_decl->get_subtype()->_is_array_type() == TRUE) ||
		 (imp_decl->get_subtype()->_is_record_type() ==  TRUE)) &&
		(imp_decl->get_subtype()->_is_access_type() ==  FALSE)) {
	      imp_decl->get_subtype()->_publish_cc_object_type_info(_cc_out);
	      _cc_out << ", ";
	      imp_decl->get_subtype()->_publish_cc_resolution_function_id( _cc_out );
	      
	      if (imp_decl->get_subtype()->_is_anonymous() == TRUE) {
		_cc_out << ", ";
		imp_decl->get_subtype()->_publish_cc_range( _cc_out );
	      }
	    }
	    
	    _cc_out << ")";
	  }
	  imp_decl = decl->_get_implicit_declarations()->get_next_element();
	}
      }
    }
    else if (decl->get_kind() == IIR_ALIAS_DECLARATION) {
      if (((IIR_AliasDeclaration *) decl)->get_name()->_is_signal()) {
	if ((first == 0) && (firstDeclFlag == 1)) {
	  _cc_out << ":\n";
	  first = 1;
	}
	else {
	  _cc_out << ",\n";
	}
	((IIR_AliasDeclaration *) decl)->_publish_cc_elaborate_alias_init( _cc_out );
      }
    }
    
    decl = block_declarative_part.successor(decl);
  }
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_object_pointers_init( published_file &_cc_out ){
  const string temp = _get_current_architecture_name();
  const string old_current_name = _get_current_publish_name();
  ostringstream newName;
  IIR_ArchitectureStatement *arch_stmt;
  IIR_Boolean found = FALSE;
  int wanted_instantiation = 1;
  IIR_ConfigurationSpecification *config_spec_decl = NULL;
  IIR* tempNode;

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_object_pointers_init" );

  _set_current_publish_name( "SG" );
  
  arch_stmt = concurrent_statement_part.first();

  while (arch_stmt != NULL) {
    switch(arch_stmt->get_kind()) {
    case IIR_PROCESS_STATEMENT:
      if (arch_stmt->_get_label() != NULL) {
	_cc_out << *(arch_stmt->_get_label());
      }
      else {
	_cc_out << "ANON_PROCESS" << arch_stmt;
      }
      _cc_out << "_elab_obj = NULL;\n";
      break;

    case IIR_COMPONENT_INSTANTIATION_STATEMENT:
      IIR_ComponentDeclaration *componentName;
      componentName = (IIR_ComponentDeclaration *) arch_stmt->get_instantiated_unit();
      ASSERT(componentName->get_kind() == IIR_COMPONENT_DECLARATION);

      _cc_out << *arch_stmt->_get_label()
	      << "_elab_obj = new "
	      << componentName->_get_cc_elaboration_class_name()
	      << ";\n";

      arch_stmt->_get_label()->_get_declarator()->_publish_cc_lvalue( _cc_out );
      _cc_out << "_elab_obj->boundedEntity = ";

      IIR_Declaration *decl;
      decl = block_declarative_part.first();
      while ((decl != NULL) && (found == FALSE)) {
	if (decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION) {
	  config_spec_decl = (IIR_ConfigurationSpecification *) decl;
	  IIR_TextLiteral *local_componentName = componentName->get_declarator();
	  ASSERT(TRUE == config_spec_decl->get_component_name()->_is_iir_declaration());
	  IIR_TextLiteral *binding_componentName = ((IIR_Declaration *) config_spec_decl->get_component_name())->get_declarator();

	  if (0 == IIR_TextLiteral::_cmp(local_componentName, binding_componentName)) {
	    IIR_Designator *designator = config_spec_decl->instantiation_list.first();

	    while ((designator != NULL) && (found == FALSE)) {
	      switch(designator->get_kind()) {
	      case IIR_DESIGNATOR_EXPLICIT:
		ASSERT(designator->_get_name()->_is_iir_declaration() == TRUE);

		wanted_instantiation = IIR_TextLiteral::_cmp(((IIR_Declaration *) designator->_get_name())->get_declarator(), arch_stmt->get_label()->get_declarator());
		if (wanted_instantiation == 0) {
		  found = TRUE;
		  config_spec_decl = ((IIR_ConfigurationSpecification *) decl);
		}
		break;

	      case IIR_DESIGNATOR_BY_ALL:
		found = TRUE;
		config_spec_decl = ((IIR_ConfigurationSpecification *) decl);
		break;

	      default:
		break;
	      }

	      designator = config_spec_decl->instantiation_list.successor(designator);
	    }
	  }
	}

	decl = block_declarative_part.successor(decl);
      }

      if (found == FALSE) {
	_cc_out << " NULL;\n";
      }
      else {
	_cc_out << " new ";
	if (config_spec_decl->get_entity_aspect() != NULL) {
	  _cc_out << config_spec_decl->get_entity_aspect()->_get_cc_elaboration_class_name()
		  << "(";
	  tempNode = _get_current_publish_node();
	  _set_current_publish_node( arch_stmt );
	  config_spec_decl->generic_map_aspect._publish_cc_lvalue( _cc_out );
	  _cc_out << ");\n";
	  config_spec_decl->_publish_cc_port_map_aspect( _cc_out );
	  _set_current_publish_node( tempNode );
	}
	  
	found = FALSE;
	wanted_instantiation = 1;
      }
      break;

    case IIR_BLOCK_STATEMENT:
      arch_stmt->_get_label()->_publish_cc_elaborate( _cc_out );
      _cc_out << "_elab_obj = new "
	      << _get_cc_elaboration_class_name() << "(this";
      
      if ( ((IIR_BlockStatement *) arch_stmt)->generic_map_aspect.num_elements() > 0) {
	_cc_out << ", \n";
	tempNode = _get_current_publish_node();
	_set_current_publish_node( arch_stmt );
	arch_stmt->_get_generic_map_aspect()->_publish_cc_generic_map_aspect_for_conc_stmts( _cc_out );
	_set_current_publish_node( tempNode );
      }
      
      _cc_out << ");\n";
      break;

    case IIR_CONCURRENT_GENERATE_FOR_STATEMENT:
    case IIR_CONCURRENT_GENERATE_IF_STATEMENT:
      arch_stmt->_get_label()->_publish_cc_elaborate( _cc_out );
      _cc_out << "_elab_obj = new "
	      << _get_cc_elaboration_class_name()
	      << "(this);\n";
      break;

    default:
      cerr << "ERROR! IIRScram_ConcurrentGenerateIfStatement::"
	   << "_publish_cc_object_pointers_init( _cc_out ): unknown conc_statement "
	   << "type |" << arch_stmt->get_kind_text() << "|" << endl;
      break;
    }

    found = FALSE;
    arch_stmt = concurrent_statement_part.successor(arch_stmt);
  }

  _set_current_architecture_name( temp );
  _set_current_publish_name( old_current_name );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_generate_condition( published_file &_cc_out )
{

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_generate_condition" );

  _cc_out << "  if (";
  get_if_condition()->_publish_cc_lvalue( _cc_out );
  _cc_out << " == SAVANT_BOOLEAN_TRUE)  \n";
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_instantiate( published_file &_cc_out )
{
  IIR_ArchitectureStatement *arch_stmt;

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_instantiate" );
  
  _cc_out << "void\n" << _get_cc_elaboration_class_name() << "::instantiate(Hierarchy * hier)  {\n";

  _publish_cc_generate_condition( _cc_out );
  _cc_out << "{\n";

  arch_stmt = concurrent_statement_part.first();
  while (arch_stmt != NULL) {
    arch_stmt->_publish_cc_instantiate_call( _cc_out );
    arch_stmt = concurrent_statement_part.successor(arch_stmt);
  }
  _cc_out << "\ncreateNetInfo();\n";
  _cc_out << "  }\n";
  _cc_out << "}\n";  
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_body_for_component_createNetInfo( published_file &_cc_out,
										      IIR_ArchitectureStatement *arch_stmt){
  ostringstream labelname;
  ostringstream objectname;
  int wanted_instantiation = 1;
  IIR_Boolean found = false;
  IIR_EntityDeclaration* bindingEntity = 0;
  int noofelements = 0;

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_body_for_component_createNetInfo" );
  
  labelname << *arch_stmt->_get_label() << "_elab_obj->";
  _set_current_elab_name( labelname.str() );

  IIR* componentName = arch_stmt->get_instantiated_unit();      
  if(componentName->get_kind() == IIR_COMPONENT_DECLARATION) {
    IIR_Declaration* decl = block_declarative_part.first();
    while( decl != NULL ){
      if( decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION ){
	IIR_TextLiteral* local_componentName = componentName->_get_declarator();
	IIR_TextLiteral* binding_componentName = ((IIR_ConfigurationSpecification*)decl)->get_component_name()->_get_declarator();
	if(IIR_TextLiteral::_cmp(local_componentName, 
				 binding_componentName) == 0) {
	  IIR_Designator* designator = decl->_get_instantiation_list()->first();
	  while(designator != NULL) {
	    switch(designator->get_kind()) {
	    case IIR_DESIGNATOR_EXPLICIT:
	      wanted_instantiation = IIR_TextLiteral::_cmp(((IIR_Declaration *) designator->_get_name())->get_declarator(), arch_stmt->_get_label()->get_declarator());
	      if(wanted_instantiation == 0) {
		found = TRUE;
		if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() == 0) {
		  _set_current_publish_node( componentName );
		  objectname << "(( ";
		  IIR_LibraryUnit* lib_unit = decl->_get_entity_aspect(); 
		  if(lib_unit != NULL) {
		    lib_unit->_publish_cc_binding_name(objectname);
		    bindingEntity = lib_unit->_get_entity();
		  }
		  objectname << "_elab*) " << *arch_stmt->_get_label();
		  objectname << "_elab_obj->boundedEntity)->";
		  _set_current_publish_name( objectname.str() );
		  bindingEntity->port_clause._publish_cc_port_map_aspect( _cc_out );
		}
		else {
		  _set_current_publish_node( componentName );
		  objectname << "(( ";
		  IIR_LibraryUnit* lib_unit = decl->_get_entity_aspect(); 
		  if( lib_unit != NULL ){
		    lib_unit->_publish_cc_binding_name(objectname);
		    bindingEntity = lib_unit->_get_entity();
		  }
		  objectname << "_elab*) " << *arch_stmt->_get_label();
		  objectname << "_elab_obj->boundedEntity)->";
		  _set_current_publish_name( objectname.str() );
		  noofelements = ((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements();
		  if(noofelements != 0) {
		    ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate( _cc_out );
		  }
		  else {
		    IIR_LibraryUnit* binding_unit =((IIR_ConfigurationSpecification*)decl)->get_entity_aspect();
		    if(binding_unit!= NULL) {
		      binding_unit->_get_entity()->port_clause._publish_cc_port_map_aspect( _cc_out );
		    }
		  }
		}
	      }
	      break;
	    case IIR_DESIGNATOR_BY_ALL:
	    case IIR_DESIGNATOR_BY_OTHERS:
	      found = TRUE;
	      if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() == 0) {
		_set_current_publish_node( componentName );
		objectname << "(( ";
		IIR_LibraryUnit *lib_unit = decl->_get_entity_aspect(); 
		if(lib_unit != NULL) {
		  lib_unit->_publish_cc_binding_name(objectname);
		  bindingEntity = lib_unit->_get_entity();
		}
		objectname << "_elab*) " << *(arch_stmt->_get_label());
		objectname << "_elab_obj->boundedEntity)->";
		_set_current_publish_name( objectname.str() );
		bindingEntity->port_clause._publish_cc_port_map_aspect( _cc_out );
	      }
	      else {
		_set_current_publish_node( componentName );
		objectname << "(( ";
		IIR_LibraryUnit *lib_unit = decl->_get_entity_aspect();
		if(lib_unit != NULL) {
		  lib_unit->_publish_cc_binding_name(objectname);
		  bindingEntity = lib_unit->_get_entity();
		}
		objectname << "_elab*) " << *arch_stmt->_get_label();
		objectname << "_elab_obj->boundedEntity)->";
		_set_current_publish_name( objectname.str() );
		noofelements = ((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements();
		if(noofelements != 0) {
		  ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate( _cc_out );
		}
		else {
		  IIR_LibraryUnit* binding_unit = decl->_get_entity_aspect();
		  if( binding_unit!= NULL ){
		    binding_unit->_get_entity()->port_clause._publish_cc_port_map_aspect( _cc_out );
		  }
		}
	      }
	      break;

	    default:
	      break;
	    }
	    if( found == TRUE ){
	      designator = NULL;
	    }
	    else {
	      designator =decl->_get_instantiation_list()->successor(designator);
	    }
	  }
	}
      }
      if(found == TRUE) {
	decl = NULL;
      }
      else {
	decl = block_declarative_part.successor(decl);
      }
    }
  }
  
  objectname << *arch_stmt->_get_label() << "_elab_obj";
  _set_current_elab_name( objectname.str() );
  arch_stmt->_publish_createNetInfo( _cc_out );
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_createNetInfo( published_file &_cc_out ) {
  IIR_ArchitectureStatement *arch_stmt;
  IIR_Boolean found = false;
  int wanted_instantiation = 1;
  const string tmp = _get_current_elab_name();
  const string tmp2 = _get_current_publish_name();
  IIR* tmpNode   = _get_current_publish_node();
  PublishedUnit old_publish_unit = _get_currently_publishing_unit();

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_createNetInfo" );

  _set_currently_publishing_unit(IIRScram::GENERATE_IF);
 
  _cc_out << "void\n"
	  << _get_cc_elaboration_class_name()
	  << "::createNetInfo(){\n";

  _publish_cc_generate_condition( _cc_out );
  _cc_out << "{\n";
  
  arch_stmt = concurrent_statement_part.first();
  while (arch_stmt != NULL) {
    ostringstream objectname;
    ostringstream labelname;
    _set_current_publish_name( "" );
    _set_current_publish_node( this );
    
    if (arch_stmt->get_kind() == IIR_PROCESS_STATEMENT) {
      if(arch_stmt->_get_label() != NULL) {
	objectname << *(arch_stmt->_get_label());
      }
      else {
	objectname << "ANON_PROCESS" << arch_stmt;
      }
      objectname << "_elab_obj";
      _set_current_elab_name( objectname.str() );
      arch_stmt->_publish_createNetInfo( _cc_out );
    }
    else if ((arch_stmt->get_kind() == IIR_BLOCK_STATEMENT) ||
	     (arch_stmt->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT) || (arch_stmt->get_kind() == IIR_CONCURRENT_GENERATE_IF_STATEMENT)) {
    }
    else if (arch_stmt->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT) {
      _publish_cc_body_for_component_createNetInfo( _cc_out, arch_stmt );
    }
    else {
      cerr << "ERROR! IIRScram_ConcurrentGenerateIfStatement::"
	   << "_publish_cc_createNetInfo( _cc_out ): unknown conc_statement "
	   << "type |" << arch_stmt->get_kind_text() << "|" << endl;
    }
    _set_current_elab_name( "" );
    found = FALSE;
    wanted_instantiation = 1;
    arch_stmt = concurrent_statement_part.successor(arch_stmt);
  }
  _cc_out << "}\n}\n\n";
  _set_current_elab_name( tmp );
  _set_current_publish_name( tmp2 );
  _set_current_publish_node( tmpNode );
  _set_currently_publishing_unit(old_publish_unit);
}

void
IIRScram_ConcurrentGenerateIfStatement::_publish_cc_connect( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_ConcurrentGenerateIfStatement::_publish_cc_connect" );

  _cc_out << "void" << NL()
	  << _get_cc_elaboration_class_name()
	  << OS("::connect( int inputsignals, int outputsignals, ... ){") << NL()
	  << "int noOfSignals = inputsignals + outputsignals;" << NL()
	  << "va_list ap;" << NL();
  _publish_cc_generate_condition( _cc_out );
  _cc_out << OS("{") << NL()
	  << "va_start(ap, outputsignals);" << NL()
	  << OS("for( int i = 0; i < noOfSignals; i++ ){") << NL()
	  << "addToFanOut( va_arg(ap, VHDLType*) );" << NL()
	  << CS("}") << NL()
	  << "va_end(ap);" << NL();

  IIR_ArchitectureStatement *arch_stmt;
  arch_stmt = concurrent_statement_part.first();
  while( arch_stmt != NULL ){
    ostringstream objectname;
    if (arch_stmt->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT) {
      objectname << *arch_stmt->_get_label() << "_elab_obj";
      _set_current_elab_name( objectname.str() );
      static_cast<IIR_ComponentInstantiationStatement*>(arch_stmt)->_publish_connect( _cc_out );
    }
    else if (arch_stmt->_is_concurrent_generate_statement() == TRUE) {
      arch_stmt->_get_label()->_publish_cc_elaborate( _cc_out );
      _cc_out << "_elab_obj->connect(0, 0);" << NL();
    }
    else if (arch_stmt->_is_block_statement() == TRUE) {
      static_cast<IIR_BlockStatement *>(arch_stmt)->_publish_connect( _cc_out );
    }
    arch_stmt = concurrent_statement_part.successor(arch_stmt);
  }
  _cc_out << CS("}") << CS("}") << NL();
}

IIR_DeclarationList*
IIRScram_ConcurrentGenerateIfStatement::_get_declaration_list() {
  return &block_declarative_part;
}

IIR_Label *
IIRScram_ConcurrentGenerateIfStatement::_find_instantiate_label( IIR_SimpleName *to_find ){
  return concurrent_statement_part._find_instantiate_label( to_find );
}

visitor_return_type *IIRScram_ConcurrentGenerateIfStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ConcurrentGenerateIfStatement(this, arg);
};
